<?php
// ---- ECUPRATIX Session Diagnostics ----
// Put this file next to index.php and open it in browser.

// Force predictable cookie behavior
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);

// If your site is HTTPS, these help (may be overridden by host)
if (!headers_sent()) {
  ini_set('session.cookie_httponly', 1);
  ini_set('session.cookie_samesite', 'Lax');
  if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') {
    ini_set('session.cookie_secure', 1);
  }
}

// Optional custom save path (matches .user.ini)
$customPath = __DIR__ . '/php_sessions';
if (is_dir($customPath) && is_writable($customPath)) {
  session_save_path($customPath);
}

session_start();

if (!isset($_SESSION['counter'])) {
  $_SESSION['counter'] = 0;
}
$_SESSION['counter']++;

$ok = true;
$errors = [];

// Diagnostics
$savePath = session_save_path();
if (!is_dir($savePath)) {
  $ok = false;
  $errors[] = "session.save_path is not a directory: $savePath";
} else if (!is_writable($savePath)) {
  $ok = false;
  $errors[] = "session.save_path is not writable: $savePath";
}

$cookieParams = session_get_cookie_params();

header('Content-Type: text/plain; charset=UTF-8');

echo ($ok ? "SESSION OK" : "SESSION PROBLEM") . "\n";
echo "\n";
echo "Session ID: " . session_id() . "\n";
echo "Counter   : " . $_SESSION['counter'] . "\n";
echo "\n";
echo "Diagnostics\n";
echo "-----------\n";
echo "PHP Version           : " . PHP_VERSION . "\n";
echo "SAPI                 : " . php_sapi_name() . "\n";
echo "session.save_path     : " . $savePath . "\n";
echo "session.gc_maxlifetime: " . ini_get('session.gc_maxlifetime') . "\n";
echo "session.cookie_lifetime: " . ini_get('session.cookie_lifetime') . "\n";
echo "Cookie params         : " . json_encode($cookieParams) . "\n";
echo "HTTPS                 : " . (!empty($_SERVER['HTTPS']) ? $_SERVER['HTTPS'] : 'no') . "\n";
echo "Host                  : " . ($_SERVER['HTTP_HOST'] ?? '') . "\n";
echo "\n";
if (!$ok) {
  echo "Errors\n";
  echo "------\n";
  foreach ($errors as $e) echo "- $e\n";
}
