<?php
session_start();
if(($_SESSION['role']??'')!=='admin'){ header('Location: login.php'); exit; }
?>
<!DOCTYPE html>
<html lang="tr" data-bs-theme="dark">
<head>
  <meta charset="UTF-8">
  <title>ECU PRATIX - SIMÜLATÖR</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
  <style>
    body{background:#070a12;}
    .cardx{background:rgba(255,255,255,.04);border:1px solid rgba(255,255,255,.10);border-radius:16px}
    .muted{opacity:.75}
    .pill{display:inline-flex;align-items:center;gap:.35rem;padding:.35rem .6rem;border-radius:999px;background:rgba(255,255,255,.06);border:1px solid rgba(255,255,255,.10)}
  </style>

<style id="swal-force-white-visible">
/* === FORCE SWEETALERT TEXT VISIBLE (WHITE) === */
.swal2-title,
.swal2-html-container,
.swal2-content,
.swal2-popup{
  color:#ffffff !important;
  opacity:1 !important;
  filter:none !important;
  mix-blend-mode:normal !important;
}
.swal2-title{ font-weight:900 !important; }
.swal2-html-container{ font-weight:900 !important; }

.ecu-swal-title,
.ecu-swal-html{
  color:#ffffff !important;
  opacity:1 !important;
}

.swal-table-notfound{
  color:#ffffff !important;
  font-weight:900 !important;
  font-size:18px !important;
  line-height:1.35 !important;
  text-align:center !important;
  text-shadow: 0 0 10px rgba(0,0,0,0.9) !important;
}
</style>

</head>
<body class="text-light">
<div class="container-fluid p-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <div class="h4 mb-0"><i class="bi bi-flask2"></i> Admin Simülatör</div>
      <div class="muted">Test BIN yükle → profil eşleşmesi (ADDR/SIM) + tüm DTC önizleme</div>
    </div>
    <div class="d-flex gap-2">
      <a href="admin.php" class="btn btn-outline-light"><i class="bi bi-arrow-left"></i> Admin</a>
      <a href="#" id="btnLogout" class="btn btn-outline-danger"><i class="bi bi-box-arrow-right"></i> Çıkış</a>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-lg-4">
      <div class="cardx p-3">
        <div class="mb-2 fw-semibold">Simülasyon</div>

        <label class="form-label">Profil (opsiyonel)</label>
        <select id="profileSelect" class="form-select mb-3">
          <option value="">Otomatik (en iyi)</option>
        </select>

        <label class="form-label">Test BIN</label>
        <input type="file" id="binFile" class="form-control mb-3" accept=".bin,.ori,.mod,.hex,*/*">

        <button id="btnRun" class="btn btn-primary w-100"><i class="bi bi-play-fill"></i> Çalıştır</button>

        <hr class="my-3">

        <div class="d-flex flex-wrap gap-2">
          <span class="pill">SIM: <b id="simVal">-</b></span>
          <span class="pill">ADDR: <b id="addrVal">-</b></span>
          <span class="pill">DTC: <b id="dtcVal">-</b></span>
        </div>

        <div class="mt-3 muted" id="bestProfileText">Profil: -</div>
      </div>
    </div>

    <div class="col-lg-8">
      <div class="cardx p-3">
        <div class="d-flex align-items-center justify-content-between mb-2">
          <div class="fw-semibold">DTC Önizleme (Tümü)</div>
          <div class="muted small">Arama + sayfalama DataTables</div>
        </div>
        <div class="table-responsive">
          <table id="dtcTable" class="table table-sm table-dark table-striped align-middle mb-0" style="width:100%">
            <thead>
              <tr>
                <th>#</th>
                <th>DTC</th>
                <th>Type</th>
                <th>Source</th>
                <th>Addr</th>
                <th>Row</th>
                <th>Raw</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
function loadProfiles(){
  $.post('api.php', {action:'get_profiles'}, function(r){
    if(!r || r.status!=='ok') return;
    const sel = $('#profileSelect');
    (r.profiles||[]).forEach(function(p, idx){
      const id = (p.id!==undefined) ? p.id : idx;
      const name = (p.name||('Profile '+id));
      const brand = (p.brand||'');
      const ecu = (p.ecu_model||'');
      sel.append(`<option value="${id}">${name}${brand?(' • '+brand):''}${ecu?(' • '+ecu):''}</option>`);
    });
  }, 'json');
}

let dt;
function initTable(){
  dt = $('#dtcTable').DataTable({
    pageLength: 50,
    lengthMenu: [25,50,100,200,500,1000],
    order: [[0,'asc']]
  });
}
function setRows(rows){
  dt.clear();
  for(let i=0;i<rows.length;i++){
    const r=rows[i];
    dt.row.add([
      i+1,
      r.dtc || r.code || '',
      r.type || '',
      r.table || r.source || '',
      r.addr_hex || r.addr || '',
      (r.row_index!==undefined ? r.row_index : ''),
      r.raw_hex || r.raw || ''
    ]);
  }
  dt.draw();
}

$('#btnRun').on('click', function(){
  const f = $('#binFile')[0].files[0];
  if(!f){
    Swal.fire('Hata','Test BIN seçmedin.','error'); return;
  }
  const fd = new FormData();
  fd.append('action','admin_simulator_run');
  fd.append('profile_id',$('#profileSelect').val());
  fd.append('bin', f);

  $('#btnRun').prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> Çalışıyor...');
  $.ajax({
    url:'api.php',
    method:'POST',
    data: fd,
    processData: false,
    contentType: false,
    dataType: 'json'
  }).done(function(r){
    if(!r || r.status!=='ok'){
      Swal.fire('Hata', (r&&r.msg)?r.msg:'API hata', 'error');
      return;
    }
    const b = r.best;
    $('#simVal').text(b.similarity===null || b.similarity===undefined ? '-' : (Number(b.similarity).toFixed(2)+'%'));
    $('#addrVal').text(Number(b.addr_score||0).toFixed(1)+'%');
    $('#dtcVal').text(b.dtc_count||0);
    $('#bestProfileText').text(`Profil: ${b.name||''}  (ID: ${b.id})`);
    setRows(b.dtc||[]);
  }).fail(function(xhr){
    Swal.fire('Hata','API erişilemiyor.','error');
  }).always(function(){
    $('#btnRun').prop('disabled', false).html('<i class="bi bi-play-fill"></i> Çalıştır');
  });
});

$('#btnLogout').on('click', function(e){
  e.preventDefault();
  $.post('api.php', {action:'logout'}, function(){ window.location='login.php'; });
});

$(function(){ loadProfiles(); initTable(); });
</script>

<script id="swal-force-white-visible-js">
(function(){
  try{
    if(!window.Swal) return;
    if(window.Swal.__forceWhiteVisible) return;
    window.Swal.__forceWhiteVisible = true;

    var Swal = window.Swal;
    var oldFire = Swal.fire.bind(Swal);

    Swal.fire = function(a,b,c){
      var opts;
      if(a && typeof a === 'object'){
        opts = Object.assign({}, a);
      }else{
        opts = { title: (a||''), text: (b||''), icon: c };
      }

      var all = String((opts.title||'') + ' ' + (opts.text||'') + ' ' + (opts.html||'')).toUpperCase();

      // Replace any "table not found" style message
      if(all.indexOf('TABLO') !== -1 && (all.indexOf('BULUNAM') !== -1 || all.indexOf('UYGUN') !== -1)){
        opts.icon = 'warning';
        opts.title = '';
        opts.html = '<div style="width:100%;margin:-6px 0 12px 0;"><img src="data:image/svg+xml;base64,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" alt="binary" style="width:100%;max-height:140px;object-fit:cover;border-radius:14px;display:block;opacity:0.95;border:1px solid rgba(0,255,154,.20);box-shadow:0 0 22px rgba(0,255,154,.10);"></div>'+ '<div class="swal-table-notfound">UYGUN TABLO BULUNAMADI.<br>LÜTFEN ADMİNDEN TABLO TALEP EDİNİZ.</div>';
        delete opts.text;
      }

      var userDidOpen = opts.didOpen;

      opts.didOpen = function(el){
        try{
          var popup = Swal.getPopup && Swal.getPopup();
          if(popup){
            popup.style.setProperty('opacity','1','important');
            popup.style.setProperty('filter','none','important');
            popup.style.setProperty('background','#000000','important');
          }
          var t = Swal.getTitle && Swal.getTitle();
          if(t){
            t.style.setProperty('color','#ffffff','important');
            t.style.setProperty('opacity','1','important');
            t.style.setProperty('font-weight','900','important');
          }
          var h = Swal.getHtmlContainer && Swal.getHtmlContainer();
          if(h){
            h.style.setProperty('color','#ffffff','important');
            h.style.setProperty('opacity','1','important');
            h.style.setProperty('font-weight','900','important');
          }
        }catch(e){}
        if(typeof userDidOpen === 'function'){ try{ userDidOpen(el); }catch(e){} }
      };

      return oldFire(opts);
    };
  }catch(e){}
})();
</script>

</body>
</html>
