<!DOCTYPE html>
<html lang="tr" data-bs-theme="dark">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Giriş | ECUPRATIX GEN3</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <style>
    :root{
      --bg0:#05070d;
      --bg1:#070b18;
      --card:rgba(16, 20, 35, .74);
      --card2:rgba(16, 20, 35, .56);
      --stroke:rgba(255,255,255,.10);
      --stroke2:rgba(255,255,255,.16);
      --text:#eaf0ff;
      --muted:rgba(234,240,255,.72);
      --accent:#6ae4ff;
      --accent2:#8b5cff;
      --ok:#2cffb3;
      --danger:#ff5c7a;
      --shadow: 0 30px 90px rgba(0,0,0,.55);
      --radius: 22px;
      --radius2: 16px;
      --font: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji","Segoe UI Emoji";
    }

    *{ box-sizing:border-box; }
    html,body{ height:100%; }
    body{
      margin:0;
      font-family:var(--font);
      color:var(--text);
      overflow:hidden;
      background:
        radial-gradient(1100px 700px at 20% 20%, rgba(106,228,255,.18), transparent 55%),
        radial-gradient(900px 600px at 80% 30%, rgba(139,92,255,.14), transparent 55%),
        radial-gradient(1000px 800px at 50% 100%, rgba(44,255,179,.08), transparent 60%),
        linear-gradient(180deg, var(--bg0), var(--bg1));
    }

    /* ECU background image */
    .bg-img{
      position:absolute; inset:0;
      background: url("assets/img/ecu_vector.jpg") center/cover no-repeat;
      opacity:.22;
      filter: saturate(0.9) contrast(1.05);
      transform: scale(1.02);
    }
    .bg-vignette{
      position:absolute; inset:0;
      background:
        radial-gradient(1200px 700px at 40% 40%, transparent 40%, rgba(0,0,0,.55) 80%),
        linear-gradient(90deg, rgba(0,0,0,.65), rgba(0,0,0,.25) 40%, rgba(0,0,0,.70));
      pointer-events:none;
    }

    /* Animated grid / scanlines */
    .grid{
      position:absolute; inset:-200px;
      background-image:
        linear-gradient(rgba(255,255,255,.06) 1px, transparent 1px),
        linear-gradient(90deg, rgba(255,255,255,.06) 1px, transparent 1px);
      background-size: 70px 70px;
      transform: rotate(-10deg);
      opacity:.08;
      animation: gridMove 18s linear infinite;
      pointer-events:none;
    }
    @keyframes gridMove{
      0%{ transform: translate3d(0,0,0) rotate(-10deg); }
      100%{ transform: translate3d(-140px, 140px,0) rotate(-10deg); }
    }
    .scanlines{
      position:absolute; inset:0;
      background: repeating-linear-gradient(
        180deg,
        rgba(255,255,255,.06) 0px,
        rgba(255,255,255,.06) 1px,
        transparent 2px,
        transparent 7px
      );
      opacity:.05;
      mix-blend-mode: overlay;
      pointer-events:none;
      animation: scan 3.2s linear infinite;
    }
    @keyframes scan{
      0%{ transform: translateY(-30px); }
      100%{ transform: translateY(30px); }
    }

    /* Layout */
    .shell{
      position:relative;
      height:100%;
      display:flex;
      align-items:center;
      justify-content:center;
      padding: 28px;
      z-index:2;
    }
    .wrap{
      width: min(1120px, 100%);
      display:grid;
      grid-template-columns: 1.12fr .88fr;
      gap: 22px;
      align-items: stretch;
    }

    /* Left hero */
    .hero{
      position:relative;
      border-radius: var(--radius);
      padding: 34px 34px;
      background: linear-gradient(135deg, rgba(255,255,255,.08), rgba(255,255,255,.04));
      border:1px solid rgba(255,255,255,.10);
      box-shadow: var(--shadow);
      overflow:hidden;
      min-height: 540px;
    }
    .hero::before{
      content:"";
      position:absolute; inset:-2px;
      background:
        radial-gradient(800px 420px at 25% 15%, rgba(106,228,255,.25), transparent 60%),
        radial-gradient(740px 420px at 80% 30%, rgba(139,92,255,.22), transparent 62%),
        radial-gradient(800px 500px at 50% 100%, rgba(44,255,179,.14), transparent 60%);
      opacity:.9;
      pointer-events:none;
    }
    .hero::after{
      content:"";
      position:absolute; inset:0;
      background:
        linear-gradient(135deg, rgba(0,0,0,.15), rgba(0,0,0,.40)),
        radial-gradient(1100px 700px at 40% 10%, rgba(255,255,255,.08), transparent 50%);
      pointer-events:none;
    }
    .hero > *{ position:relative; z-index:2; }

    .brandRow{
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap:16px;
      margin-bottom: 30px;
    }
    .brand{
      display:flex;
      align-items:center;
      gap:14px;
    }
    .brandLogo{
      width: 46px; height:46px;
      border-radius: 14px;
      background: rgba(0,0,0,.25);
      border:1px solid rgba(255,255,255,.14);
      box-shadow: 0 14px 40px rgba(0,0,0,.35);
      display:grid;
      place-items:center;
      overflow:hidden;
    }
    .brandLogo img{ width: 92%; height: 92%; object-fit: contain; filter: drop-shadow(0 8px 14px rgba(0,0,0,.4)); }
    .brandText .t1{
      font-size: 18px;
      font-weight: 800;
      letter-spacing: .2px;
      line-height: 1.1;
    }
    .brandText .t2{
      font-size: 12px;
      color: var(--muted);
      letter-spacing: .4px;
      margin-top: 2px;
    }

    .chip{
      display:inline-flex;
      align-items:center;
      gap:10px;
      padding: 10px 12px;
      border-radius: 999px;
      border: 1px solid rgba(255,255,255,.12);
      background: rgba(0,0,0,.24);
      color: rgba(234,240,255,.86);
      font-size: 12px;
      white-space: nowrap;
      backdrop-filter: blur(10px);
    }
    .chip i{
      width: 10px; height: 10px;
      border-radius: 99px;
      background: linear-gradient(135deg, var(--accent), var(--accent2));
      box-shadow: 0 0 0 4px rgba(106,228,255,.10);
      display:inline-block;
    }

    .h1{
      font-size: clamp(28px, 3.4vw, 44px);
      font-weight: 900;
      line-height: 1.05;
      letter-spacing: -0.6px;
      margin: 10px 0 14px;
    }
    .sub{
      max-width: 520px;
      color: rgba(234,240,255,.78);
      font-size: 14px;
      line-height: 1.55;
    }

    .featureGrid{

    /* green online dot for segments */
    .featureGrid .feature{ position:relative; }
    .featureGrid .feature::after{
      content:"";
      position:absolute;
      top:14px;
      right:14px;
      width:10px;
      height:10px;
      border-radius:50%;
      background: rgba(46, 242, 161, .95);
      box-shadow: 0 0 0 4px rgba(46,242,161,.10), 0 0 18px rgba(46,242,161,.35);
    }

      margin-top: 26px;
      display:grid;
      grid-template-columns: repeat(2, minmax(0,1fr));
      gap: 14px;
      max-width: 560px;
    }
    .feature{
      padding: 14px 14px;
      border-radius: 18px;
      border: 1px solid rgba(255,255,255,.10);
      background: rgba(0,0,0,.20);
      backdrop-filter: blur(10px);
    }
    .feature .k{
      font-weight: 800;
      font-size: 13px;
      margin-bottom: 4px;
    }
    .feature .k{
      display:flex;
      align-items:center;
      gap:12px;
    }
    .feature .dot{ display:none !important; }
    .feature .ficon{
      width:64px;
      height:auto;
      max-height:64px;
      filter: drop-shadow(0 10px 18px rgba(0,0,0,.55));
      opacity:.95;
    }
    .feature .v{ display:none !important; }

    .feature .v{
      color: rgba(234,240,255,.74);
      font-size: 12px;
      line-height: 1.35;
    }
    .feature .dot{
      width: 8px; height:8px; border-radius:99px;
      display:inline-block; margin-right:8px;
      background: linear-gradient(135deg, var(--ok), var(--accent));
      box-shadow: 0 0 0 4px rgba(44,255,179,.10);
      vertical-align: middle;
    }

    /* Right login card */
    .cardX{
      position:relative;
      border-radius: var(--radius);
      padding: 28px;
      background: var(--card);
      border: 1px solid var(--stroke);
      box-shadow: var(--shadow);
      overflow:hidden;
      min-height: 540px;
      display:flex;
      flex-direction:column;
      justify-content:center;
    }
    .cardX::before{
      content:"";
      position:absolute; inset:-1px;
      background: radial-gradient(700px 420px at 40% 10%, rgba(106,228,255,.18), transparent 55%),
                  radial-gradient(700px 420px at 90% 30%, rgba(139,92,255,.16), transparent 55%);
      pointer-events:none;
      opacity:.8;
    }
    .cardX > *{ position:relative; z-index:2; }

    .topRow{
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap: 12px;
      margin-bottom: 18px;
    }

    .lang{
      display:flex;
      align-items:center;
      gap: 10px;
      border:1px solid rgba(255,255,255,.12);
      background: rgba(0,0,0,.22);
      border-radius: 999px;
      padding: 8px 10px;
      backdrop-filter: blur(10px);
    }
    .lang select{
      appearance:none;
      border:0;
      background: transparent;
      color: rgba(234,240,255,.88);
      font-weight: 700;
      font-size: 12px;
      outline:none;
      padding-right: 14px;
    }
    .lang option{ color:#111; }

    .badgePro{
      display:inline-flex;
      align-items:center;
      gap:8px;
      padding: 9px 12px;
      border-radius: 999px;
      border:1px solid rgba(255,255,255,.12);
      background: rgba(0,0,0,.22);
      color: rgba(234,240,255,.88);
      font-size: 12px;
      font-weight: 800;
      letter-spacing:.2px;
    }
    .badgePro svg{ width:14px; height:14px; }

    .title{
      font-size: 22px;
      font-weight: 900;
      letter-spacing:-0.2px;
      margin: 4px 0 4px;
    }
    .desc{
      color: var(--muted);
      font-size: 13px;
      line-height: 1.45;
      margin-bottom: 18px;
    }

    .form-control{
      border-radius: 14px !important;
      border: 1px solid rgba(255,255,255,.12) !important;
      background: rgba(0,0,0,.28) !important;
      color: rgba(234,240,255,.92) !important;
      padding: 12px 14px !important;
      box-shadow: none !important;
    }
    .form-control::placeholder{ color: rgba(234,240,255,.45); }
    .form-label{
      font-size: 12px;
      color: rgba(234,240,255,.72);
      margin-bottom: 6px;
    }

    .row2{
      display:flex;
      align-items:center;
      justify-content:space-between;
      gap: 10px;
      margin: 10px 0 16px;
      color: rgba(234,240,255,.74);
      font-size: 12px;
    }
    .row2 a{
      color: rgba(234,240,255,.88);
      text-decoration:none;
      border-bottom:1px dashed rgba(255,255,255,.25);
    }
    .row2 a:hover{ opacity:.9; }

    .btnX{
      width:100%;
      border:0;
      border-radius: 16px;
      padding: 12px 14px;
      font-weight: 900;
      letter-spacing:.2px;
      color:#06101a;
      background: linear-gradient(135deg, var(--accent), var(--accent2));
      box-shadow: 0 18px 60px rgba(106,228,255,.18);
      transition: transform .12s ease, filter .12s ease;
    }
    .btnX:hover{ transform: translateY(-1px); filter: brightness(1.05); }
    .btnX:active{ transform: translateY(0); }

    .msg{
      min-height: 18px;
      margin-top: 14px;
      text-align:center;
      font-size: 12px;
      color: var(--danger);
      font-weight: 700;
      letter-spacing: .1px;
    }

    .foot{
      margin-top: 18px;
      display:flex;
      justify-content:center;
      gap: 12px;
      flex-wrap: wrap;
      color: rgba(234,240,255,.55);
      font-size: 11px;
    }
    .pill{
      display:inline-flex;
      align-items:center;
      gap:8px;
      padding: 8px 10px;
      border-radius: 999px;
      border:1px solid rgba(255,255,255,.10);
      background: rgba(0,0,0,.18);
      backdrop-filter: blur(8px);
    }
    .pill .p{
      width: 8px; height:8px;
      border-radius: 99px;
      background: linear-gradient(135deg, var(--ok), var(--accent));
      box-shadow: 0 0 0 4px rgba(44,255,179,.10);
    }

    /* Responsive */
    @media (max-width: 980px){
      body{ overflow:auto; }
      .wrap{ grid-template-columns: 1fr; }
      .hero{ min-height: unset; }
      .cardX{ min-height: unset; }
    }
  
/* Feature icon badges */
.featureGrid .feature .k{
  display:flex;
  align-items:center;
  gap:10px;
}
.featureGrid .feature .k::after{
  width:26px;
  height:26px;
  display:inline-grid;
  place-items:center;
  border-radius:10px;
  border:1px solid rgba(255,255,255,.12);
  background: rgba(0,0,0,.22);
  box-shadow: 0 10px 26px rgba(0,0,0,.35);
  font-size:15px;
}
</style>
</head>

<body>
  <div class="bg-img"></div>
  <div class="grid"></div>
  <div class="scanlines"></div>
  <div class="bg-vignette"></div>

  <div class="shell">
    <div class="wrap">
      <!-- HERO -->
      <section class="hero">
        <div class="brandRow">
          <div class="brand">
            <div class="brandLogo" aria-hidden="true">
              <img src="assets/logos/logo_1769081450_d276fabb39.png" alt="ECUPRATIX" />
            </div>
            <div class="brandText">
              <div class="t1">ECUPRATIX</div>
              <div class="t2" data-i18n="hero_sub">GEN3 • ECU Profiling • DTC Patch</div>
            </div>
          </div>
          <div class="chip" title="Secure Session">
            <i></i><span data-i18n="chip_secure">Secure Session</span>
          </div>
        </div>

        <div class="h1" data-i18n="hero_title">ECU dosyalarını tanı. DTC’yi yönet. Patch’i uygula.</div>
        <div class="sub" data-i18n="hero_desc">
          Profesyonel iş akışı: güvenli kullanıcı yönetimi ve hızlı sonuç.
        </div>

        <div class="featureGrid">
          <div class="feature">
            <div class="k"><img class="ficon" src="assets/img/login_icons/car.png" alt=""><span data-i18n="f1_t">CAR</span></div>
</div>
          <div class="feature">
            <div class="k"><img class="ficon" src="assets/img/login_icons/truck.png" alt=""><span data-i18n="f2_t">TRUCK-BUS</span></div>
</div>
          <div class="feature">
            <div class="k"><img class="ficon" src="assets/img/login_icons/tractor.png" alt=""><span data-i18n="f3_t">TRACTOR</span></div>
</div>
          <div class="feature">
            <div class="k"><img class="ficon" src="assets/img/login_icons/machinery.png" alt=""><span data-i18n="f4_t">MACHINERY</span></div>
</div>
        </div>
      </section>

      <!-- LOGIN -->
      <aside class="cardX">
        <div class="topRow">
          <div class="badgePro">
            <svg viewBox="0 0 24 24" fill="none" aria-hidden="true">
              <path d="M12 2l7 4v6c0 5-3 9-7 10-4-1-7-5-7-10V6l7-4z" stroke="rgba(234,240,255,.9)" stroke-width="1.6"/>
              <path d="M8.5 12.2l2.2 2.2L15.8 9.3" stroke="rgba(44,255,179,.95)" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            <span>GEN3 DARK PRO</span>
          </div>

          <div class="lang" title="Language">
            <select id="langSel" aria-label="Language">
              <option value="tr">TR</option>
              <option value="en">EN</option>
              <option value="fr">FR</option>
              <option value="de">DE</option>
              <option value="es">ES</option>
              <option value="it">IT</option>
              <option value="pt">PT</option>
              <option value="ru">RU</option>
            </select>
          </div>
        </div>

        <div class="title" data-i18n="login_title">Giriş Yap</div>
        <div class="desc" data-i18n="login_desc">Paneli kullanmak için hesabınla oturum aç.</div>

        <form id="loginForm" autocomplete="on">
          <div class="mb-3">
            <label class="form-label" data-i18n="user_label">Kullanıcı Adı</label>
            <input type="text" class="form-control" name="u" required placeholder="username" data-i18n-ph="user_ph">
          </div>

          <div class="mb-2">
            <label class="form-label" data-i18n="pass_label">Şifre</label>
            <div class="position-relative">
              <input type="password" class="form-control pe-5" name="p" required placeholder="••••••••" data-i18n-ph="pass_ph" id="passInp">
              <button type="button" id="togglePass" class="btn btn-sm position-absolute top-50 end-0 translate-middle-y me-2"
                style="border-radius:12px;border:1px solid rgba(255,255,255,.12);background:rgba(0,0,0,.18);color:rgba(234,240,255,.85);">
                👁
              </button>
            </div>
          </div>

          <div class="row2">
            <label class="d-flex align-items-center gap-2" style="cursor:pointer;">
              <input type="checkbox" id="remember" checked style="accent-color: var(--accent);">
              <span data-i18n="remember">Beni hatırla</span>
            </label>
            <a href="#" onclick="return false;" data-i18n="support">Support</a>
          </div>

          <button type="submit" class="btnX" id="btnLogin" data-i18n="login_btn">Giriş</button>
          <div id="msg" class="msg"></div>

          <div class="foot">
            <div class="pill"><span class="p"></span><span data-i18n="foot_1">Secure</span></div>
            <div class="pill"><span class="p"></span><span data-i18n="foot_2">Fast</span></div>
            <div class="pill"><span class="p"></span><span data-i18n="foot_3">Audit</span></div>
          </div>
        </form>
      </aside>
    </div>
  </div>

  <script>
    // ---------------------------
    // MINI I18N (login page)
    // ---------------------------
    const I18N_LOGIN = {
      tr: {
        hero_sub: "GEN3 • ECU Profiling • DTC Patch",
        chip_secure: "Güvenli Oturum",
        hero_title: "ECU dosyalarını tanı. DTC’yi yönet. Patch’i uygula.",
        hero_desc: "Profesyonel iş akışı: güvenli kullanıcı yönetimi ve hızlı sonuç.",
        f1_t: "CAR",
        f1_d: "Marka/ECU algılama, kütüphane üzerinden hızlı eşleşme.",
        f2_t: "TRUCK-BUS",
        f2_d: "Çoklu paket, lisans süresi ve 24 saat işlem limiti.",
        f3_t: "TRACTOR",
        f3_d: "Admin/User rol ayrımı ve audit kayıtları.",
        f4_t: "MACHINERY",
        f4_d: "Modern Dark Pro tasarım ile akıcı kullanım.",
        login_title: "Giriş Yap",
        login_desc: "Paneli kullanmak için hesabınla oturum aç.",
        user_label: "Kullanıcı Adı",
        pass_label: "Şifre",
        remember: "Beni hatırla",
        support: "Destek",
        login_btn: "Giriş",
        user_ph: "Kullanıcı adınız",
        pass_ph: "Şifreniz",
        foot_1: "Güvenli",
        foot_2: "Hızlı",
        foot_3: "Kayıtlı",
        err_empty: "Lütfen kullanıcı adı ve şifre girin.",
      },
      en: {
        hero_sub: "GEN3 • ECU Profiling • DTC Patch",
        chip_secure: "Secure Session",
        hero_title: "Identify ECU files. Manage DTCs. Apply patches.",
        hero_desc: "Pro workflow: file profiling, package/limit control, secure user management and fast results.",
        f1_t: "CAR",
        f1_d: "Brand/ECU detection with library-driven matching.",
        f2_t: "TRUCK-BUS",
        f2_d: "Multi-package, license duration and 24h operation limits.",
        f3_t: "TRACTOR",
        f3_d: "Admin/User roles with audit trails.",
        f4_t: "MACHINERY",
        f4_d: "Modern Dark Pro design for smooth usage.",
        login_title: "Sign in",
        login_desc: "Use your account to access the panel.",
        user_label: "Username",
        pass_label: "Password",
        remember: "Remember me",
        support: "Support",
        login_btn: "Login",
        user_ph: "Your username",
        pass_ph: "Your password",
        foot_1: "Secure",
        foot_2: "Fast",
        foot_3: "Audit",
        err_empty: "Please enter username and password.",
      },
      fr: {
        hero_sub: "GEN3 • Profil ECU • Patch DTC",
        chip_secure: "Session sécurisée",
        hero_title: "Identifier les fichiers ECU. Gérer les DTC. Appliquer des patchs.",
        hero_desc: "Flux pro : profilage, contrôle des packs/limites, gestion sécurisée et résultats rapides.",
        f1_t: "CAR",
        f1_d: "Détection Marque/ECU avec correspondance via bibliothèque.",
        f2_t: "TRUCK-BUS",
        f2_d: "Multi-pack, durée de licence et limite d’opérations 24h.",
        f3_t: "TRACTOR",
        f3_d: "Rôles Admin/User et journal d’audit.",
        f4_t: "MACHINERY",
        f4_d: "Design Dark Pro moderne et fluide.",
        login_title: "Connexion",
        login_desc: "Connectez-vous pour accéder au panneau.",
        user_label: "Utilisateur",
        pass_label: "Mot de passe",
        remember: "Se souvenir de moi",
        support: "Support",
        login_btn: "Entrer",
        user_ph: "Nom d'utilisateur",
        pass_ph: "Mot de passe",
        foot_1: "Sûr",
        foot_2: "Rapide",
        foot_3: "Audit",
        err_empty: "Veuillez saisir l'utilisateur et le mot de passe.",
      },
      de: {
        hero_sub: "GEN3 • ECU Profiling • DTC Patch",
        chip_secure: "Sichere Sitzung",
        hero_title: "ECU-Dateien erkennen. DTC verwalten. Patches anwenden.",
        hero_desc: "Pro Workflow: Profiling, Paket/Limit-Kontrolle, sichere Nutzerverwaltung und schnelle Ergebnisse.",
        f1_t: "CAR",
        f1_d: "Marke/ECU Erkennung mit Library-Matching.",
        f2_t: "TRUCK-BUS",
        f2_d: "Multi-Pakete, Lizenzdauer und 24h-Operationslimit.",
        f3_t: "TRACTOR",
        f3_d: "Admin/User Rollen mit Audit-Logs.",
        f4_t: "MACHINERY",
        f4_d: "Modernes Dark Pro Design für flüssige Nutzung.",
        login_title: "Anmelden",
        login_desc: "Mit deinem Konto einloggen.",
        user_label: "Benutzername",
        pass_label: "Passwort",
        remember: "Angemeldet bleiben",
        support: "Support",
        login_btn: "Login",
        user_ph: "Benutzername",
        pass_ph: "Passwort",
        foot_1: "Sicher",
        foot_2: "Schnell",
        foot_3: "Audit",
        err_empty: "Bitte Benutzername und Passwort eingeben.",
      },
      es: {
        hero_sub: "GEN3 • Perfil ECU • Parche DTC",
        chip_secure: "Sesión segura",
        hero_title: "Identifica archivos ECU. Gestiona DTC. Aplica parches.",
        hero_desc: "Flujo pro: perfilado, control de paquetes/límites, gestión segura y resultados rápidos.",
        f1_t: "CAR",
        f1_d: "Detección de marca/ECU con biblioteca.",
        f2_t: "TRUCK-BUS",
        f2_d: "Multi-paquete, duración de licencia y límite 24h.",
        f3_t: "TRACTOR",
        f3_d: "Roles Admin/User con auditoría.",
        f4_t: "MACHINERY",
        f4_d: "Diseño Dark Pro moderno y fluido.",
        login_title: "Iniciar sesión",
        login_desc: "Accede al panel con tu cuenta.",
        user_label: "Usuario",
        pass_label: "Contraseña",
        remember: "Recordarme",
        support: "Soporte",
        login_btn: "Entrar",
        user_ph: "Tu usuario",
        pass_ph: "Tu contraseña",
        foot_1: "Seguro",
        foot_2: "Rápido",
        foot_3: "Auditoría",
        err_empty: "Introduce usuario y contraseña.",
      },
      it: {
        hero_sub: "GEN3 • Profilo ECU • Patch DTC",
        chip_secure: "Sessione sicura",
        hero_title: "Identifica file ECU. Gestisci DTC. Applica patch.",
        hero_desc: "Workflow pro: profiling, controllo pacchetti/limiti, gestione sicura e risultati rapidi.",
        f1_t: "CAR",
        f1_d: "Rilevamento marca/ECU con libreria.",
        f2_t: "TRUCK-BUS",
        f2_d: "Multi-pacchetto, durata licenza e limite 24h.",
        f3_t: "TRACTOR",
        f3_d: "Ruoli Admin/User con audit log.",
        f4_t: "MACHINERY",
        f4_d: "Design Dark Pro moderno e fluido.",
        login_title: "Accesso",
        login_desc: "Accedi al pannello con il tuo account.",
        user_label: "Utente",
        pass_label: "Password",
        remember: "Ricordami",
        support: "Supporto",
        login_btn: "Entra",
        user_ph: "Nome utente",
        pass_ph: "Password",
        foot_1: "Sicuro",
        foot_2: "Veloce",
        foot_3: "Audit",
        err_empty: "Inserisci utente e password.",
      },
      pt: {
        hero_sub: "GEN3 • Perfil ECU • Patch DTC",
        chip_secure: "Sessão segura",
        hero_title: "Identifique ficheiros ECU. Gerir DTC. Aplicar patches.",
        hero_desc: "Fluxo pro: profiling, controlo de pacotes/limites, gestão segura e resultados rápidos.",
        f1_t: "CAR",
        f1_d: "Deteção Marca/ECU com biblioteca.",
        f2_t: "TRUCK-BUS",
        f2_d: "Multi-pacote, duração da licença e limite 24h.",
        f3_t: "TRACTOR",
        f3_d: "Funções Admin/User com auditoria.",
        f4_t: "MACHINERY",
        f4_d: "Design Dark Pro moderno e fluido.",
        login_title: "Entrar",
        login_desc: "Aceda ao painel com a sua conta.",
        user_label: "Utilizador",
        pass_label: "Palavra-passe",
        remember: "Lembrar-me",
        support: "Suporte",
        login_btn: "Login",
        user_ph: "O seu utilizador",
        pass_ph: "A sua palavra-passe",
        foot_1: "Seguro",
        foot_2: "Rápido",
        foot_3: "Auditoria",
        err_empty: "Introduza utilizador e palavra-passe.",
      },
      ru: {
        hero_sub: "GEN3 • ECU Profiling • DTC Patch",
        chip_secure: "Безопасная сессия",
        hero_title: "Определяйте ECU файлы. Управляйте DTC. Применяйте патчи.",
        hero_desc: "Профессиональный поток: профилирование, пакеты/лимиты, безопасное управление и быстрый результат.",
        f1_t: "CAR",
        f1_d: "Определение бренда/ECU и совпадение по библиотеке.",
        f2_t: "TRUCK-BUS",
        f2_d: "Мульти-пакет, срок лицензии и лимит 24ч.",
        f3_t: "TRACTOR",
        f3_d: "Роли Admin/User и аудит.",
        f4_t: "MACHINERY",
        f4_d: "Современный Dark Pro дизайн.",
        login_title: "Вход",
        login_desc: "Войдите, чтобы открыть панель.",
        user_label: "Пользователь",
        pass_label: "Пароль",
        remember: "Запомнить меня",
        support: "Поддержка",
        login_btn: "Войти",
        user_ph: "Имя пользователя",
        pass_ph: "Пароль",
        foot_1: "Безопасно",
        foot_2: "Быстро",
        foot_3: "Аудит",
        err_empty: "Введите пользователя и пароль.",
      }
    };

    function t(key){
      const lang = (localStorage.getItem("lang") || document.documentElement.lang || "tr").toLowerCase();
      const dict = I18N_LOGIN[lang] || I18N_LOGIN.tr;
      return (dict && dict[key]) ? dict[key] : key;
    }

    function applyLoginI18n(){
      const lang = (localStorage.getItem("lang") || "tr").toLowerCase();
      document.documentElement.lang = lang;

      // sync selector
      const sel = document.getElementById("langSel");
      if(sel && sel.value !== lang) sel.value = (I18N_LOGIN[lang] ? lang : "tr");

      document.querySelectorAll("[data-i18n]").forEach(el=>{
        const k = el.getAttribute("data-i18n");
        el.textContent = t(k);
      });

      document.querySelectorAll("[data-i18n-ph]").forEach(el=>{
        const k = el.getAttribute("data-i18n-ph");
        el.setAttribute("placeholder", t(k));
      });
    }

    (function initLogin(){
      const saved = localStorage.getItem("lang");
      const sel = document.getElementById("langSel");
      if(sel){
        sel.value = (saved && I18N_LOGIN[saved]) ? saved : "tr";
        sel.addEventListener("change", ()=>{
          localStorage.setItem("lang", sel.value);
          applyLoginI18n();
        });
      }

      // remember user
      const ru = localStorage.getItem("login_u");
      const rp = localStorage.getItem("login_p");
      if(ru) document.querySelector('input[name="u"]').value = ru;
      if(rp) document.querySelector('input[name="p"]').value = rp;

      document.getElementById("togglePass").addEventListener("click", ()=>{
        const inp = document.getElementById("passInp");
        inp.type = (inp.type === "password") ? "text" : "password";
      });

      applyLoginI18n();
    })();

    // ---------------------------
    // LOGIN
    // ---------------------------
    $("#loginForm").submit(function(e){
      e.preventDefault();

      const u = $('input[name=u]').val().trim();
      const p = $('input[name=p]').val().trim();

      if(!u || !p){
        $("#msg").text(t("err_empty"));
        return;
      }

      if($("#remember").is(":checked")){
        localStorage.setItem("login_u", u);
          localStorage.setItem("login_p", p);
      }else{
        localStorage.removeItem("login_u");
          localStorage.removeItem("login_p");
      }

      $("#msg").text("");
      $("#btnLogin").prop("disabled", true).css("opacity",".85");

      $.post("api.php", {action:"login", u:u, p:p}, function(r){
        $("#btnLogin").prop("disabled", false).css("opacity","1");
        try{
          if(r && r.status === "ok"){
            window.location.href = (r.role === "admin") ? "admin.php" : "index.php";
            return;
          }
          $("#msg").text((r && r.msg) ? r.msg : "Login failed");
        }catch(err){
          $("#msg").text("Login failed");
        }
      }, "json").fail(function(){
        $("#btnLogin").prop("disabled", false).css("opacity","1");
        $("#msg").text("Login failed");
      });
    });
  </script>
</body>
</html>
