<!DOCTYPE html>
<?php session_start(); if(!isset($_SESSION['role'])) header('Location: login.php'); ?>
<html lang="tr" data-bs-theme="dark">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ECU PRATIX - PRO DTC PORTAL</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11">
</script>
<script>
function _brandSlug(s){ return (s||'').toString().toLowerCase().replace(/[^a-z0-9]+/g,'-').replace(/(^-|-$)/g,''); }
function _logoSrc(brand){ return 'assets/brands/'+_brandSlug(brand)+'.png'; }


function renderUpdates(items){
  var row = document.getElementById('updatesRow');
  if(!row) return;

  if(!items || !items.length){
    row.innerHTML = '<div class="update-card"><div class="update-left"><div><div class="update-brand">Henüz güncelleme yok</div><div class="update-ecu">—</div></div></div><span class="update-badge">—</span></div>';
    return;
  }

  var html = items.slice(0,20).map(function(it){
    var isEcu = (String(it.type||'').toUpperCase()==='NEW ECU');
    var badge = isEcu ? '<span class="update-badge ecu">New ECU</span>' : '<span class="update-badge">New Variant</span>';
    var logo = '<img class="update-logo" src="'+_logoSrc(it.brand)+'" onerror="this.style.display=\'none\'">';
    return (
      '<div class="update-card">'+
        '<div class="update-left">'+
          logo+
          '<div style="min-width:0">'+
            '<div class="update-brand">'+(it.brand||'')+'</div>'+
            '<div class="update-ecu">'+(it.ecu||'')+'</div>'+
          '</div>'+
        '</div>'+
        badge+
      '</div>'
    );
  }).join('');

  // Infinite marquee: duplicate content (CSS animates -50%)
  row.innerHTML = html + html;

  // Speed auto-adjust (more items -> a bit slower)
  var count = Math.max(1, Math.min(20, items.length));
  var seconds = Math.max(24, Math.min(46, 24 + count * 1.2));
  var track = row; // row is track element
  track.style.animationDuration = seconds + 's';
}

async function loadProfileUpdates(){
  try{
    var fd = new FormData();
    fd.append('action','public_profile_updates');
    fd.append('limit','20');

    var res = await fetch('api.php', {method:'POST', body: fd, cache:'no-store'});
    var rx = await res.json();
    if(rx && rx.status==='ok') renderUpdates(rx.items||[]);
  }catch(e){
    // silent
  }
}

document.addEventListener('DOMContentLoaded', function(){
  loadProfileUpdates();
  setInterval(loadProfileUpdates, 15000);
});
</script>


  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
  <style>
    :root{--panel:#121212;--panel2:#151515;--line:#222;--soft:#1a1a1a}
    body{background:#0a0a0a;color:#eee;font-family:'Segoe UI',sans-serif}
    .topbar{position:sticky;top:0;z-index:50;background:rgba(10,10,10,0.92);backdrop-filter:blur(8px);border-bottom:1px solid var(--line)}
    .brand{letter-spacing:0.3px}
    .cardx{background:var(--panel);border:1px solid var(--line);border-radius:14px}
    .cardx .cardx-h{border-bottom:1px solid var(--line);padding:12px 14px}
    .cardx .cardx-b{padding:14px}
    .drop-zone{border:2px dashed #333;padding:26px;text-align:center;border-radius:14px;cursor:pointer;transition:0.2s;background:var(--panel2);position:relative;overflow:hidden;min-height:140px}
    .drop-zone:hover{border-color:#0d6efd;background:var(--soft)}
    .drop-zone input{position:absolute;inset:0;width:100%;height:100%;opacity:0;cursor:pointer}
    .table-wrap{background:var(--panel);border:1px solid var(--line);border-radius:14px;overflow:hidden}
    .table-head{display:flex;align-items:center;justify-content:space-between;gap:12px;padding:12px 14px;border-bottom:1px solid var(--line)}
    .table-head .legend{font-size:12px;color:#9aa0a6}
    .table-dark{--bs-table-bg:var(--panel);--bs-table-striped-bg:#141414;--bs-table-hover-bg:#1b1b1b}
    .dtc-code{font-weight:800;letter-spacing:0.4px}
    .dtc-on{color:#20c997 !important}
    .dtc-off{color:#ff4d4f !important}
    .row-off{background:rgba(255,77,79,0.13) !important}
    .btn-group .btn{min-width:70px}
    .progress{height:5px}

    /* MATRIX LOADER */
    .matrix-wrap{position:absolute;inset:0;display:none;align-items:center;justify-content:center;background:rgba(0,0,0,0.58);backdrop-filter: blur(2px)}
    .matrix{width:100%;height:100%;padding:18px;text-align:left;font-family: ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace;line-height:1.25;overflow:hidden;}
    .matrix-line{color:#20c997;opacity:0.95;white-space:nowrap;}
    .matrix-dim{opacity:0.55;}

    /* ECU LOGO WRAP (prevent huge logos) */
    .ecu-logo{width:56px;height:56px;display:flex;align-items:center;justify-content:center;flex:0 0 auto;
      border:1px solid var(--line);border-radius:14px;background:#0f0f0f;overflow:hidden}
    .ecu-logo img{max-width:100%;max-height:100%;object-fit:contain;display:block}

    /* ECU CARD LAYOUT (restore original flow) */
    .ecu-card{display:block !important;}
    .ecu-card-inner{display:flex;align-items:center;gap:14px;flex-wrap:nowrap;}
    .ecu-logo{position:relative;}
    .ecu-logo img{position:absolute;inset:0;margin:auto;max-width:90%;max-height:90%;}


/* CONFIRM OVERLAY (original behavior) */
    .overlay{position:fixed;inset:0;background:rgba(0,0,0,.95);z-index:9999;display:none;align-items:center;justify-content:center;padding:20px}
    .overlay-card{width:min(860px,94vw);background:var(--panel);border:1px solid var(--line);border-radius:16px;box-shadow:0 18px 60px rgba(0,0,0,0.55)}
    .overlay-h{padding:14px 16px;border-bottom:1px solid var(--line);display:flex;align-items:center;gap:10px}
    .overlay-b{padding:14px 16px}
    .confirm-list{max-height:46vh;overflow:auto;border:1px solid var(--line);border-radius:14px}
    .confirm-item{display:flex;align-items:flex-start;gap:10px;padding:10px 12px;border-bottom:1px solid var(--line)}
    .confirm-item:last-child{border-bottom:none}
    .tick{color:#20c997}

/* DATATABLES - remove length/info (paginate ON) */
    div.dataTables_wrapper div.dataTables_length{display:block;}
    div.dataTables_wrapper div.dataTables_info{display:block;}
    div.dataTables_wrapper div.dataTables_paginate{display:block}
    div.dataTables_wrapper div.dataTables_filter{margin:0}
    div.dataTables_wrapper div.dataTables_filter label{display:flex;align-items:center;gap:10px;margin:0}
    div.dataTables_wrapper div.dataTables_filter input{margin-left:0 !important}

    /* PAGINATION VISIBILITY (dark UI) */
    .dataTables_wrapper .dataTables_paginate{padding-top:10px}
    .dataTables_wrapper .dataTables_paginate .pagination{margin:0;gap:6px;flex-wrap:wrap}
    .dataTables_wrapper .dataTables_paginate .page-link{background:#101010;border:1px solid #222;color:#e5e7eb}
    .dataTables_wrapper .dataTables_paginate .page-link:hover{background:#151515;color:#ffffff}
    .dataTables_wrapper .dataTables_paginate .page-item.disabled .page-link{opacity:.45}
    .dataTables_wrapper .dataTables_paginate .page-item.active .page-link{background:#0d6efd;border-color:#0d6efd;color:#fff}

    /* moved paginate into #dtcPager */
    #dtcPager .dataTables_paginate{display:block!important}
    #dtcPager ul.pagination{margin:0;gap:6px;flex-wrap:wrap}
    #dtcPager .page-link{background:#101010;border:1px solid #222;color:#e5e7eb}
    #dtcPager .page-link:hover{background:#151515;color:#ffffff}
    #dtcPager .page-item.disabled .page-link{opacity:.45}
    #dtcPager .page-item.active .page-link{background:#0d6efd;border-color:#0d6efd;color:#fff}

    @media (max-width: 992px){ .table-head{flex-direction:column;align-items:stretch} }
  
/* UPDATES BAR (Topbar altı) - Green / White / Black - Marquee (no scrollbar) */
.updates-bar{
  width:100%;
  box-sizing:border-box;
  margin:10px 0 18px;
  padding:10px 12px;
  border-radius:16px;
  background:#070707;
  border:1px solid rgba(255,255,255,.10);
  box-shadow:0 12px 34px rgba(0,0,0,.45);
  overflow:hidden; /* no scrollbar */
}
.updates-head{
  display:flex;align-items:center;justify-content:space-between;gap:10px;
  padding:0 2px 10px 2px;
}
.updates-title{display:flex;align-items:center;gap:10px;font-weight:900;letter-spacing:.4px;color:#fff}
.updates-dot{
  width:10px;height:10px;border-radius:50%;
  background:#00ff66;
  box-shadow:0 0 10px rgba(0,255,102,.85);
}
.updates-sub{color:rgba(255,255,255,.60);font-size:12px;white-space:nowrap}

.updates-viewport{overflow:hidden}
.updates-track{
  display:flex;
  gap:12px;
  width:max-content;
  will-change:transform;
  animation:updatesMarquee 34s linear infinite;
}
.updates-bar:hover .updates-track{animation-play-state:paused}

@keyframes updatesMarquee{
  0%{transform:translateX(0)}
  100%{transform:translateX(-50%)}
}

/* cards */
.update-card{
  min-width:280px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:14px;
  padding:10px 14px;
  border-radius:14px;
  background:linear-gradient(180deg, #0f0f0f, #090909);
  border:1px solid rgba(255,255,255,.12);
  box-shadow:0 10px 28px rgba(0,0,0,.28);
}
.update-left{display:flex;align-items:center;gap:12px;min-width:0}
.update-logo{
  width:42px;height:42px;border-radius:999px;object-fit:contain;
  background:rgba(255,255,255,.06);
  border:1px solid rgba(255,255,255,.12);
  padding:6px;
}
.update-brand{font-weight:900;font-size:15px;line-height:1.1;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
.update-ecu{font-size:12px;color:rgba(255,255,255,.68);margin-top:2px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}

.update-badge{
  font-size:11px;font-weight:900;padding:6px 10px;border-radius:999px;
  background:rgba(255,255,255,.06);
  border:1px solid rgba(255,255,255,.22);
  color:#fff;
  text-transform:capitalize;
  white-space:nowrap;
}
.update-badge.ecu{
  background:rgba(0,255,102,.14);
  border-color:rgba(0,255,102,.40);
  box-shadow:0 0 10px rgba(0,255,102,.18);
}


<style>
/* ===== ECUPRATIX Dark Pro Pagination (DataTables) ===== */
.dataTables_wrapper .dataTables_paginate{
  display:flex;
  justify-content:center;
  align-items:center;
  padding: 10px 0 0 0;
}
.dataTables_wrapper .dataTables_paginate .paginate_button{
  border: 1px solid rgba(255,255,255,.10) !important;
  background: rgba(0,0,0,.25) !important;
  color: rgba(255,255,255,.82) !important;
  border-radius: 12px !important;
  margin: 0 4px !important;
  padding: 7px 11px !important;
  line-height: 1 !important;
  min-width: 36px;
  text-align:center;
  transition: transform .08s ease, background .12s ease, border-color .12s ease, box-shadow .12s ease;
  font-weight: 600;
}
.dataTables_wrapper .dataTables_paginate .paginate_button:hover{
  background: rgba(255,255,255,.08) !important;
  border-color: rgba(255,255,255,.22) !important;
  transform: translateY(-1px);
}
.dataTables_wrapper .dataTables_paginate .paginate_button.current{
  background: rgba(0, 200, 255, .18) !important;
  border-color: rgba(0, 200, 255, .35) !important;
  color: #fff !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
}
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover{
  opacity: .35;
  cursor: not-allowed !important;
  transform: none !important;
  background: rgba(0,0,0,.18) !important;
}
.dataTables_wrapper .dataTables_paginate .paginate_button.previous,
.dataTables_wrapper .dataTables_paginate .paginate_button.next{
  min-width: 42px;
  font-weight: 700;
}
.dataTables_wrapper .dataTables_paginate .ellipsis{
  color: rgba(255,255,255,.45);
  padding: 0 6px;
}

/* Optional: info line */
.dataTables_wrapper .dataTables_info{
  color: rgba(255,255,255,.6) !important;
  padding-top: 8px;
  font-size: 12px;
  text-align:center;
}

/* Optional: length + search */
.dataTables_wrapper .dataTables_length select,
.dataTables_wrapper .dataTables_filter input{
  background: rgba(255,255,255,.04) !important;
  border: 1px solid rgba(255,255,255,.12) !important;
  color: rgba(255,255,255,.85) !important;
  border-radius: 12px !important;
  padding: 6px 10px !important;
  outline: none !important;
}
.dataTables_wrapper .dataTables_filter input:focus,
.dataTables_wrapper .dataTables_length select:focus{
  border-color: rgba(0, 200, 255, .35) !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
}
</style>
<style>
/* ===== ECUPRATIX Dark Pro Pagination v2 (circular prev/next) ===== */
.dataTables_wrapper .dataTables_paginate .paginate_button.previous,
.dataTables_wrapper .dataTables_paginate .paginate_button.next,
.dataTables_wrapper .dataTables_paginate .paginate_button.first,
.dataTables_wrapper .dataTables_paginate .paginate_button.last{
  width: 40px !important;
  height: 40px !important;
  padding: 0 !important;
  border-radius: 999px !important;
  display: inline-flex !important;
  align-items: center !important;
  justify-content: center !important;
  letter-spacing: .5px;
  font-size: 16px !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.previous,
.dataTables_wrapper .dataTables_paginate .paginate_button.next{
  font-weight: 900 !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.first,
.dataTables_wrapper .dataTables_paginate .paginate_button.last{
  font-weight: 900 !important;
  opacity: .9;
}

/* make page numbers more "chip" like */
.dataTables_wrapper .dataTables_paginate .paginate_button:not(.previous):not(.next):not(.first):not(.last){
  border-radius: 999px !important;
  min-width: 40px !important;
  height: 40px !important;
  display:inline-flex !important;
  align-items:center !important;
  justify-content:center !important;
}

/* nicer spacing on mobile */
@media (max-width: 640px){
  .dataTables_wrapper .dataTables_paginate .paginate_button{
    margin: 0 2px !important;
  }
}
</style>
<style>
/* ===== ECUPRATIX Dark Pro Pagination v3 (table-like + icon circular) ===== */

/* Wrap paginate area as a "control bar" */
.dataTables_wrapper .dataTables_paginate{
  width: 100%;
  display:flex !important;
  justify-content:center !important;
  align-items:center !important;
  margin-top: 10px !important;
}

/* Make inner controls look like a card/table row */
.dataTables_wrapper .dataTables_paginate .pagination,
.dataTables_wrapper .dataTables_paginate{
  gap: 8px;
}
.dataTables_wrapper .dataTables_paginate{
  padding: 10px 12px !important;
  border: 1px solid rgba(255,255,255,.08) !important;
  background: rgba(255,255,255,.03) !important;
  border-radius: 16px !important;
  box-shadow: inset 0 0 0 1px rgba(0,0,0,.35);
}

/* Ensure buttons are separated (fix "Previous123") */
.dataTables_wrapper .dataTables_paginate a.paginate_button{
  display:inline-flex !important;
  align-items:center !important;
  justify-content:center !important;
  margin: 0 4px !important;
  white-space: nowrap !important;
  text-decoration: none !important;
}

/* Base button style */
.dataTables_wrapper .dataTables_paginate a.paginate_button{
  border: 1px solid rgba(255,255,255,.10) !important;
  background: rgba(0,0,0,.25) !important;
  color: rgba(255,255,255,.82) !important;
  border-radius: 999px !important;
  min-width: 40px !important;
  height: 40px !important;
  padding: 0 12px !important;
  line-height: 1 !important;
  font-weight: 700 !important;
  transition: transform .08s ease, background .12s ease, border-color .12s ease, box-shadow .12s ease;
}

/* Hover */
.dataTables_wrapper .dataTables_paginate a.paginate_button:hover{
  background: rgba(255,255,255,.08) !important;
  border-color: rgba(255,255,255,.22) !important;
  transform: translateY(-1px);
}

/* Current */
.dataTables_wrapper .dataTables_paginate a.paginate_button.current{
  background: rgba(0, 200, 255, .18) !important;
  border-color: rgba(0, 200, 255, .35) !important;
  color: #fff !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
}

/* Disabled */
.dataTables_wrapper .dataTables_paginate a.paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate a.paginate_button.disabled:hover{
  opacity: .35 !important;
  cursor: not-allowed !important;
  transform: none !important;
  background: rgba(0,0,0,.18) !important;
}

/* ICON BUTTONS: first/prev/next/last as circles with glyphs (ignore text) */
.dataTables_wrapper .dataTables_paginate a.paginate_button.previous,
.dataTables_wrapper .dataTables_paginate a.paginate_button.next,
.dataTables_wrapper .dataTables_paginate a.paginate_button.first,
.dataTables_wrapper .dataTables_paginate a.paginate_button.last{
  width: 44px !important;
  min-width: 44px !important;
  padding: 0 !important;
  letter-spacing: 0 !important;
  position: relative;
  overflow: hidden;
  text-indent: -9999px; /* hide "Previous/Next" text */
}

/* Center icon */
.dataTables_wrapper .dataTables_paginate a.paginate_button.previous:after,
.dataTables_wrapper .dataTables_paginate a.paginate_button.next:after,
.dataTables_wrapper .dataTables_paginate a.paginate_button.first:after,
.dataTables_wrapper .dataTables_paginate a.paginate_button.last:after{
  text-indent: 0;
  position: absolute;
  left: 50%;
  top: 50%;
  transform: translate(-50%,-50%);
  font-size: 18px;
  font-weight: 900;
  color: rgba(255,255,255,.85);
}

/* Glyph mapping */
.dataTables_wrapper .dataTables_paginate a.paginate_button.first:after{ content: "«"; }
.dataTables_wrapper .dataTables_paginate a.paginate_button.previous:after{ content: "‹"; }
.dataTables_wrapper .dataTables_paginate a.paginate_button.next:after{ content: "›"; }
.dataTables_wrapper .dataTables_paginate a.paginate_button.last:after{ content: "»"; }

/* Ellipsis */
.dataTables_wrapper .dataTables_paginate span.ellipsis{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  min-width: 22px;
  color: rgba(255,255,255,.45);
}

/* Mobile: tighter */
@media (max-width: 640px){
  .dataTables_wrapper .dataTables_paginate{
    padding: 10px 8px !important;
  }
  .dataTables_wrapper .dataTables_paginate a.paginate_button{
    margin: 0 2px !important;
  }
}
</style>
<style>
/* ===== ECUPRATIX Dark Pro Pagination v4 (JS icon override + circles) ===== */
.dataTables_wrapper .dataTables_paginate{
  width:100% !important;
  display:flex !important;
  justify-content:center !important;
  align-items:center !important;
  padding: 12px !important;
  border: 1px solid rgba(255,255,255,.08) !important;
  background: rgba(255,255,255,.03) !important;
  border-radius: 16px !important;
  gap: 8px !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button{
  display:inline-flex !important;
  align-items:center !important;
  justify-content:center !important;
  margin: 0 4px !important;
  border: 1px solid rgba(255,255,255,.10) !important;
  background: rgba(0,0,0,.25) !important;
  color: rgba(255,255,255,.86) !important;
  border-radius: 999px !important;
  min-width: 40px !important;
  height: 40px !important;
  padding: 0 12px !important;
  line-height: 1 !important;
  font-weight: 700 !important;
  text-decoration:none !important;
  transition: transform .08s ease, background .12s ease, border-color .12s ease, box-shadow .12s ease;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button:hover{
  background: rgba(255,255,255,.08) !important;
  border-color: rgba(255,255,255,.22) !important;
  transform: translateY(-1px) !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.current{
  background: rgba(0, 200, 255, .18) !important;
  border-color: rgba(0, 200, 255, .35) !important;
  color:#fff !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate a.paginate_button.disabled:hover{
  opacity:.35 !important;
  cursor:not-allowed !important;
  transform:none !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.previous,
.dataTables_wrapper .dataTables_paginate a.paginate_button.next,
.dataTables_wrapper .dataTables_paginate a.paginate_button.first,
.dataTables_wrapper .dataTables_paginate a.paginate_button.last{
  width: 44px !important;
  min-width: 44px !important;
  padding: 0 !important;
  font-size: 18px !important;
  font-weight: 900 !important;
}
.dataTables_wrapper .dataTables_paginate span.ellipsis{
  color: rgba(255,255,255,.45) !important;
  padding: 0 6px !important;
}
</style>
<style>
/* ===== ECUPRATIX Dark Pro Pagination v5 (observer + universal selectors) ===== */
.dataTables_paginate{
  width:100% !important;
  display:flex !important;
  justify-content:center !important;
  align-items:center !important;
  padding: 12px !important;
  border: 1px solid rgba(255,255,255,.08) !important;
  background: rgba(255,255,255,.03) !important;
  border-radius: 16px !important;
  gap: 8px !important;
}

/* universal spacing so "Previous123" can never stick */
.dataTables_paginate a,
.dataTables_paginate span{
  display:inline-flex !important;
  align-items:center !important;
  justify-content:center !important;
  margin: 0 4px !important;
  white-space: nowrap !important;
}

/* base chip */
.dataTables_paginate a{
  border: 1px solid rgba(255,255,255,.10) !important;
  background: rgba(0,0,0,.25) !important;
  color: rgba(255,255,255,.86) !important;
  border-radius: 999px !important;
  min-width: 40px !important;
  height: 40px !important;
  padding: 0 12px !important;
  line-height: 1 !important;
  font-weight: 700 !important;
  text-decoration:none !important;
  transition: transform .08s ease, background .12s ease, border-color .12s ease, box-shadow .12s ease;
}
.dataTables_paginate a:hover{
  background: rgba(255,255,255,.08) !important;
  border-color: rgba(255,255,255,.22) !important;
  transform: translateY(-1px) !important;
}
.dataTables_paginate a.current{
  background: rgba(0, 200, 255, .18) !important;
  border-color: rgba(0, 200, 255, .35) !important;
  color:#fff !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
}
.dataTables_paginate a.disabled,
.dataTables_paginate a.disabled:hover{
  opacity:.35 !important;
  cursor:not-allowed !important;
  transform:none !important;
}

/* icon circles */
.dataTables_paginate a.previous,
.dataTables_paginate a.next,
.dataTables_paginate a.first,
.dataTables_paginate a.last{
  width: 44px !important;
  min-width: 44px !important;
  padding: 0 !important;
  font-size: 18px !important;
  font-weight: 900 !important;
}
.dataTables_paginate span.ellipsis{
  color: rgba(255,255,255,.45) !important;
  padding: 0 6px !important;
}
</style>
<style>
/* ===== ECUPRATIX Pagination v6 (hard center + no wrap) ===== */
.dataTables_wrapper .dataTables_paginate{
  width: 100% !important;
  display: flex !important;
  justify-content: center !important;
  align-items: center !important;
  flex-wrap: nowrap !important; /* keep everything on one line */
  gap: 8px !important;
  text-align: center !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button,
.dataTables_wrapper .dataTables_paginate span.ellipsis{
  display: inline-flex !important;
  align-items: center !important;
  justify-content: center !important;
  white-space: nowrap !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button{
  float: none !important; /* kill theme floats */
}
</style>
<style>
/* ===== ECUPRATIX Pagination v7 (center page numbers) ===== */
.dataTables_wrapper .dataTables_paginate{
  justify-content: center !important;
}

/* Make prev/next stick to edges while numbers centered */
.dataTables_wrapper .dataTables_paginate{
  position: relative !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.previous{
  position: absolute !important;
  left: 12px !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.next{
  position: absolute !important;
  right: 12px !important;
}

/* Optional: first/last if enabled */
.dataTables_wrapper .dataTables_paginate a.paginate_button.first{
  position: absolute !important;
  left: 60px !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.last{
  position: absolute !important;
  right: 60px !important;
}

/* Keep numeric buttons in the center line */
.dataTables_wrapper .dataTables_paginate a.paginate_button:not(.previous):not(.next):not(.first):not(.last),
.dataTables_wrapper .dataTables_paginate span.ellipsis{
  position: relative !important;
  z-index: 2 !important;
}
</style>
<style>
/* ===== ECUPRATIX Pagination v8 (center + icon prev/next) ===== */
.dataTables_wrapper .dataTables_paginate a.paginate_button.previous,
.dataTables_wrapper .dataTables_paginate a.paginate_button.next,
.dataTables_wrapper .dataTables_paginate a.paginate_button.first,
.dataTables_wrapper .dataTables_paginate a.paginate_button.last{
  position: static !important;
  left: auto !important;
  right: auto !important;
}

.dataTables_wrapper .dataTables_paginate{
  justify-content: center !important;
}

.dataTables_wrapper .dataTables_paginate a.paginate_button.previous,
.dataTables_wrapper .dataTables_paginate a.paginate_button.next{
  width: 44px !important;
  min-width: 44px !important;
  padding: 0 !important;
  font-size: 20px !important;
  font-weight: 900 !important;
}

.dataTables_wrapper .dataTables_paginate a.paginate_button.previous{
  border-color: rgba(0, 200, 255, .35) !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
  color: rgba(0, 200, 255, .95) !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.next{
  border-color: rgba(0, 255, 170, .35) !important;
  box-shadow: 0 0 0 4px rgba(0, 255, 170, .08) !important;
  color: rgba(0, 255, 170, .95) !important;
}

.dataTables_wrapper .dataTables_paginate a.paginate_button.previous:hover{
  background: rgba(0, 200, 255, .12) !important;
}
.dataTables_wrapper .dataTables_paginate a.paginate_button.next:hover{
  background: rgba(0, 255, 170, .12) !important;
}
</style>
<style>
/* ===== ECUPRATIX Pagination v9 (ID-based hard override) ===== */
#dtcTable_wrapper #dtcTable_paginate{
  width: 100% !important;
  display: flex !important;
  justify-content: center !important;
  align-items: center !important;
  flex-wrap: nowrap !important;
  gap: 10px !important;
  padding: 14px 14px !important;
  border: 1px solid rgba(255,255,255,.08) !important;
  background: rgba(255,255,255,.03) !important;
  border-radius: 18px !important;
  box-shadow: inset 0 0 0 1px rgba(0,0,0,.35);
}

#dtcTable_wrapper #dtcTable_paginate a.paginate_button,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button{
  float: none !important;
  display: inline-flex !important;
  align-items: center !important;
  justify-content: center !important;
  margin: 0 4px !important;
  white-space: nowrap !important;
  border: 1px solid rgba(255,255,255,.10) !important;
  background: rgba(0,0,0,.25) !important;
  color: rgba(255,255,255,.86) !important;
  border-radius: 999px !important;
  min-width: 42px !important;
  height: 42px !important;
  padding: 0 14px !important;
  line-height: 1 !important;
  font-weight: 800 !important;
  text-decoration: none !important;
  transition: transform .08s ease, background .12s ease, border-color .12s ease, box-shadow .12s ease;
}

#dtcTable_wrapper #dtcTable_paginate a.paginate_button:hover,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button:hover{
  background: rgba(255,255,255,.08) !important;
  border-color: rgba(255,255,255,.22) !important;
  transform: translateY(-1px) !important;
}

#dtcTable_wrapper #dtcTable_paginate a.paginate_button.current,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button.current{
  background: rgba(0, 200, 255, .18) !important;
  border-color: rgba(0, 200, 255, .35) !important;
  color:#fff !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
}

#dtcTable_wrapper #dtcTable_paginate a.paginate_button.disabled,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button.disabled{
  opacity:.35 !important;
  cursor:not-allowed !important;
  transform:none !important;
}

/* Make prev/next circular icon buttons */
#dtcTable_wrapper #dtcTable_paginate a.paginate_button.previous,
#dtcTable_wrapper #dtcTable_paginate a.paginate_button.next,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button.previous,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button.next{
  width: 46px !important;
  min-width: 46px !important;
  padding: 0 !important;
  font-size: 20px !important;
  font-weight: 900 !important;
}

#dtcTable_wrapper #dtcTable_paginate a.paginate_button.previous,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button.previous{
  border-color: rgba(0, 200, 255, .35) !important;
  box-shadow: 0 0 0 4px rgba(0, 200, 255, .08) !important;
  color: rgba(0, 200, 255, .98) !important;
}
#dtcTable_wrapper #dtcTable_paginate a.paginate_button.next,
#dtcTable_wrapper #dtcTable_paginate span.paginate_button.next{
  border-color: rgba(0, 255, 170, .35) !important;
  box-shadow: 0 0 0 4px rgba(0, 255, 170, .08) !important;
  color: rgba(0, 255, 170, .98) !important;
}

#dtcTable_wrapper #dtcTable_paginate span.ellipsis{
  display:inline-flex !important;
  align-items:center !important;
  justify-content:center !important;
  padding: 0 8px !important;
  color: rgba(255,255,255,.45) !important;
}
</style>
<style>
/* ===== ECUPRATIX Profile Bar v2 (headline blocks + ECU vector) ===== */
.ecu-headrow{
  display:flex;
  align-items:center;
  gap:14px;
  flex-wrap:wrap;
}
.ecu-headrow .ecu-title{
  font-size: 30px;
  font-weight: 900;
  letter-spacing: .4px;
}
.ecu-info{
  display:flex;
  align-items:center;
  gap:10px;
  flex-wrap:wrap;
}
.ecu-chip{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding: 8px 12px;
  border-radius: 999px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(255,255,255,.03);
  box-shadow: inset 0 0 0 1px rgba(0,0,0,.35);
}
.ecu-chip-label{
  font-size: 11px;
  font-weight: 800;
  letter-spacing: 1.2px;
  color: rgba(255,255,255,.55);
}
.ecu-chip-val{
  font-size: 16px;
  font-weight: 900;
  color: rgba(255,255,255,.92);
}
.ecu-right{
  display:flex;
  align-items:center;
  justify-content:flex-end;
  min-width: 220px;
}
.ecu-vector{
  height: 64px; max-height:64px !important;
  width: auto;
  border-radius: 14px;
  border: 1px solid rgba(255,255,255,.08);
  background: rgba(255,255,255,.02);
  box-shadow: 0 10px 30px rgba(0,0,0,.35);
  padding: 6px;
  opacity: .95;
}
@media (max-width: 900px){
  .ecu-right{min-width: 140px;}
  .ecu-vector{height: 54px;}
  .ecu-headrow .ecu-title{font-size: 26px;}
}
</style>
<style>
/* ===== ECUPRATIX Profile Bar v3 (remove MODEL chip + ECU icon + status) ===== */
.ecu-chip-ico{
  width: 16px;
  height: 16px;
  margin-right: 6px;
  vertical-align: -3px;
  opacity: .95;
  filter: drop-shadow(0 0 10px rgba(0,200,255,.25));
}
.scan-status{
  display:inline-flex;
  align-items:center;
  gap:10px;
  padding: 8px 12px;
  border-radius: 999px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(255,255,255,.03);
  box-shadow: inset 0 0 0 1px rgba(0,0,0,.35);
  color: rgba(255,255,255,.78);
  font-size: 12px;
  font-weight: 700;
  letter-spacing: .2px;
  margin-bottom: 10px;
}
.scan-dot{
  width: 8px;
  height: 8px;
  border-radius: 99px;
  background: rgba(0,255,170,.9);
  box-shadow: 0 0 0 4px rgba(0,255,170,.12);
}
.ecu-right{
  flex-direction: column;
  align-items: flex-end;
}
</style>
<style>
/* ===== ECUPRATIX Profile Bar v4 (remove badges + bigger horizontal fit) ===== */
.ecu-headrow{
  flex-wrap: nowrap;
}
.ecu-headrow .ecu-title{
  font-size: 34px;
  font-weight: 950;
}
.ecu-info{
  flex-wrap: nowrap;
}
.ecu-chip{
  padding: 10px 14px;
}
.ecu-chip-label{
  font-size: 12px;
}
.ecu-chip-val{
  font-size: 18px;
}
.ecu-right{
  min-width: 0;
}
.scan-status{
  margin-bottom: 0;
}
</style>
<style>
/* ===== ECUPRATIX Profile Bar v5 (3-way split: Brand / ECU / Status) ===== */
.ecu-split{
  width: 100%;
  display: grid;
  grid-template-columns: 1fr 1fr 1fr;
  gap: 14px;
  align-items: center;
  padding: 6px 0;
}
.ecu-split-col{
  min-height: 74px;
  display:flex;
  align-items:center;
  justify-content:center;
  border: 1px solid rgba(255,255,255,.08);
  background: rgba(255,255,255,.02);
  border-radius: 18px;
  box-shadow: inset 0 0 0 1px rgba(0,0,0,.35);
  padding: 12px 14px;
}
.ecu-split-brand{
  justify-content:flex-start;
}
.ecu-split-brand .ecu-title{
  font-size: 34px;
  font-weight: 950;
  letter-spacing: .4px;
  margin: 0;
}
.ecu-ecuwrap{
  width: 100%;
  display:flex;
  align-items:center;
  justify-content:center;
  gap: 12px;
}
.ecu-chip-ecu{
  padding: 10px 14px;
}
.ecu-chip-ecu .ecu-chip-label{
  font-size: 12px;
  font-weight: 900;
  letter-spacing: 1.1px;
}
.ecu-chip-ecu .ecu-chip-val{
  font-size: 18px;
  font-weight: 950;
}
.ecu-vector{
  height: 54px;
  width: auto;
  border-radius: 14px;
  border: 1px solid rgba(255,255,255,.08);
  background: rgba(255,255,255,.02);
  padding: 6px;
  box-shadow: 0 10px 30px rgba(0,0,0,.35);
  opacity: .92;
}
.ecu-pill-status{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  gap:10px;
  padding: 10px 14px;
  border-radius: 999px;
  border: 1px solid rgba(0,255,170,.22);
  background: rgba(0,255,170,.06);
  color: rgba(255,255,255,.88);
  font-weight: 900;
  font-size: 13px;
  letter-spacing: .2px;
  box-shadow: 0 0 0 4px rgba(0,255,170,.06);
}
.ecu-pill-status .ecu-pulse{
  width: 9px;
  height: 9px;
  border-radius: 99px;
  background: rgba(0,255,170,.9);
  box-shadow: 0 0 0 4px rgba(0,255,170,.12);
}
.ecu-split-status{
  justify-content:flex-end;
}
@media (max-width: 1100px){
  .ecu-split{grid-template-columns: 1fr; }
  .ecu-split-brand{justify-content:center;}
  .ecu-split-status{justify-content:center;}
  .ecu-split-col{justify-content:center;}
}
</style>
<style>
/* ===== ECU vector image v6 (transparent + more visible) ===== */
.ecu-vector{
  height: 64px !important;
  padding: 0 !important;
  border: none !important;
  background: transparent !important;
  box-shadow: none !important;
  opacity: 1 !important;
  filter: drop-shadow(0 12px 26px rgba(0,0,0,.55));
}
</style>
<style>
/* ===== v16: hide step/breadcrumb bar ===== */
#flowStrip{ display:none !important; }
</style>
<style>
/* ===== v16: status left, OEM/OBD2 right ===== */
.ecu-statusbar{
  width:100%;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:12px;
}
.ecu-mini-badges{
  display:flex;
  align-items:center;
  gap:10px;
  justify-content:flex-end;
  flex: 0 0 auto;
}
.ecu-mini-badge{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  padding: 10px 12px;
  border-radius: 999px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(255,255,255,.03);
  font-weight: 900;
  font-size: 12px;
  letter-spacing: .2px;
  white-space: nowrap;
}
.ecu-mini-oem{
  border-color: rgba(255,195,0,.28);
  background: rgba(255,195,0,.08);
}
.ecu-mini-obd2{
  border-color: rgba(0,140,255,.28);
  background: rgba(0,140,255,.08);
}
</style>
<style>
/* ===== v16: full width search ===== */
#dtcTable_wrapper .dataTables_filter{
  width:100% !important;
  float:none !important;
  text-align:left !important;
  margin: 10px 0 12px 0 !important;
}
#dtcTable_wrapper .dataTables_filter label{
  width:100% !important;
  display:flex !important;
  align-items:center !important;
  gap: 10px !important;
}
#dtcTable_wrapper .dataTables_filter input{
  width:100% !important;
  flex:1 1 auto !important;
  min-width: 260px !important;
}
</style>
<style>
/* ===== v17: pagination full width + centered ===== */
#dtcTable_wrapper #dtcTable_paginate{
  width: 100% !important;
  max-width: 100% !important;
  display: flex !important;
  justify-content: center !important;
  align-items: center !important;
  flex-wrap: nowrap !important;
  padding: 16px 14px !important;
  margin: 0 auto !important;
}
#dtcTable_wrapper .dataTables_paginate{
  width: 100% !important;
}
</style>
<style>
/* ===== v17: square upload popup UX ===== */
.ecu-swal-popup{
  border-radius: 10px !important; /* square-ish */
  border: 1px solid rgba(255,255,255,.10) !important;
  background: rgba(15,15,16,.96) !important;
  box-shadow: 0 20px 70px rgba(0,0,0,.65) !important;
}
.ecu-swal-title{
  color: rgba(255,255,255,.92) !important;
  letter-spacing: .2px !important;
}
.ecu-swal-html{
  color: rgba(255,255,255,.78) !important;
}
.ecu-upload-grid{
  display:grid;
  grid-template-columns: 1fr 1fr;
  gap: 12px;
  margin-top: 10px;
}
.ecu-u-card{
  border: 1px solid rgba(255,255,255,.08);
  background: rgba(255,255,255,.03);
  border-radius: 10px;
  padding: 12px;
}
.ecu-u-k{
  font-size: 11px;
  font-weight: 900;
  letter-spacing: 1.2px;
  color: rgba(255,255,255,.55);
}
.ecu-u-v{
  margin-top: 4px;
  font-size: 14px;
  font-weight: 900;
  color: rgba(255,255,255,.92);
}
.ecu-u-pill{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding: 8px 10px;
  border-radius: 999px;
  border: 1px solid rgba(0,255,170,.22);
  background: rgba(0,255,170,.08);
  font-weight: 900;
  font-size: 12px;
  color: rgba(255,255,255,.92);
}
.ecu-u-dot{
  width: 9px; height: 9px; border-radius: 99px;
  background: rgba(0,255,170,.95);
  box-shadow: 0 0 0 4px rgba(0,255,170,.14);
}
.ecu-swal-btn{
  border-radius: 10px !important;
  font-weight: 900 !important;
  letter-spacing: .2px !important;
}
</style>
<style>
/* ===== v18: animated neon upload popup + 4 blocks ===== */
.ecu-swal-popup{
  width: 820px !important;
  max-width: calc(100vw - 48px) !important;
  border-radius: 12px !important;
  border: 1px solid rgba(0,255,170,.22) !important;
  background: rgba(12,12,13,.96) !important;
  box-shadow: 0 24px 80px rgba(0,0,0,.72) !important;
  overflow: hidden !important;
  position: relative !important;
}

/* animated border light */
.ecu-swal-popup:before{
  content:"";
  position:absolute; inset:-2px;
  background: conic-gradient(from 180deg,
    rgba(0,255,170,0) 0deg,
    rgba(0,255,170,.35) 60deg,
    rgba(0,255,170,0) 120deg,
    rgba(0,255,170,.35) 180deg,
    rgba(0,255,170,0) 240deg,
    rgba(0,255,170,.35) 300deg,
    rgba(0,255,170,0) 360deg);
  filter: blur(10px);
  opacity: .7;
  animation: ecuNeonSpin 2.8s linear infinite;
  z-index: 0;
}
.ecu-swal-popup:after{
  content:"";
  position:absolute; inset:1px;
  background: rgba(12,12,13,.96);
  border-radius: 12px;
  z-index: 1;
}
@keyframes ecuNeonSpin{
  from{ transform: rotate(0deg); }
  to{ transform: rotate(360deg); }
}
.ecu-swal-title, .ecu-swal-html{ position: relative; z-index: 2; }
.ecu-swal-title{ color: rgba(255,255,255,.92) !important; letter-spacing:.2px !important; }
.ecu-swal-html{ color: rgba(255,255,255,.78) !important; }

.ecu-upload-grid{
  display:grid;
  grid-template-columns: 1fr 1fr;
  gap: 12px;
  margin-top: 12px;
}
.ecu-u-card{
  border: 1px solid rgba(255,255,255,.08);
  background: rgba(255,255,255,.03);
  border-radius: 12px;
  padding: 14px 14px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap: 12px;
}
.ecu-u-left{
  display:flex; align-items:center; gap: 10px;
}
.ecu-upload-grid-compact{ margin-top: 0; }
.ecu-u-card-center{ display:flex; align-items:center; justify-content:center; }
.ecu-u-left-center{ justify-content:center; width:100%; }
.ecu-u-ico{
  width: 34px; height: 34px;
  border-radius: 10px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(0,0,0,.22);
  display:flex; align-items:center; justify-content:center;
  font-weight: 1000;
  font-size: 16px;
}
.ecu-u-ico.brand{ border-color: rgba(0,200,255,.22); color: rgba(0,200,255,.95); box-shadow: 0 0 0 4px rgba(0,200,255,.06); }
.ecu-u-ico.ecu{ border-color: rgba(0,255,170,.22); color: rgba(0,255,170,.95); box-shadow: 0 0 0 4px rgba(0,255,170,.06); }
.ecu-u-ico.oem{ border-color: rgba(255,195,0,.22); color: rgba(255,195,0,.95); box-shadow: 0 0 0 4px rgba(255,195,0,.06); }
.ecu-u-ico.obd{ border-color: rgba(0,140,255,.22); color: rgba(0,140,255,.95); box-shadow: 0 0 0 4px rgba(0,140,255,.06); }

.ecu-u-k{
  font-size: 11px;
  font-weight: 950;
  letter-spacing: 1.2px;
  color: rgba(255,255,255,.55);
}
.ecu-u-v{
  margin-top: 3px;
  font-size: 16px;
  font-weight: 950;
  color: rgba(255,255,255,.92);
  max-width: 290px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  text-align: right;
}
.ecu-u-pill{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding: 8px 10px;
  border-radius: 999px;
  border: 1px solid rgba(0,255,170,.22);
  background: rgba(0,255,170,.08);
  font-weight: 950;
  font-size: 12px;
  color: rgba(255,255,255,.92);
}
.ecu-u-dot{
  width: 9px; height: 9px; border-radius: 99px;
  background: rgba(0,255,170,.95);
  box-shadow: 0 0 0 4px rgba(0,255,170,.14);
}

/* hide confirm button - auto close */
.ecu-swal-popup .swal2-confirm{ display:none !important; }
</style>
<style>
/* ===== v22: big square scan overlay (4 blocks) - no flow break ===== */
#scanOverlay{
  position: fixed;
  inset: 0;
  display: none;
  align-items: center;
  justify-content: center;
  z-index: 999999;
  background: rgba(0,0,0,.70) !important;
  backdrop-filter: blur(10px);
}
#scanOverlay .scan-title,
#scanOverlay .scan-progress,
#scanOverlay .scan-hint{
  display:none !important;
}
#scanOverlay .scan-stage{
  width: min(860px, calc(100vw - 40px)) !important;
}
#scanOverlay /* injected square */
.scan-square-v22{
  position: relative;
  border-radius: 14px;
  overflow:hidden;
  padding: 18px;
  background: rgba(10,10,11,.92);
  border: 1px solid rgba(0,255,170,.18);
  box-shadow: 0 30px 110px rgba(0,0,0,.75);
}
.scan-square-v22:before{
  content:"";
  position:absolute; inset:-3px;
  background: conic-gradient(from 180deg,
    rgba(0,255,170,0) 0deg,
    rgba(0,255,170,.40) 70deg,
    rgba(0,255,170,0) 140deg,
    rgba(0,255,170,.40) 210deg,
    rgba(0,255,170,0) 280deg,
    rgba(0,255,170,.40) 360deg);
  filter: blur(12px);
  opacity: .75;
  animation: scanNeonSpinV22 2.8s linear infinite;
  z-index: 0;
}
.scan-square-v22:after{
  content:"";
  position:absolute; inset:1px;
  background: rgba(10,10,11,.92);
  border-radius: 14px;
  z-index: 1;
}
@keyframes scanNeonSpinV22{ from{transform:rotate(0)} to{transform:rotate(360deg)} }

.scan-grid-v22{
  position: relative;
  z-index: 2;
  display:grid;
  grid-template-columns: 1fr 1fr;
  gap: 14px;
}
.scan-box-v22{
  border-radius: 12px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(255,255,255,.03);
  padding: 16px 16px;
  min-height: 104px;
  display:flex;
  flex-direction:column;
  justify-content:space-between;
}
.scan-k-v22{
  display:flex;
  align-items:center;
  gap:10px;
  font-size: 12px;
  font-weight: 950;
  letter-spacing: 1.3px;
  color: rgba(255,255,255,.55);
}
.scan-k-v22 .ico{
  width: 34px; height: 34px;
  display:inline-flex;
  align-items:center;
  justify-content:center;
  border-radius: 10px;
  border: 1px solid rgba(255,255,255,.12);
  background: rgba(0,0,0,.25);
  font-weight: 1000;
  font-size: 14px;
}
.scan-v-v22{
  font-size: 26px;
  font-weight: 950;
  color: rgba(255,255,255,.94);
  line-height: 1.05;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}


.brand-logo-slot{ display:inline-flex; align-items:center; justify-content:center; width:34px; height:34px; border-radius: 10px; margin-right:10px; background: rgba(255,255,255,.03); border:1px solid rgba(255,255,255,.10); overflow:hidden; flex:0 0 auto; }
.brand-logo-img-v22{ width:100%; height:100%; object-fit:contain; display:block; }
.ecu-ico-v22{ display:inline-flex; align-items:center; justify-content:center; width:34px; height:34px; border-radius: 10px; margin-right:10px; background: rgba(0,255,170,.10); border:1px solid rgba(0,255,170,.20); color: rgba(0,255,170,.95); font-weight:900; font-size:12px; letter-spacing:.3px; flex:0 0 auto; }
.scan-wait-v22 .ico{ border-color: rgba(255,205,0,.25); color: rgba(255,205,0,.95); box-shadow: 0 0 0 5px rgba(255,205,0,.06); }
.scan-wait-v22 #scanWaitMsgV22{ font-size: 16px; font-weight: 800; white-space: normal; line-height: 1.25; color: rgba(255,255,255,.92); }

/* accents */
.scan-brand-v22 .ico{ border-color: rgba(0,200,255,.25); color: rgba(0,200,255,.95); box-shadow: 0 0 0 5px rgba(0,200,255,.06); }
.scan-ecu-v22   .ico{ border-color: rgba(0,255,170,.25); color: rgba(0,255,170,.95); box-shadow: 0 0 0 5px rgba(0,255,170,.06); }
.scan-oem-v22   { border-color: rgba(255,195,0,.18); }
.scan-oem-v22 .ico{ border-color: rgba(255,195,0,.25); color: rgba(255,195,0,.95); box-shadow: 0 0 0 5px rgba(255,195,0,.06); }
.scan-obd2-v22  { border-color: rgba(0,255,110,.18); }
.scan-obd2-v22 .ico{ border-color: rgba(0,255,110,.25); color: rgba(0,255,110,.95); box-shadow: 0 0 0 5px rgba(0,255,110,.06); }
</style>
<style>
/* ===== v26 i18n language selector ===== */
.langbox{
  display:flex;
  align-items:center;
  gap:10px;
  justify-content:flex-end;
  margin-right: 6px;
}
.langlbl{
  font-weight: 900;
  font-size: 12px;
  letter-spacing: .3px;
  color: rgba(255,255,255,.72);
}
.langsel{
  appearance: none;
  -webkit-appearance: none;
  -moz-appearance: none;
  padding: 9px 12px;
  border-radius: 12px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(255,255,255,.03);
  color: rgba(255,255,255,.92);
  font-weight: 900;
  font-size: 12px;
  letter-spacing: .2px;
  outline: none;
}
.langsel:focus{
  border-color: rgba(0,255,170,.25);
  box-shadow: 0 0 0 4px rgba(0,255,170,.08);
}
</style>
<style>
/* ===== v27 i18n selector (before logout) ===== */
.langbox-top{
  display:flex;
  align-items:center;
  justify-content:flex-end;
}
.langsel{
  appearance: none;
  -webkit-appearance: none;
  -moz-appearance: none;
  padding: 9px 12px;
  border-radius: 12px;
  border: 1px solid rgba(255,255,255,.10);
  background: rgba(255,255,255,.03);
  color: rgba(255,255,255,.92);
  font-weight: 900;
  font-size: 12px;
  letter-spacing: .2px;
  outline: none;
  min-width: 170px;
}
.langsel option{
  color: #111;
  background: #fff;
}
.langsel:focus{
  border-color: rgba(0,255,170,.25);
  box-shadow: 0 0 0 4px rgba(0,255,170,.08);
}

/* ===== quota + user pill ===== */
.quota-chip{
  display:flex;align-items:center;gap:8px;
  padding:10px 12px;border-radius:14px;
  background:rgba(14,18,18,.75);
  border:1px solid rgba(255,255,255,.10);
  box-shadow:0 10px 30px rgba(0,0,0,.25);
  color:#eafaf3;
  min-width: 120px;
  justify-content:center;
}
.quota-chip i{color:#00ffaa;opacity:.9}
.quota-chip span{font-weight:800;letter-spacing:.2px}
.quota-chip .quota-label{font-size:11px;opacity:.75;font-weight:900;letter-spacing:.8px}
.quota-chip #quotaText{font-size:14px}

.user-pill{
  display:flex;align-items:center;gap:8px;
  padding:10px 12px;border-radius:14px;
  background:rgba(14,18,18,.75);
  border:1px solid rgba(255,255,255,.10);
  box-shadow:0 10px 30px rgba(0,0,0,.25);
  color:#eaf3ff;
}
.user-pill i{opacity:.9}
.user-pill .user-name{font-weight:800;letter-spacing:.2px}
.user-pill .user-sep{opacity:.45}
.user-pill .user-days{opacity:.85;font-weight:700}


/* HOTFIX: hide MARKA/ECU headings inside scan popup cards */
#scanOverlay .scan-k-v22{display:none !important;}
</style>

<style>
.auto-dtc-bar{
  margin-top:10px;
  padding:10px 12px;
  border:1px solid rgba(255,255,255,.08);
  background: rgba(255,255,255,.03);
  border-radius:16px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:12px;
  flex-wrap:wrap;
}
.auto-dtc-title{
  font-weight:800;
  letter-spacing:.4px;
  color: rgba(0,255,170,.95);
  display:flex;
  align-items:center;
  gap:8px;
  white-space:nowrap;
}
.auto-dtc-buttons{
  display:flex;
  gap:8px;
  flex-wrap:wrap;
  justify-content:flex-end;
}
.auto-btn{
  border:1px solid rgba(0,255,170,.35);
  background: rgba(0,255,170,.08);
  color:#dffdf3;
  padding:6px 12px;
  border-radius:999px;
  font-weight:800;
  font-size:12px;
}
.auto-btn:hover{ background: rgba(0,255,170,.14); }
.auto-btn:active{ transform: translateY(1px); }
.auto-btn-clear{
  border-color: rgba(255,90,120,.45);
  background: rgba(255,90,120,.12);
}
.auto-btn-clear:hover{ background: rgba(255,90,120,.18); }
</style>


<style>
/* === SAFE SIDE SCROLLBAR HIDE (DOES NOT BREAK UPDATES) === */
body::-webkit-scrollbar { width: 0px; height: 0px; }
html { scrollbar-width: none; }
html, body { overflow-x: hidden; }
</style>


<style id="swal-force-white-visible">
/* === FORCE SWEETALERT TEXT VISIBLE (WHITE) === */
.swal2-title,
.swal2-html-container,
.swal2-content,
.swal2-popup{
  color:#ffffff !important;
  opacity:1 !important;
  filter:none !important;
  mix-blend-mode:normal !important;
}
.swal2-title{ font-weight:900 !important; }
.swal2-html-container{ font-weight:900 !important; }

.ecu-swal-title,
.ecu-swal-html{
  color:#ffffff !important;
  opacity:1 !important;
}

.swal-table-notfound{
  color:#ffffff !important;
  font-weight:900 !important;
  font-size:18px !important;
  line-height:1.35 !important;
  text-align:center !important;
  text-shadow: 0 0 10px rgba(0,0,0,0.9) !important;
}
</style>

</head>
<body>
<div class="topbar">
  <div class="container-fluid py-3">
    <div class="d-flex align-items-center justify-content-between gap-3">
      <div class="d-flex align-items-center gap-2 brand">
        <i class="fas fa-microchip text-primary"></i>
        <span class="fw-bold">ECU PRATIX</span>
        <span class="text-secondary ms-2">USER</span>
      </div>

      <div class="ms-auto d-flex align-items-center gap-2">
        <div class="quota-chip" id="quotaChip" title="Günlük Limit">
          <i class="fas fa-bolt"></i>
          <span class="quota-label">LIMIT</span>
          <span id="quotaText">-</span>
        </div>

        <div class="langbox-top d-flex align-items-center gap-2">
          <span class="langlbl" data-i18n="lang">Dil</span>
          <select id="langSelect" class="langsel"></select>
        </div>

        <div class="user-pill" id="userPill" title="Lisans / Kullanıcı">
          <i class="fas fa-user-circle"></i>
          <span class="user-name" id="userName">-</span>
          <span class="user-sep">•</span>
          <span class="user-days"><span id="licenseDays">-</span> gün</span>
        </div>

        <button class="btn btn-outline-danger" onclick="$.post('api.php',{action:'logout'},()=>{location.href='login.php'})">
          <i class="fas fa-sign-out-alt me-2"></i><span data-i18n="logout">Çıkış</span>
        </button>
      </div>
</div>
  </div>
</div>

<!-- UPDATES BAR (Topbar Altı) -->
<div class="updates-bar" id="updatesBar">
  <div class="updates-head">
    <div class="updates-title">
      <span class="updates-dot"></span>
      <span>UPDATES</span>
    </div>
    <div class="updates-sub"></div>
  </div>
  <div class="updates-viewport">
    <div class="updates-track" id="updatesRow"></div>
  </div>
</div>

<div class="container-fluid py-4">
	  <!-- Premium ECU Profile (sticky) -->
  <div class="ecu-sticky mb-3" id="ecuProfileBar">
    <div class="ecu-card">
      <div class="ecu-card-inner">
        <div class="ecu-logo" id="ecuLogoWrap">
          <i class="fas fa-car-side text-secondary" style="font-size:26px"></i>
        </div>
        <div class="flex-grow-1">
          <div class="ecu-split">
  <div class="ecu-split-col ecu-split-brand">
    <div class="ecu-title" id="ecuBrandText">-</div>
  </div>
  <div class="ecu-split-col ecu-split-ecu">
    <div class="ecu-ecuwrap">
      <span class="ecu-chip ecu-chip-ecu" id="ecuEcuChip">
        <span class="ecu-chip-label">
          <img src="assets/img/ecu_icon.png" class="ecu-chip-ico" alt=""> ECU
        </span>
        <span class="ecu-chip-val" id="ecuEcuVal">-</span>
      </span>
      <img src="assets/img/ecu_vector.png" class="ecu-vector" alt="ECU">
    </div>
  </div>
  <div class="ecu-split-col ecu-split-status">
<div class="ecu-statusbar">
    <span class="ecu-pill ecu-pill-status">
      <span class="ecu-pulse"></span>
      <span id="ecuStatusText" data-i18n="binary_waiting">Binary bekleniyor</span>
    </span>
    <div class="ecu-mini-badges">
      <span class="ecu-mini-badge ecu-mini-oem" id="ecuOemCount">OEM: 0</span>
      <span class="ecu-mini-badge ecu-mini-obd2" id="ecuObd2Count">OBD2: 0</span>
    </div>
  </div>
</div>
</div>
        </div>
        
      </div>
    </div>
  </div>

  <!-- Flow strip (after popup) -->
  <div class="cardx mb-3 d-none" id="flowStrip">
    <div class="cardx-b py-2">
      <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
        <div class="d-flex align-items-center gap-2 flex-wrap">
          <span class="badge bg-secondary"><i class="fas fa-cloud-upload-alt me-1"></i> <span data-i18n="upload">Binary Yükle</span></span>
          <i class="fas fa-arrow-right text-secondary"></i>
          <span class="badge bg-secondary"><i class="fas fa-list-check me-1"></i> <span data-i18n="selected_dtcs">Seçilen DTC'ler</span></span>
          <i class="fas fa-arrow-right text-secondary"></i>
          <span class="badge bg-secondary"><i class="fas fa-table-list me-1"></i> <span data-i18n="dtc_menu">DTC Menüsü</span></span>
        </div>
        <div class="d-flex align-items-center gap-2">
          <span class="badge bg-warning text-dark" id="flowOemCount"></span>
          <span class="badge bg-primary" id="flowObd2Count"></span>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-3 align-items-stretch">
    <div class="col-lg-5">
      <div class="cardx h-100">
        <div class="cardx-h d-flex align-items-center justify-content-between">
          <div class="fw-bold"><i class="fas fa-cloud-upload-alt me-2 text-secondary"></i><span data-i18n="upload">Binary Yükle</span></div>
          <span class="badge bg-light text-dark" id="profileBadge"><span data-i18n="profile">Profil</span>: <span id="profileVal">-</span></span>
        </div>
        <div class="cardx-b">
          <div class="drop-zone" id="dropZone">
            <i class="fas fa-file-arrow-up fa-3x mb-2 text-secondary"></i>
            <div class="fw-bold" data-i18n="drop_here">Dosyayı Sürükle veya Tıkla</div>
            <div class="text-secondary" style="font-size:13px" data-i18n="dtc_fills_on_upload">DTC menüsü binary yüklendiğinde dolar.</div>
            <input type="file" id="fileIn" />
            <div class="matrix-wrap" id="matrixWrap"><div class="matrix" id="matrix"></div></div>
          </div>
          <div class="progress mt-3 d-none"><div class="progress-bar bg-primary" style="width:0%"></div></div>
          <div class="mt-3 d-flex align-items-center gap-2">
            <span class="text-secondary" style="font-size:13px" data-i18n="dtc_fills_on_upload"></span>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-7">
      <div class="cardx h-100">
        <div class="cardx-h d-flex align-items-center justify-content-between">
          <div class="fw-bold"><i class="fas fa-list-check me-2 text-success"></i><span data-i18n="selected_dtcs">Seçilen DTC'ler</span></div>
          <button class="btn btn-success" id="saveBtn" onclick="saveSelected()" disabled><i class="fas fa-check me-2"></i><span data-i18n="save">Kaydet</span></button>
        </div>
        <div class="cardx-b">
          <div id="selectedEmpty" class="text-secondary" data-i18n="no_selection">Henüz seçim yok.</div>
          <div id="selectedList" class="d-none" style="max-height:160px;overflow:auto"></div>
          <div class="text-secondary mt-2" style="font-size:12px" data-i18n="off_included"></div>
        </div>
      </div>
    </div>
  </div>

  <div class="mt-3 table-wrap">
    <div class="table-head">
      <div class="fw-bold" data-i18n="dtc_menu">DTC Menüsü</div>
      <div class="d-flex align-items-center gap-2" style="min-width:340px">
        <span class="text-secondary" style="font-size:12px" data-i18n="search">Search:</span>
        <input id="dtcSearch" class="form-control form-control-sm" data-i18n-ph="search_ph" placeholder="DTC ara..." autocomplete="off" />
      </div>
    </div>
    <div class="p-2 pt-0">
      <div class="auto-dtc-bar">
        <div class="auto-dtc-title"><i class="fas fa-wand-magic-sparkles me-2"></i><span>AUTO DTC</span></div>
        <div class="auto-dtc-buttons">
          <button class="auto-btn" type="button" onclick="autoDtcApply('DPF')">DPF</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('EGR')">EGR</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('LAMBDA')">LAMBDA</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('NOX')">NOX</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('FLAPS')">FLAPS</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('ADBLUE')">ADBLUE</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('TVA')">TVA</button>
          <button class="auto-btn" type="button" onclick="autoDtcApply('CAT')">CAT</button>
          <button class="auto-btn auto-btn-clear" type="button" onclick="autoDtcClear()">CLEAR</button>
        </div>
      </div>
    </div>
    <div class="p-2">
      <table id="dtcTable" class="table table-dark table-striped table-hover w-100 mb-0">
        <thead>
          <tr>
            <th data-i18n="th_status">STATUS</th>
            <th data-i18n="th_type">TİP</th>
            <th data-i18n="th_code">KOD</th>
            <th data-i18n="th_fmi">FMI</th>
            <th data-i18n="th_desc">Açıklama</th>
            <th data-i18n="th_hex">HEX</th>
            <th data-i18n="th_count">Adet</th>
            <th data-i18n="th_state">DURUM</th>
          </tr>
        </thead>
        <tbody>
          <tr><td colspan="8" class="text-center text-secondary py-4" data-i18n="upload_first">Binary yükleyin...</td></tr>
        </tbody>
      </table>
      <!-- Pagination MUST be visible here (1 2 3 4 ...) -->
      <div id="dtcPager" class="d-flex justify-content-end pt-2"></div>
    </div>
  </div>
</div>

<!-- Scan overlay (5s) -->
<div id="scanOverlay" class="scan-overlay">
  <div class="scan-stage">
    <div class="scan-title">
      <i class="fas fa-wave-square text-success"></i>
      <div>
        <div class="h3" data-i18n="profile_detected">ECU Profil Tespit Edildi</div>
        <div class="scan-sub" data-i18n="profile_before_dtc">DTC menüsü açılmadan önce profil bilgisi gösteriliyor (5s)</div>
      </div>
    </div>
    <div class="scan-progress mb-3"><div id="scanProg"></div></div>
    <div class="ecu-card">
      <div class="ecu-card-inner">
        <div class="ecu-logo" id="scanLogoWrap">
          <i class="fas fa-car-side text-secondary" style="font-size:26px"></i>
        </div>
        <div class="flex-grow-1">
          <div class="ecu-title" id="scanBrandText">-</div>
          <div class="ecu-sub" id="scanModelText" data-i18n="model_ecu_line">Model: -  •  ECU: -</div>
          <div class="ecu-meta">
            <span id="scanOemCount" style="display:none"></span>
            <span id="scanObd2Count" style="display:none"></span>
          </div>
        </div>
        <div class="ecu-badges">
          <span class="badge badge-group" id="scanGroupBadge"></span>
        </div>
      </div>
    </div>
</div>
</div>


<script>
var token=null;
var sel=new Set();
var selItems=new Map();
var matrixTimer=null;
// DataTables row metadata (needed so paging keeps row->group mapping)
window.dtRowMeta=[];

function __ecui18n(key, fallback){
  try{
    var lang = 'tr';
    try{ lang = localStorage.getItem('ecupratix_lang') || 'tr'; }catch(e){}
    var I = window.__ECU_I18N__ || null;
    if(I && I[lang] && I[lang][key]) return I[lang][key];
    if(I && I['tr'] && I['tr'][key]) return I['tr'][key];
  }catch(e){}
  return (fallback==null)?'':fallback;
}


function showProfilePopup(meta, onDone){
  var brand = String(meta.brand||'').trim();
  var ecu = String(meta.ecu_model||'').trim();
  var grp = String(meta.brand_group||'').trim();
  var logo = String(meta.brand_logo||'').trim();
  var profile = String(meta.profile_name||meta.profile||'').trim();
  var oemCount = Number.isFinite(parseInt(meta.oem_count,10)) ? parseInt(meta.oem_count,10) : 0;
  var obd2Count = Number.isFinite(parseInt(meta.obd2_count,10)) ? parseInt(meta.obd2_count,10) : 0;

  
  // update header mini badges
  try{ $('#ecuOemCount').text('OEM: ' + oemCount); $('#ecuObd2Count').text('OBD2: ' + obd2Count); }catch(e){}
var setLogo = (wrapSel, logoUrl)=>{
    var $w=$(wrapSel);
    if(!$w.length) return;
    if(logoUrl){
      $w.html(`<img src="${logoUrl}" alt="logo">`);
    } else {
      $w.html('<i class="fas fa-car-side text-secondary" style="font-size:26px"></i>');
    }
  };

  // Fill sticky profile bar
  setLogo('#ecuLogoWrap', logo);
  $('#ecuBrandText').text(brand||'-');
$('#ecuEcuVal').text(ecu||'-');
  // Main header should NOT show "Tarama tamamlandı" (that belongs to the popup)
  $('#ecuStatusText').text(__ecui18n('profile_detected','ECU Profil Tespit Edildi'));
  $('#ecuProfileBar').addClass('anim-slide');

  // Flow strip between blocks (after popup)
  $('#flowOemCount').text(`OEM: ${oemCount}`);
  $('#flowObd2Count').text(`OBD2: ${obd2Count}`);
  $('#flowStrip').removeClass('d-none').addClass('anim-pop');

  // Fill scan overlay card (same premium look)
  setLogo('#scanLogoWrap', logo);
  $('#scanBrandText').text(brand||'-');
  $('#scanModelText').text(`${__ecui18n('model','Model')}: ${(meta.vehicle_model||meta.model||'-')}  •  ECU: ${ecu||'-'}`);
  $('#scanGroupBadge').text(`${__ecui18n('group','GRUP')}: ${grp||'-'}`);
  // profile badge removed (UX)
  $('#scanOemCount').text(`OEM: ${oemCount}`);
  $('#scanObd2Count').text(`OBD2: ${obd2Count}`);

  // Show overlay for 5 seconds with progress
  $('#scanOverlay').css('display','flex');
  $('#scanOverlay .scan-stage').addClass('anim-pop');
  $('#scanProg').css('width','0%');
  setTimeout(()=>$('#scanProg').css('width','100%'), 40);

  setTimeout(()=>{
    $('#scanOverlay').hide();
    if(typeof onDone==='function') onDone();
  }, 5000);
}

function fmtDtc(code){
  var c=String(code||'').trim();
  if(/^P[0-9A-F]{4}$/i.test(c)) return c.substring(1).toUpperCase();
  return c.toUpperCase();
}
function isNumericCode(code){ return /^[0-9]+$/.test(String(code||'').trim()); }
function dtcType(code){ return isNumericCode(code) ? 'OEM' : 'OBD2'; }
function dtcNumForSort(code){
  var s=String(code||'').trim();
  if(!s) return 0;
  if(isNumericCode(s)) return parseInt(s,10)||0;
  // numeric siralama icin harfleri at ve sadece sayilari al
  var digits = s.replace(/[^0-9]/g,'');
  return parseInt(digits||'0',10)||0;
}
function stripFmi(desc){ if(!desc) return ''; return String(desc).replace(/\s*\(\s*FMI\s*[: ]\s*\d+\s*\)\s*/ig,' ').trim(); }

function matrixStart(){
  $('#matrix').empty();
  $('#matrixWrap').css('display','flex');
  var pool=["0401","0102","0110","0427","U0100","B0001","C1234","17965","3216","61607","287","00F0EE","04100D","08110F","021103","010209","05F0EE","06F0EE"];
  var pick=()=>pool[Math.floor(Math.random()*pool.length)];
  var nowLine=()=>{var a=[];var n=12+Math.floor(Math.random()*18);for(var i=0;i<n;i++)a.push(pick());return a.join(' ')};
  matrixTimer=setInterval(()=>{
    var el=$('<div class="matrix-line"></div>').text(nowLine());
    $('#matrix').append(el);
    var ch=$('#matrix').children();
    if(ch.length>18) ch.first().remove();
    ch.slice(0, Math.max(0, ch.length-6)).addClass('matrix-dim');
  },70);
}
function matrixStop(){ if(matrixTimer){clearInterval(matrixTimer);matrixTimer=null;} $('#matrixWrap').hide(); }

function ensureTable(){ /* DataTables disabled (stable custom paging) */ }

/* ============================
   Custom paging (ES5) - 50/page
   ============================ */
window.__DTC_PAGE_SIZE__ = 50;
window.__DTC_ALL__ = [];
window.__DTC_FILTERED__ = [];
window.__DTC_PAGE__ = 1;

function __dtc_norm(s){ return String(s || '').toLowerCase(); }

function __dtc_apply_filter(){
  var q = __dtc_norm($('#dtcSearch').val());
  if(!q){
    window.__DTC_FILTERED__ = window.__DTC_ALL__.slice();
    return;
  }
  var out = [];
  for(var i=0;i<window.__DTC_ALL__.length;i++){
    var r = window.__DTC_ALL__[i];
    if(__dtc_norm(r._search).indexOf(q) !== -1) out.push(r);
  }
  window.__DTC_FILTERED__ = out;
}

function __dtc_render_pager(){
  var total = window.__DTC_FILTERED__.length;
  var ps = window.__DTC_PAGE_SIZE__;
  var pages = Math.max(1, Math.ceil(total/ps));
  var p = parseInt(window.__DTC_PAGE__, 10) || 1;
  if(p < 1) p = 1;
  if(p > pages) p = pages;
  window.__DTC_PAGE__ = p;

  var $pager = $('#dtcPager');
  if(!$pager.length) return;

  var html = '<div class="dataTables_paginate paging_full_numbers">';
  html += '<a class="paginate_button previous '+(p===1?'disabled':'')+'" data-page="'+(p-1)+'">'+__ecui18n('paginate_prev','Previous')+'</a>';

  var maxBtns = 7;
  var s = Math.max(1, p - Math.floor(maxBtns/2));
  var e = Math.min(pages, s + maxBtns - 1);
  s = Math.max(1, e - maxBtns + 1);

  if(s > 1){
    html += '<a class="paginate_button" data-page="1">1</a>';
    if(s > 2) html += '<span class="ellipsis">…</span>';
  }

  for(var i=s;i<=e;i++){
    html += '<a class="paginate_button '+(i===p?'current':'')+'" data-page="'+i+'">'+i+'</a>';
  }

  if(e < pages){
    if(e < pages-1) html += '<span class="ellipsis">…</span>';
    html += '<a class="paginate_button" data-page="'+pages+'">'+pages+'</a>';
  }

  html += '<a class="paginate_button next '+(p===pages?'disabled':'')+'" data-page="'+(p+1)+'">'+__ecui18n('paginate_next','Next')+'</a>';
  html += '</div>';

  $pager.html(html);
}

function __dtc_render_table(){
  __dtc_apply_filter();

  var ps = window.__DTC_PAGE_SIZE__;
  var p = parseInt(window.__DTC_PAGE__, 10) || 1;
  var start = (p-1)*ps;

  var slice = window.__DTC_FILTERED__.slice(start, start+ps);

  var $tb = $('#dtcTable tbody');
  if(!$tb.length) return;

  var out = '';
  for(var i=0;i<slice.length;i++){
    var r = slice[i];
    out += '<tr '+((selItems && selItems.has && selItems.has(r.key))?'class="row-off"':'')+' data-rows="'+r.rowsAttr+'" data-key="'+r.key+'" data-code="'+r.dtcRaw+'" data-fmi="'+r.fmiShow+'" data-desc="'+r.descShow+'">';
    for(var c=0;c<r.cells.length;c++){
      out += '<td>'+r.cells[c]+'</td>';
    }
    out += '</tr>';
  }
  if(!out){
    out = '<tr><td colspan="8" class="text-center text-secondary py-4"'+__ecui18n('no_records','No records found')+'</td></tr>';
  }
  $tb.html(out);

  __dtc_render_pager();
}

$(document).on('click', '#dtcPager .paginate_button', function(){
  if($(this).hasClass('disabled') || $(this).hasClass('ellipsis')) return;
  var page = parseInt($(this).attr('data-page') || '1', 10);
  if(!isNaN(page)){
    window.__DTC_PAGE__ = page;
    __dtc_render_table();
  }
});

function renderSelected(){
  var items=Array.from(selItems.values());
  if(items.length===0){
    $('#selectedEmpty').removeClass('d-none');
    $('#selectedList').addClass('d-none').empty();
    $('#saveBtn').prop('disabled', true);
    return;
  }
  $('#selectedEmpty').addClass('d-none');
  $('#selectedList').removeClass('d-none').empty();
  items.sort((a,b)=>{
    var at=isNumericCode(a.code), bt=isNumericCode(b.code);
    if(at!==bt) return at ? -1 : 1;
    var an=dtcNumForSort(a.code), bn=dtcNumForSort(b.code);
    if(an!==bn) return an-bn;
    return fmtDtc(a.code).localeCompare(fmtDtc(b.code));
  });
  items.forEach(it=>{
    var codeShow=isNumericCode(it.code)?it.code:fmtDtc(it.code);
    var fmiShow=(it.fmi!=='' && it.fmi!=null)?`FMI: ${it.fmi}`:'';
    $('#selectedList').append(`
      <div class="d-flex align-items-start justify-content-between gap-2 py-1 border-bottom" style="border-color:#222!important">
        <div>
          <div class="dtc-off">${codeShow} <span class="text-secondary" style="font-size:12px">${fmiShow}</span> <span class="badge bg-info text-dark ms-2">Adet: ${it.count}</span></div>
          <div class="text-secondary" style="font-size:12px">${it.desc||''}</div>
        </div>
        <button class="btn btn-sm btn-outline-secondary" onclick="unselectGroup('${it.key.replace(/'/g,"\\'")}')">ON</button>
      </div>`);
  });
  $('#saveBtn').prop('disabled', false);
}

function unselectGroup(key){
  var it=selItems.get(key);
  if(!it) return;
  String(it.rowsAttr||'').split(',').filter(x=>x!=='').forEach(x=>{var n=parseInt(x,10); if(Number.isFinite(n)) sel.delete(n);});
  selItems.delete(key);
  var $tr=$(`#dtcTable tbody tr[data-key="${CSS.escape(key)}"]`);
  if($tr.length){
    $tr.removeClass('row-off');
    $tr.find('.dtc-code').removeClass('dtc-off').addClass('dtc-on');
    var $grp=$tr.find('.btn-group');
    $grp.find('button').removeClass('active');
    $grp.find('button.btn-outline-success').addClass('active');
  }
  renderSelected();
}

function setOnOff(el, isOn, silent){
  var $btn=$(el);
  var $tr=$btn.closest('tr');
  var $grp=$btn.closest('.btn-group');
  var rowsAttr=String($tr.attr('data-rows')||'');
  var key=String($tr.attr('data-key')||'');
  var code=String($tr.attr('data-code')||'');
  var fmi=String($tr.attr('data-fmi')||'');
  var desc=String($tr.attr('data-desc')||'');
  var rows=rowsAttr.split(',').filter(x=>x!=='').map(x=>parseInt(x,10)).filter(n=>Number.isFinite(n));

  $grp.find('button').removeClass('active');
  if(isOn){
    $grp.find('button.btn-outline-success').addClass('active');
    rows.forEach(r=>sel.delete(r));
    selItems.delete(key);
    $tr.removeClass('row-off');
    $tr.find('.dtc-code').removeClass('dtc-off').addClass('dtc-on');
  } else {
    $grp.find('button.btn-outline-danger').addClass('active');
    rows.forEach(r=>sel.add(r));
    selItems.set(key,{key:key,code:code,fmi:fmi,desc:desc,count:rows.length,rowsAttr:rowsAttr});
    $tr.addClass('row-off');
    $tr.find('.dtc-code').removeClass('dtc-on').addClass('dtc-off');
  }
  if(!silent) renderSelected();
}


// ============================
// AUTO DTC (admin-defined keywords + codes)
// ============================
window.__AUTO_DTC_RULES__ = null;
function __auto_fetch_rules(cb){
  if(window.__AUTO_DTC_RULES__){ cb(window.__AUTO_DTC_RULES__); return; }
  $.post('api.php',{action:'get_auto_dtc_rules'}, function(r){
    if(r && r.status==='ok' && r.rules){ window.__AUTO_DTC_RULES__ = r.rules; }
    cb(window.__AUTO_DTC_RULES__ || {});
  });
}
function __auto_norm_arr(a){
  if(!a) return [];
  if(Array.isArray(a)) return a.map(x=>String(x||'')).filter(x=>x.trim()!=='');
  return [String(a)];
}
function autoDtcApply(cat){
  if(!token){ Swal.fire('Uyari','Once binary yukleyin!','warning'); return; }
  cat = String(cat||'').toUpperCase();
  __auto_fetch_rules(function(rules){
    var rule = (rules && rules[cat]) ? rules[cat] : null;
    if(!rule){ Swal.fire('Uyari','Kural bulunamadı: '+cat,'warning'); return; }
    var kws = __auto_norm_arr(rule.keywords);
    var cds = __auto_norm_arr(rule.codes).map(x=>String(x).toUpperCase());
    var hit = 0;

    // iterate all groups in memory (full list)
    (window.__DTC_ALL__||[]).forEach(function(it){
      var codeRaw = String(it.dtcRaw||'').toUpperCase();
      var desc = String(it.descShow||'');
      var ok = false;

      // code match (exact or startsWith)
      if(cds.length){
        for(var i=0;i<cds.length;i++){
          var c=cds[i];
          if(!c) continue;
          if(codeRaw===c || codeRaw.indexOf(c)===0){ ok=true; break; }
        }
      }
      // keyword match in description
      if(!ok && kws.length){
        var dlow = String(desc||'').toLowerCase();
        for(var j=0;j<kws.length;j++){
          var k=String(kws[j]||'').toLowerCase().trim();
          if(!k) continue;
          if(dlow.indexOf(k)>=0){ ok=true; break; }
        }
      }

      if(ok){
        // set OFF selection directly (no DOM needed)
        var rows = String(it.rowsAttr||'').split(',').filter(x=>x!=='').map(x=>parseInt(x,10)).filter(n=>Number.isFinite(n));
        rows.forEach(function(r){ sel.add(r); });
        selItems.set(it.key, {key:it.key, code:String(it.dtcRaw||''), fmi:String(it.fmiShow||''), desc:String(it.descShow||''), count:rows.length, rowsAttr:it.rowsAttr});
        hit++;
      }
    });

    __dtc_render_table();
    renderSelected();
    Swal.fire({toast:true,position:'top-end',timer:2200,showConfirmButton:false,icon:'success',title:cat+' AUTO: '+hit+' grup seçildi'});
  });
}
function autoDtcClear(){
  sel = new Set();
  selItems = new Map();
  __dtc_render_table();
  renderSelected();
}

function saveSelected(){
  if(!token){ Swal.fire('Uyari','Once binary yukleyin!','warning'); return; }
  if(sel.size===0){ Swal.fire('Uyari','Hicbir kod OFF secilmedi!','warning'); return; }
  $.post('api.php',{action:'user_patch',token:token,rows:Array.from(sel)},r=>{
    if(r.status!=='ok'){ Swal.fire('Hata', r.msg||'Patch error', 'error'); return; }
    $('#dlLink').attr('href', r.url);
    $('#confirmList').empty();
    var items=Array.from(selItems.values());
    items.sort((a,b)=>{
      var an=isNumericCode(a.code), bn=isNumericCode(b.code);
      if(an!==bn) return an? -1:1;
      if(an && bn) return (parseInt(a.code,10)||0)-(parseInt(b.code,10)||0);
      return fmtDtc(a.code).localeCompare(fmtDtc(b.code));
    });
    items.forEach(it=>{
      var codeShow=isNumericCode(it.code)?it.code:fmtDtc(it.code);
      var fmiShow=(it.fmi!=='' && it.fmi!=null)?`FMI: ${it.fmi}`:'';
      $('#confirmList').append(`
        <div class="confirm-item">
          <i class="fas fa-check-circle tick"></i>
          <div>
            <div class="fw-bold">${codeShow} <span class="text-secondary" style="font-size:12px">${fmiShow}</span> <span class="badge bg-info text-dark ms-2">Adet: ${it.count}</span></div>
            <div class="text-secondary" style="font-size:12px">${it.desc||''}</div>
          </div>
        </div>`);
    });
    $('#confirmOverlay').css('display','flex');
    var s=10; $('#countdown').text(s);
    var timer=setInterval(()=>{
      s-=1; $('#countdown').text(s);
      if(s<=0){ clearInterval(timer); resetToNewUpload(); }
    },1000);
  });
}

function resetToNewUpload(){
  $('#confirmOverlay').hide();
  $('#scanOverlay').hide();
  token=null; sel=new Set(); selItems=new Map(); renderSelected();
  $('#profileVal').text('-');
  $('#flowStrip').addClass('d-none');
  // reset premium header
  $('#ecuLogoWrap').html('<i class="fas fa-car-side text-secondary" style="font-size:26px"></i>');
  $('#ecuBrandText').text('-');
  // model/ecU chips
$('#flowOemCount').text('');
  $('#flowObd2Count').text('');
  $('#ecuStatusText').text(__ecui18n('binary_waiting','Binary bekleniyor'));
  $('#fileIn').val('');
  var t=t.clear().draw();
  }

// Dropbox fix: whole drop box clickable
$('#dropZone').on('click',()=>$('#fileIn').trigger('click'));

function __upload_xhr(fd, cb){
  try{
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'api.php', true);
    xhr.onreadystatechange = function(){
      if(xhr.readyState === 4){
        var resp = null;
        try{ resp = JSON.parse(xhr.responseText || '{}'); }catch(e){ resp = {status:'error', msg:'JSON parse error'}; }
        cb(resp);
      }
    };
    xhr.send(fd);
  }catch(e){
    cb({status:'error', msg:'XHR error'});
  }
}

$(function(){
  ensureTable();
  renderSelected();
  // Custom search (inside DTC Menüsü block)
  $('#dtcSearch').attr('placeholder', __ecui18n('search_ph','Search DTC...'));
  $('#dtcSearch').on('input', function(){ window.__DTC_PAGE__ = 1; __dtc_render_table(); });
  // ecui18n_placeholder_set
});

// CTRL+A -> select all (OFF) for currently filtered rows
$(document).on('keydown', function(e){
  if(!(e.ctrlKey||e.metaKey)) return;
  var k=(e.key||'').toLowerCase();
  if(k!=='a') return;
  // only when focus is inside DTC menu area
  var a=document.activeElement;
  var inDtc = (a && (a.id==='dtcSearch' || $(a).closest('.table-wrap').length));
  if(!inDtc) return;
  e.preventDefault();
 var nodes = t.rows({search:'applied'}).nodes();
  // bulk OFF (select)
  $(nodes).each(function(){
    var $tr=$(this);
    var offBtn=$tr.find('button.btn-outline-danger');
    if(offBtn.length) setOnOff(offBtn.get(0), false, true);
  });
  renderSelected();
});

$('#fileIn').on('change', function(){
  var f=this.files[0];
  if(!f) return;

  // new upload resets selection
  token=null; sel=new Set(); selItems=new Map(); renderSelected();
  $('#profileVal').text('-');
  $('#flowStrip').addClass('d-none');
$('#flowOemCount').text('');
  $('#flowObd2Count').text('');
  $('#ecuStatusText').text(__ecui18n('scanning','Taranıyor...'));

  matrixStart();
  $('.progress').removeClass('d-none');
  $('.progress-bar').width('0%');

  var fd=new FormData();
  fd.append('user_bin', f, f.name);
  fd.append('action','user_upload');

  $.ajax({
    xhr:function(){
      var x=new window.XMLHttpRequest();
      x.upload.addEventListener('progress', e=>{ if(e.lengthComputable) $('.progress-bar').width((e.loaded/e.total)*100+'%'); });
      return x;
    },
    url:'api.php', type:'POST', data:fd, processData:false, contentType:false,
    success:r=>{
      matrixStop();
      $('.progress').addClass('d-none');
      if(r.status!=='ok'){ Swal.fire('Hata', r.msg||'Upload error','error'); return; }
      token=r.token;
      $('#profileVal').text((r.profile_name||'-'));

      try{ refreshUserStatus({quota_remain:r.quota_remain, quota_limit:r.quota_limit}); }catch(e){}


// v19 upload popup (auto-close, BRAND/ECU/GROUP + status message)
try{
  var meta = r.meta || {};
  var brand = (meta.brand || meta.make || meta.vehicle_brand || r.brand || '-') || '-';
  var ecuName = (meta.ecu || meta.ECU || r.ecu || '-') || '-';
  var grpName = (meta.brand_group || meta.group || r.brand_group || '-') || '-';
  var logoUrl = (meta.brand_logo || meta.logo || r.brand_logo || '') || '';
  var oemCount = (r.oem_count!=null ? r.oem_count : (r.oemCount!=null ? r.oemCount : 0));
  var obd2Count = (r.obd2_count!=null ? r.obd2_count : (r.obd2Count!=null ? r.obd2Count : 0));
  var dtcTotal = (r.data||[]).length;

  Swal.fire({
    icon: null,
    title: '',
    html: `
      <div class="ecu-upload-grid ecu-upload-grid-compact">
        <div class="ecu-u-card ecu-u-card-center">
          <div class="ecu-u-left ecu-u-left-center">
            <div class="ecu-u-ico brand" style="overflow:hidden;">
              ${logoUrl ? `<img src="${logoUrl}" alt="logo" style="width:100%;height:100%;object-fit:contain;">` : `<i class="fas fa-tag"></i>`}
            </div>
            <div>
              <div class="ecu-u-k">${__ecui18n('brand_lbl','MARKA')}</div>
              <div class="ecu-u-v" style="text-align:center;">${brand}</div>
            </div>
          </div>
        </div>
        <div class="ecu-u-card ecu-u-card-center">
          <div class="ecu-u-left ecu-u-left-center">
            <div class="ecu-u-ico ecu"><i class="fas fa-microchip"></i></div>
            <div>
              <div class="ecu-u-k">${__ecui18n('ecu_lbl','ECU')}</div>
              <div class="ecu-u-v" style="text-align:center;">${ecuName}</div>
            </div>
          </div>
        </div>
        <div class="ecu-u-card ecu-u-card-center" style="grid-column: 1 / -1;">
          <div class="ecu-u-left ecu-u-left-center">
            <div class="ecu-u-ico" style="background:rgba(120,190,255,.10);border-color:rgba(120,190,255,.22)"><i class="fas fa-layer-group"></i></div>
            <div>
              <div class="ecu-u-k">${__ecui18n('group_lbl','GRUP')}</div>
              <div class="ecu-u-v" style="text-align:center;">${grpName}</div>
            </div>
          </div>
        </div>
        <div class="ecu-u-card" style="grid-column: 1 / -1;">
          <div class="ecu-u-left">
            <div class="ecu-u-ico" style="background:rgba(0,255,170,.12);border-color:rgba(0,255,170,.22)"><i class="fas fa-hourglass-half"></i></div>
            <div>
              <div class="ecu-u-k">${__ecui18n('status_lbl','DURUM')}</div>
              <div class="ecu-u-v" style="text-align:left;max-width:520px;">${__ecui18n('wait_listing','DOSYANIZ TANIMLANDI. DTC LİSTELENİYOR. LÜTFEN BEKLEYİNİZ.')}</div>
            </div>
          </div>
        </div>
      </div>
    `,
    timer: 5000,
    timerProgressBar: true,
    showConfirmButton: false,
    customClass: {
      popup: 'ecu-swal-popup',
      title: 'ecu-swal-title',
      htmlContainer: 'ecu-swal-html'
    }
  });
}catch(e){}
// grouping + OEM first
      var groups=new Map();
      (r.data||[]).forEach(d=>{
        var k=String(d.DTC||'')+'|'+String(d.FMI||'');
        if(!groups.has(k)) groups.set(k,{DTC:d.DTC,FMI:(d.FMI??''),DESC:(d.DESC||''),HEX:(d.HEX||''),GROUP:(d.GROUP||''),rows:[]});
        groups.get(k).rows.push(parseInt(d.ROW,10));
      });
      var rows=Array.from(groups.values());
      rows.sort((a,b)=>{
        var at=isNumericCode(a.DTC), bt=isNumericCode(b.DTC);
        // OEM once (numeric), then OBD2
        if(at!==bt) return at ? -1 : 1;
        // numeric sort for both groups
        var an=dtcNumForSort(a.DTC), bn=dtcNumForSort(b.DTC);
        if(an!==bn) return an-bn;
        return fmtDtc(a.DTC).localeCompare(fmtDtc(b.DTC));
      });

      // unique DTC counts by type (grouped)
      var oemCount = rows.filter(x=>isNumericCode(x.DTC)).length;
      var obd2Count = rows.length - oemCount;

      function _safeCell(v){
  if(v===null || v===undefined) return '';
  return String(v);
}
function onUserUploadOK(r){
  rows = r.data || [];
  try{
    if(typeof groupRows === 'function'){
      rows = groupRows(rows);
    }
  }catch(e){}
  try{ fillTable(); }catch(e){}
}

function fillTable(){
  window.__DTC_ALL__ = [];
  window.__DTC_FILTERED__ = [];
  window.__DTC_PAGE__ = 1;

  var list = rows || [];
  for(var i=0;i<list.length;i++){
    var g = list[i];
    var dtcRaw = String((g.DTC||'')).replace(/^\s+|\s+$/g,'');
    var dtcShow = isNumericCode(dtcRaw) ? dtcRaw : fmtDtc(dtcRaw);
    var fmiShow = (g.FMI!=='' && g.FMI!=null) ? String(g.FMI) : '';
    var descShow = (fmiShow!=='') ? stripFmi(g.DESC) : (g.DESC||'');
    var hexShow = (g.HEX||'-') + (g.GROUP ? ' <span class="badge bg-secondary">Grp</span>' : '');
    var rowsAttr = (g.rows||[]).join(',');
    var key = String(dtcRaw)+'|'+String(fmiShow)+'|'+String(rowsAttr);

    var statusCell = '<input type="checkbox" class="form-check-input" checked disabled>';
    var isOff = (selItems && selItems.has && selItems.has(key));
    var btns = ''
      + '<div class="btn-group btn-group-sm" role="group" data-rows="'+rowsAttr+'" data-key="'+key+'">' 
      + '  <button type="button" class="btn btn-outline-success '+(isOff?'':'active')+' dtc-toggle" data-state="ON" onclick="setOnOff(this,true)">' + 'ON' + '</button>'
      + '  <button type="button" class="btn btn-outline-danger '+(isOff?'active':'')+' dtc-toggle" data-state="OFF" onclick="setOnOff(this,false)">' + 'OFF' + '</button>'
      + '</div>';


    var type = dtcType(dtcRaw);
    var typeBadge = (type==='OEM')
      ? '<span class="badge bg-warning text-dark">OEM</span>'
      : '<span class="badge bg-primary">OBD2</span>';

    var cells = [
      statusCell,
      typeBadge,
      '<span class="dtc-code '+(isOff?'dtc-off':'dtc-on')+'">'+dtcShow+'</span>',
      '<span class="text-secondary">'+fmiShow+'</span>',
      '<span>'+descShow+'</span>',
      '<span class="text-secondary">'+hexShow+'</span>',
      '<span class="badge bg-info text-dark">Adet: '+((g.rows||[]).length)+'</span>',
      btns
    ];
    while(cells.length<8) cells.push('');
    if(cells.length>8) cells.length = 8;

    window.__DTC_ALL__.push({
      cells: cells,
      rowsAttr: rowsAttr,
      key: key,
      dtcRaw: dtcRaw,
      fmiShow: fmiShow,
      descShow: descShow,
      _search: String(dtcShow)+' '+String(dtcRaw)+' '+String(fmiShow)+' '+String(descShow)+' '+String(hexShow)
    });
  }

  __dtc_render_table();
  renderSelected();
}

      // 5 saniyelik popup (listeyi acmadan once)
      showProfilePopup({
        brand:r.brand,
        ecu_model:r.ecu_model,
        brand_group:r.brand_group,
        brand_logo:r.brand_logo,
        profile_name:r.profile_name,
        oem_count:oemCount,
        obd2_count:obd2Count,
        model:r.vehicle_model||r.model
      }, fillTable);
    }
  });
});
</script>
</script>
<script>
function ecxFixPagerIcons(){
  try{
    var $w = $('.dataTables_wrapper');
    $w.find('.dataTables_paginate a.paginate_button.first').html('«');
    $w.find('.dataTables_paginate a.paginate_button.previous').html('‹');
    $w.find('.dataTables_paginate a.paginate_button.next').html('›');
    $w.find('.dataTables_paginate a.paginate_button.last').html('»');
  }catch(e){}
}
</script>
<script>
function ecxFixPagerIcons(){
  try{
    var root = document.querySelector('.dataTables_paginate');
    if(!root) return;
    var first = root.querySelector('a.first'); if(first) first.innerHTML = '«';
    var prev  = root.querySelector('a.previous'); if(prev) prev.innerHTML = '‹';
    var next  = root.querySelector('a.next'); if(next) next.innerHTML = '›';
    var last  = root.querySelector('a.last'); if(last) last.innerHTML = '»';
  }catch(e){}
}

(function(){
  function boot(){
    ecxFixPagerIcons();
    try{
      var root = document.querySelector('.dataTables_paginate');
      if(!root) return;
      if(window.__ecxPagerObs) return;
      window.__ecxPagerObs = new MutationObserver(function(){ ecxFixPagerIcons(); });
      window.__ecxPagerObs.observe(root, {childList:true, subtree:true, characterData:true});
      // also re-apply on clicks
      root.addEventListener('click', function(){ setTimeout(ecxFixPagerIcons, 0); }, true);
    }catch(e){}
  }
  if(document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', boot);
  }else{
    boot();
  }
  // fallback: try for a short while in case pager appears late
  var tries = 0;
  var t = setInterval(function(){
    tries++;
    boot();
    if(document.querySelector('.dataTables_paginate') || tries>40) clearInterval(t);
  }, 250);
})();
</script>
<script>
(function(){
  function ecxPagerBeautify(){
    try{
      var $p = $('.dataTables_wrapper .dataTables_paginate');
      $p.find('a.paginate_button.previous').html('‹');
      $p.find('a.paginate_button.next').html('›');
      $p.find('a.paginate_button.first').html('«');
      $p.find('a.paginate_button.last').html('»');
    }catch(e){}
  }

  document.addEventListener('DOMContentLoaded', function(){
    ecxPagerBeautify();
    try{
      var target = document.querySelector('.dataTables_wrapper .dataTables_paginate');
      if(target){
        var obs = new MutationObserver(function(){ ecxPagerBeautify(); });
        obs.observe(target, {childList:true, subtree:true});
      }
    }catch(e){}
  });
})();
</script>
<script>
(function(){
  function fix(){
    try{
      var p = document.getElementById('dtcTable_paginate');
      if(!p) return false;

      // Handle <a> or <span> buttons
      var prev = p.querySelector('.paginate_button.previous');
      var next = p.querySelector('.paginate_button.next');
      if(prev) prev.textContent = '‹';
      if(next) next.textContent = '›';

      var first = p.querySelector('.paginate_button.first');
      var last  = p.querySelector('.paginate_button.last');
      if(first) first.textContent = '«';
      if(last)  last.textContent  = '»';

      return true;
    }catch(e){ return false; }
  }

  function boot(){
    // aggressive re-apply for 6 seconds (DT redraws)
    var t0 = Date.now();
    var iv = setInterval(function(){
      fix();
      if(Date.now() - t0 > 6000) clearInterval(iv);
    }, 150);

    try{
      var p = document.getElementById('dtcTable_paginate');
      if(p){
        var obs = new MutationObserver(function(){ fix(); });
        obs.observe(p, {childList:true, subtree:true});
      }
    }catch(e){}
  }

  if(document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', boot);
  }else{
    boot();
  }
})();
</script>
<script>
/* v16: CTRL+A selects all visible DTC rows */
(function(){
  function isTypingTarget(el){
    if(!el) return false;
    var t = (el.tagName||'').toLowerCase();
    return t === 'input' || t === 'textarea' || el.isContentEditable;
  }
  document.addEventListener('keydown', function(e){
    if(!(e.ctrlKey || e.metaKey)) return;
    if(((e.key||'').toLowerCase()) !== 'a') return;
    if(isTypingTarget(document.activeElement)) return;
    e.preventDefault();
    try{
      var $cbs = $('#dtcTable').find('tbody input[type="checkbox"]:not(:disabled)');
      $cbs.each(function(){
        if(!this.checked){ $(this).prop('checked', true).trigger('change'); }
      });
    }catch(err){}
  }, true);
})();
</script>
<script>
/* v22: build 4-block square overlay without touching DTC flow */
(function(){
  function qs(sel){ return document.querySelector(sel); }
  function getNumFromText(t){
    var m = String(t||'').match(/(\d+)/);
    return m ? m[1] : '0';
  }
  function parseEcuFromModelText(t){
    t = String(t||'');
    var m = t.match(/ECU\s*:\s*([^\n]+)/i);
    if(m) return m[1].trim();
    // fallback: after bullet
    m = t.match(/•\s*ECU\s*:\s*([^\n]+)/i);
    if(m) return m[1].trim();
    return t.replace(/^.*ECU\s*/i,'').trim() || '-';
  }
  function ensureSquare(){
    var stage = qs('#scanOverlay .scan-stage');
    if(!stage) return null;
    var existing = stage.querySelector('.scan-square-v22');
    if(existing) return existing;
    var wrap = document.createElement('div');
    wrap.className = 'scan-square-v22';
    wrap.innerHTML = `
      <div class="scan-grid-v22">
        <div class="scan-box-v22 scan-brand-v22">
          <div class="scan-k-v22"><span class="ico">B</span> MARKA</div>
          <div class="scan-v-v22" id="scanBrandValV22"><span class="brand-logo-slot" id="scanBrandLogoV22"></span><span id="scanBrandTextV22">-</span></div>
        </div>
        <div class="scan-box-v22 scan-ecu-v22">
          <div class="scan-k-v22"><span class="ico">ECU</span> ECU</div>
          <div class="scan-v-v22" id="scanEcuValV22"><span class="ecu-ico-v22">ECU</span><span id="scanEcuTextV22">-</span></div>
        </div>

        <div class="scan-box-v22 scan-wait-v22" style="grid-column: 1 / 3;">
          <div class="scan-k-v22"><span class="ico">⏳</span> DURUM</div>
          <div class="scan-v-v22" id="scanWaitMsgV22" data-i18n="scan_wait_msg">DOSYANIZ TANIMLANDI. DTC LİSTELENİYOR. LÜTFEN BEKLEYİNİZ.</div>
        </div>
      </div>
    `;
    stage.appendChild(wrap);
    return wrap;
  }
  function updateVals(){
    var brand = (qs('#scanBrandText') && qs('#scanBrandText').textContent.trim()) || '-';
    var modelText = (qs('#scanModelText') && qs('#scanModelText').textContent) || '';
    var ecu = parseEcuFromModelText(modelText) || '-';
    var oem = getNumFromText((qs('#scanOemCount') && qs('#scanOemCount').textContent) || '0');
    var obd2 = getNumFromText((qs('#scanObd2Count') && qs('#scanObd2Count').textContent) || '0');
    // BRAND (with logo)
    var bt = qs('#scanBrandTextV22'); if(bt) bt.textContent = brand;
    var bl = qs('#scanBrandLogoV22');
    if(bl){
      var img = qs('#scanLogoWrap img');
      if(img && img.getAttribute('src')){
        bl.innerHTML = '<img class="brand-logo-img-v22" src="'+img.getAttribute('src')+'" alt="logo">';
      }else{
        bl.innerHTML = '';
      }
    }

    // ECU (with icon)
    var et = qs('#scanEcuTextV22'); if(et) et.textContent = ecu;
  }
  function onOverlayShown(){
    ensureSquare();
    updateVals();
    // update a few times while counts settle
    var n=0;
    var it=setInterval(function(){
      updateVals();
      n++;
      if(n>=12) clearInterval(it);
    }, 120);
  }

  document.addEventListener('DOMContentLoaded', function(){
    var ov = qs('#scanOverlay');
    if(!ov) return;
    var mo = new MutationObserver(function(){
      var disp = getComputedStyle(ov).display;
      if(disp !== 'none') onOverlayShown();
    });
    mo.observe(ov, { attributes:true, attributeFilter:['style','class'] });
  });
})();
</script>
<script>
/* ===== v27 i18n ===== */
(function(){
  function qs(sel){ return document.querySelector(sel); }
  function qsa(sel){ return Array.prototype.slice.call(document.querySelectorAll(sel)); }

  var I18N = {
    tr: { name:"🇹🇷 Türkçe", lang:"Dil", logout:"Çıkış", saved_title:"Kaydedildi", search:"Ara", search_ph:"DTC ara...", processing:"İşleniyor...", no_records:"Kayıt bulunamadı",
          upload:"Binary Yükle", selected_dtcs:"Seçilen DTC'ler", dtc_menu:"DTC Menüsü", profile:"Profil", save:"Kaydet",
          drop_here:"Dosyayı Sürükle veya Tıkla", dtc_fills_on_upload:"DTC menüsü binary yüklendiğinde dolar.",
          no_selection:"Henüz seçim yok.", off_included:"OFF seçilen her satır/grup patch'e girer.",
          upload_first:"Binary yükleyin...", binary_waiting:"Binary bekleniyor", scanning:"Taranıyor...",
          profile_detected:"ECU Profil Tespit Edildi", profile_before_dtc:"DTC menüsü açılmadan önce profil bilgisi gösteriliyor (5s)",
          selected_processed:"Seçilen DTC'ler işlendi.", new_binary_in:"Yeni binary için", scan_done:"Tarama tamamlandı", scan_wait_msg:"DOSYANIZ TANIMLANDI. DTC LİSTELENİYOR. LÜTFEN BEKLEYİNİZ.",
          brand_lbl:"MARKA", ecu_lbl:"ECU", group_lbl:"GRUP", status_lbl:"DURUM", wait_listing:"DOSYANIZ TANIMLANDI. DTC LİSTELENİYOR. LÜTFEN BEKLEYİNİZ.",
          download:"İndir", confirmed_dtc_list:"Onaylanan DTC Listesi",
          th_status:"STATUS", th_type:"TİP", th_code:"KOD", th_fmi:"FMI", th_desc:"Açıklama", th_hex:"HEX", th_count:"Adet", th_state:"DURUM",
          model:"Model", group:"GRUP" ,
          info:"_TOTAL_ kayıttan _START_ - _END_ arası gösteriliyor", info_empty:"0 kayıttan 0 - 0 arası gösteriliyor",
          info_filtered:"(_MAX_ kayıt içinden filtrelendi)", length_menu:"Sayfada _MENU_ kayıt göster", paginate_prev:"Önceki", paginate_next:"Sonraki" },
    en: { name:"🇬🇧 English", lang:"Language", logout:"Logout", saved_title:"Saved", search:"Search", search_ph:"Search DTC...", processing:"Processing...", no_records:"No records found",
          upload:"Upload Binary", selected_dtcs:"Selected DTCs", dtc_menu:"DTC Menu", profile:"Profile", save:"Save",
          drop_here:"Drag & Drop or Click", dtc_fills_on_upload:"The DTC menu will populate after uploading a binary.",
          no_selection:"No selection yet.", off_included:"OFF: every selected row/group will be patched.",
          upload_first:"Upload a binary...", binary_waiting:"Waiting for binary", scanning:"Scanning...",
          profile_detected:"ECU Profile Detected", profile_before_dtc:"Profile info is shown before the DTC menu (5s)",
          selected_processed:"Selected DTCs processed.", new_binary_in:"New binary in", scan_done:"Scan complete", scan_wait_msg:"YOUR FILE IS IDENTIFIED. LISTING DTCs. PLEASE WAIT.",
          brand_lbl:"BRAND", ecu_lbl:"ECU", group_lbl:"GROUP", status_lbl:"STATUS", wait_listing:"YOUR FILE IS IDENTIFIED. LISTING DTCs. PLEASE WAIT.",
          download:"Download", confirmed_dtc_list:"Confirmed DTC List",
          th_status:"STATUS", th_type:"TYPE", th_code:"CODE", th_fmi:"FMI", th_desc:"Description", th_hex:"HEX", th_count:"Count", th_state:"STATE",
          model:"Model", group:"GROUP",
          info:"Showing _START_ to _END_ of _TOTAL_ entries", info_empty:"Showing 0 to 0 of 0 entries",
          info_filtered:"(filtered from _MAX_ total entries)", length_menu:"Show _MENU_ entries", paginate_prev:"Previous", paginate_next:"Next" },
    es: { name:"🇪🇸 Español", lang:"Idioma", logout:"Salir", saved_title:"Guardado", search:"Buscar", search_ph:"Buscar DTC...", processing:"Procesando...", no_records:"No se encontraron registros",
          upload:"Subir binario", selected_dtcs:"DTC seleccionados", dtc_menu:"Menú DTC", profile:"Perfil", save:"Guardar",
          drop_here:"Arrastrar o hacer clic", dtc_fills_on_upload:"El menú DTC se completará tras subir un binario.",
          no_selection:"Aún no hay selección.", off_included:"OFF: cada fila/grupo seleccionado se aplicará.",
          upload_first:"Suba un binario...", binary_waiting:"Esperando binario", scanning:"Escaneando...",
          profile_detected:"Perfil ECU detectado", profile_before_dtc:"Se muestra el perfil antes del menú DTC (5s)",
          selected_processed:"DTC seleccionados procesados.", new_binary_in:"Nuevo binario en", scan_done:"Escaneo completo", scan_wait_msg:"ARCHIVO IDENTIFICADO. LISTANDO DTC. POR FAVOR ESPERE.",
          brand_lbl:"MARCA", ecu_lbl:"ECU", group_lbl:"GRUPO", status_lbl:"ESTADO", wait_listing:"ARCHIVO IDENTIFICADO. LISTANDO DTC. POR FAVOR ESPERE.",
          download:"Descargar", confirmed_dtc_list:"Lista de DTC confirmados",
          th_status:"ESTADO", th_type:"TIPO", th_code:"CÓDIGO", th_fmi:"FMI", th_desc:"Descripción", th_hex:"HEX", th_count:"Cantidad", th_state:"ESTADO",
          model:"Modelo", group:"GRUPO",
          info:"Mostrando _START_ a _END_ de _TOTAL_ entradas", info_empty:"Mostrando 0 a 0 de 0 entradas",
          info_filtered:"(filtrado de _MAX_ entradas totales)", length_menu:"Mostrar _MENU_ entradas", paginate_prev:"Anterior", paginate_next:"Siguiente" },
    fr: { name:"🇫🇷 Français", lang:"Langue", logout:"Déconnexion", saved_title:"Enregistré", search:"Rechercher", search_ph:"Rechercher un DTC...", processing:"Traitement...", no_records:"Aucun résultat",
          upload:"Téléverser binaire", selected_dtcs:"DTC sélectionnés", dtc_menu:"Menu DTC", profile:"Profil", save:"Enregistrer",
          drop_here:"Glisser-déposer ou cliquer", dtc_fills_on_upload:"Le menu DTC se remplira après le téléversement.",
          no_selection:"Aucune sélection pour le moment.", off_included:"OFF : chaque ligne/groupe sélectionné sera patché.",
          upload_first:"Téléversez un binaire...", binary_waiting:"En attente du binaire", scanning:"Analyse en cours...",
          profile_detected:"Profil ECU détecté", profile_before_dtc:"Le profil est affiché avant le menu DTC (5s)",
          selected_processed:"DTC sélectionnés traités.", new_binary_in:"Nouveau binaire dans", scan_done:"Analyse terminée", scan_wait_msg:"FICHIER IDENTIFIÉ. LISTE DES DTC EN COURS. VEUILLEZ PATIENTER.",
          brand_lbl:"MARQUE", ecu_lbl:"ECU", group_lbl:"GROUPE", status_lbl:"STATUT", wait_listing:"FICHIER IDENTIFIÉ. LISTE DES DTC EN COURS. VEUILLEZ PATIENTER.",
          download:"Télécharger", confirmed_dtc_list:"Liste des DTC confirmés",
          th_status:"STATUT", th_type:"TYPE", th_code:"CODE", th_fmi:"FMI", th_desc:"Description", th_hex:"HEX", th_count:"Qté", th_state:"ÉTAT",
          model:"Modèle", group:"GROUPE",
          info:"Affichage de _START_ à _END_ sur _TOTAL_ entrées", info_empty:"Affichage de 0 à 0 sur 0 entrées",
          info_filtered:"(filtré de _MAX_ entrées au total)", length_menu:"Afficher _MENU_ entrées", paginate_prev:"Précédent", paginate_next:"Suivant" },
    de: { name:"🇩🇪 Deutsch", lang:"Sprache", logout:"Abmelden", saved_title:"Gespeichert", search:"Suchen", search_ph:"DTC suchen...", processing:"Wird verarbeitet...", no_records:"Keine Einträge gefunden",
          upload:"Binary hochladen", selected_dtcs:"Ausgewählte DTCs", dtc_menu:"DTC-Menü", profile:"Profil", save:"Speichern",
          drop_here:"Datei ziehen oder klicken", dtc_fills_on_upload:"Das DTC-Menü füllt sich nach dem Upload.",
          no_selection:"Noch keine Auswahl.", off_included:"OFF: jede ausgewählte Zeile/Gruppe wird gepatcht.",
          upload_first:"Binary hochladen...", binary_waiting:"Warte auf Binary", scanning:"Scanne...",
          profile_detected:"ECU-Profil erkannt", profile_before_dtc:"Profil wird vor dem DTC-Menü angezeigt (5s)",
          selected_processed:"Ausgewählte DTCs verarbeitet.", new_binary_in:"Neues Binary in", scan_done:"Scan abgeschlossen", scan_wait_msg:"DATEI ERKANNT. DTCs WERDEN GELISTET. BITTE WARTEN.",
          brand_lbl:"MARKE", ecu_lbl:"ECU", group_lbl:"GRUPPE", status_lbl:"STATUS", wait_listing:"DATEI ERKANNT. DTCs WERDEN GELISTET. BITTE WARTEN.",
          download:"Download", confirmed_dtc_list:"Bestätigte DTC-Liste",
          th_status:"STATUS", th_type:"TYP", th_code:"CODE", th_fmi:"FMI", th_desc:"Beschreibung", th_hex:"HEX", th_count:"Anzahl", th_state:"ZUSTAND",
          model:"Modell", group:"GRUPPE",
          info:"_START_ bis _END_ von _TOTAL_ Einträgen", info_empty:"0 bis 0 von 0 Einträgen",
          info_filtered:"(gefiltert von _MAX_ Einträgen)", length_menu:"_MENU_ Einträge anzeigen", paginate_prev:"Zurück", paginate_next:"Weiter" },
    it: { name:"🇮🇹 Italiano", lang:"Lingua", logout:"Esci", saved_title:"Salvato", search:"Cerca", search_ph:"Cerca DTC...", processing:"Elaborazione...", no_records:"Nessun risultato",
          upload:"Carica binario", selected_dtcs:"DTC selezionati", dtc_menu:"Menu DTC", profile:"Profilo", save:"Salva",
          drop_here:"Trascina o fai clic", dtc_fills_on_upload:"Il menu DTC si popolerà dopo il caricamento.",
          no_selection:"Nessuna selezione.", off_included:"OFF: ogni riga/gruppo selezionato verrà patchato.",
          upload_first:"Carica un binario...", binary_waiting:"In attesa del binario", scanning:"Scansione...",
          profile_detected:"Profilo ECU rilevato", profile_before_dtc:"Il profilo viene mostrato prima del menu DTC (5s)",
          selected_processed:"DTC selezionati elaborati.", new_binary_in:"Nuovo binario tra", scan_done:"Scansione completata", scan_wait_msg:"FILE IDENTIFICATO. ELENCO DTC IN CORSO. ATTENDERE PREGO.",
          brand_lbl:"MARCA", ecu_lbl:"ECU", group_lbl:"GRUPPO", status_lbl:"STATO", wait_listing:"FILE IDENTIFICATO. ELENCO DTC IN CORSO. ATTENDERE PREGO.",
          download:"Scarica", confirmed_dtc_list:"Elenco DTC confermati",
          th_status:"STATUS", th_type:"TIPO", th_code:"CODICE", th_fmi:"FMI", th_desc:"Descrizione", th_hex:"HEX", th_count:"Qtà", th_state:"STATO",
          model:"Modello", group:"GRUPPO",
          info:"Visualizzati da _START_ a _END_ di _TOTAL_ elementi", info_empty:"Visualizzati 0 a 0 di 0 elementi",
          info_filtered:"(filtrato da _MAX_ elementi totali)", length_menu:"Mostra _MENU_ elementi", paginate_prev:"Precedente", paginate_next:"Successivo" },
    pt: { name:"🇵🇹 Português", lang:"Idioma", logout:"Sair", saved_title:"Guardado", search:"Pesquisar", search_ph:"Pesquisar DTC...", processing:"A processar...", no_records:"Nenhum registo encontrado",
          upload:"Carregar binário", selected_dtcs:"DTC selecionados", dtc_menu:"Menu DTC", profile:"Perfil", save:"Guardar",
          drop_here:"Arraste ou clique", dtc_fills_on_upload:"O menu DTC será preenchido após o upload.",
          no_selection:"Sem seleção ainda.", off_included:"OFF: cada linha/grupo selecionado será aplicado.",
          upload_first:"Carregue um binário...", binary_waiting:"A aguardar binário", scanning:"A analisar...",
          profile_detected:"Perfil ECU detetado", profile_before_dtc:"O perfil é mostrado antes do menu DTC (5s)",
          selected_processed:"DTC selecionados processados.", new_binary_in:"Novo binário em", scan_done:"Análise concluída", scan_wait_msg:"ARQUIVO IDENTIFICADO. LISTANDO DTCs. AGUARDE.",
          brand_lbl:"MARCA", ecu_lbl:"ECU", group_lbl:"GRUPO", status_lbl:"STATUS", wait_listing:"ARQUIVO IDENTIFICADO. LISTANDO DTCs. AGUARDE.",
          download:"Transferir", confirmed_dtc_list:"Lista de DTC confirmados",
          th_status:"STATUS", th_type:"TIPO", th_code:"CÓDIGO", th_fmi:"FMI", th_desc:"Descrição", th_hex:"HEX", th_count:"Qtd", th_state:"ESTADO",
          model:"Modelo", group:"GRUPO",
          info:"A mostrar _START_ a _END_ de _TOTAL_ registos", info_empty:"A mostrar 0 a 0 de 0 registos",
          info_filtered:"(filtrado de _MAX_ registos no total)", length_menu:"Mostrar _MENU_ registos", paginate_prev:"Anterior", paginate_next:"Seguinte" },
    ru: { name:"🇷🇺 Русский", lang:"Язык", logout:"Выход", saved_title:"Сохранено", search:"Поиск", search_ph:"Поиск DTC...", processing:"Обработка...", no_records:"Записей не найдено",
          upload:"Загрузить бинарник", selected_dtcs:"Выбранные DTC", dtc_menu:"Меню DTC", profile:"Профиль", save:"Сохранить",
          drop_here:"Перетащите или нажмите", dtc_fills_on_upload:"Меню DTC заполнится после загрузки бинарника.",
          no_selection:"Пока ничего не выбрано.", off_included:"OFF: каждая выбранная строка/группа будет пропатчена.",
          upload_first:"Загрузите бинарник...", binary_waiting:"Ожидание бинарника", scanning:"Сканирование...",
          profile_detected:"Профиль ECU обнаружен", profile_before_dtc:"Профиль показывается перед меню DTC (5s)",
          selected_processed:"Выбранные DTC обработаны.", new_binary_in:"Новый бинарник через", scan_done:"Сканирование завершено", scan_wait_msg:"ФАЙЛ ОПРЕДЕЛЕН. ФОРМИРУЕТСЯ СПИСОК DTC. ПОЖАЛУЙСТА, ПОДОЖДИТЕ.",
          brand_lbl:"МАРКА", ecu_lbl:"ECU", group_lbl:"ГРУППА", status_lbl:"СТАТУС", wait_listing:"ФАЙЛ ОПРЕДЕЛЕН. ФОРМИРУЕТСЯ СПИСОК DTC. ПОЖАЛУЙСТА, ПОДОЖДИТЕ.",
          download:"Скачать", confirmed_dtc_list:"Подтверждённый список DTC",
          th_status:"СТАТУС", th_type:"ТИП", th_code:"КОД", th_fmi:"FMI", th_desc:"Описание", th_hex:"HEX", th_count:"Кол-во", th_state:"СОСТОЯНИЕ",
          model:"Модель", group:"ГРУППА",
          info:"Показаны записи с _START_ по _END_ из _TOTAL_", info_empty:"Показаны записи с 0 по 0 из 0",
          info_filtered:"(отфильтровано из _MAX_)", length_menu:"Показать _MENU_ записей", paginate_prev:"Назад", paginate_next:"Вперёд" }
  };

  function getLang(){
    var v = null;
    try{ v = localStorage.getItem('ecupratix_lang'); }catch(e){}
    if(v && I18N[v]) return v;
    return 'tr';
  }
  function setLang(v){
    try{ localStorage.setItem('ecupratix_lang', v); }catch(e){}
  }

  function dtLang(lang){
    var t = I18N[lang] || I18N.tr;
    return {
      processing: t.processing,
      search: t.search + ":",
      searchPlaceholder: t.search_ph,
      lengthMenu: t.length_menu,
      info: t.info,
      infoEmpty: t.info_empty,
      infoFiltered: t.info_filtered,
      zeroRecords: t.no_records,
      paginate: { previous: t.paginate_prev, next: t.paginate_next }
    };
  }

  function buildSelector(){
    var sel = qs('#langSelect');
    if(!sel) return;
    var cur = getLang();
    sel.innerHTML = '';
    var keys = ['en','es','fr','de','it','tr','pt','ru'];
    for(var i=0;i<keys.length;i++){
      var k = keys[i];
      var opt = document.createElement('option');
      opt.value = k;
      opt.textContent = I18N[k].name;
      if(k === cur) opt.selected = true;
      sel.appendChild(opt);
    }
    sel.addEventListener('change', function(){
      setLang(this.value);
      window.location.reload();
    });
  }


  function refreshUserStatus(hint){
    $.post('api.php', {action:'user_status'}, function(r){
      if(!r || r.status!=='ok') return;
      // username
      try{ $('#userName').text(r.username || '-'); }catch(e){}
      // license days
      var dl = r.days_left;
      if(dl === null || dl === undefined){
        $('#licenseDays').text('∞');
      } else {
        $('#licenseDays').text(String(dl));
      }
      // quota text (remain/limit or used/limit)
      var limit = r.quota_limit;
      var used = r.quota_used;
      var remain = r.quota_remain;
      if(limit === null || limit === undefined || parseInt(limit,10) <= 0){
        $('#quotaText').text('∞');
      } else {
        // prefer remain/limit
        if(remain !== null && remain !== undefined) $('#quotaText').text(String(remain) + ' / ' + String(limit));
        else $('#quotaText').text(String(Math.max(0, limit - used)) + ' / ' + String(limit));
      }
      if(hint && hint.quota_remain !== undefined && hint.quota_limit !== undefined){
        if(parseInt(hint.quota_limit,10) > 0) $('#quotaText').text(String(hint.quota_remain) + ' / ' + String(hint.quota_limit));
      }
    }, 'json');
  }

  function applyStatic(lang){
    var t = I18N[lang] || I18N.tr;
    qsa('[data-i18n]').forEach(function(el){
      var k = el.getAttribute('data-i18n');
      if(t[k]) el.textContent = t[k];
    });
    qsa('[data-i18n-ph]').forEach(function(el){
      var k = el.getAttribute('data-i18n-ph');
      if(t[k]) el.setAttribute('placeholder', t[k]);
    });
  }

  document.addEventListener('DOMContentLoaded', function(){
    var lang = getLang();
    window.__ECU_I18N__ = I18N;
    window.__ECU_LANG__ = lang;
    try{ document.documentElement.lang = lang; }catch(e){}
    window.__ECU_DT_LANG__ = dtLang(lang);
    buildSelector();
    refreshUserStatus();
    applyStatic(lang);
  });
})();
</script>

<div id="confirmOverlay" class="overlay" style="position:fixed;inset:0;z-index:99999;display:none;align-items:center;justify-content:center;background:rgba(0,0,0,.95);padding:20px;">
  <div class="overlay-card">
    <div class="overlay-h">
      <i class="fas fa-circle-check" style="font-size:26px;color:#20c997"></i>
      <div>
        <div class="h4 m-0" data-i18n="saved_title">Kaydedildi</div>
        <div class="text-secondary" style="font-size:13px">
          <span data-i18n="selected_processed">Seçilen DTC'ler işlendi.</span>
          <span data-i18n="new_binary_in">Yeni binary için</span>
          <span id="countdown">10</span>s
        </div>
      </div>
      <div class="ms-auto d-flex align-items-center gap-2">
        <a href="#" id="dlLink" class="btn btn-primary"><i class="fas fa-download me-2"></i><span data-i18n="download">İndir</span></a>
      </div>
    </div>
    <div class="overlay-b">
      <div class="text-secondary mb-2" data-i18n="confirmed_dtc_list">Onaylanan DTC Listesi</div>
      <div id="confirmList" class="confirm-list"></div>
    </div>
  </div>
</div>


<script id="swal-force-white-visible-js">
(function(){
  try{
    if(!window.Swal) return;
    if(window.Swal.__forceWhiteVisible) return;
    window.Swal.__forceWhiteVisible = true;

    var Swal = window.Swal;
    var oldFire = Swal.fire.bind(Swal);

    Swal.fire = function(a,b,c){
      var opts;
      if(a && typeof a === 'object'){
        opts = Object.assign({}, a);
      }else{
        opts = { title: (a||''), text: (b||''), icon: c };
      }

      var all = String((opts.title||'') + ' ' + (opts.text||'') + ' ' + (opts.html||'')).toUpperCase();

      // Replace any "table not found" style message
      if(all.indexOf('TABLO') !== -1 && (all.indexOf('BULUNAM') !== -1 || all.indexOf('UYGUN') !== -1)){
        opts.icon = 'warning';
        opts.title = '';
        opts.html = '<div style="width:100%;margin:-6px 0 12px 0;"><img src="data:image/svg+xml;base64,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" alt="binary" style="width:100%;max-height:140px;object-fit:cover;border-radius:14px;display:block;opacity:0.95;border:1px solid rgba(0,255,154,.20);box-shadow:0 0 22px rgba(0,255,154,.10);"></div>'+ '<div class="swal-table-notfound">UYGUN TABLO BULUNAMADI.<br>LÜTFEN ADMİNDEN TABLO TALEP EDİNİZ.</div>';
        delete opts.text;
      }

      var userDidOpen = opts.didOpen;

      opts.didOpen = function(el){
        try{
          var popup = Swal.getPopup && Swal.getPopup();
          if(popup){
            popup.style.setProperty('opacity','1','important');
            popup.style.setProperty('filter','none','important');
            popup.style.setProperty('background','#000000','important');
          }
          var t = Swal.getTitle && Swal.getTitle();
          if(t){
            t.style.setProperty('color','#ffffff','important');
            t.style.setProperty('opacity','1','important');
            t.style.setProperty('font-weight','900','important');
          }
          var h = Swal.getHtmlContainer && Swal.getHtmlContainer();
          if(h){
            h.style.setProperty('color','#ffffff','important');
            h.style.setProperty('opacity','1','important');
            h.style.setProperty('font-weight','900','important');
          }
        }catch(e){}
        if(typeof userDidOpen === 'function'){ try{ userDidOpen(el); }catch(e){} }
      };

      return oldFire(opts);
    };
  }catch(e){}
})();
</script>

</body>
</html>
