<?php
function parse_license_date($dateRaw){
    if(empty($dateRaw)) return null;
    $formats = ['Y-m-d','Y-m-d H:i:s','d.m.Y','d.m.Y H:i:s','d/m/Y','d/m/Y H:i:s'];
    foreach($formats as $f){
        $dt = DateTime::createFromFormat($f, $dateRaw);
        if($dt !== false){ return $dt; }
    }
    $ts = strtotime($dateRaw);
    if($ts !== false){
        return (new DateTime())->setTimestamp($ts);
    }
    return null;
}
function calculate_remaining_days($validTo){
    date_default_timezone_set('Europe/Istanbul');
    $expire = parse_license_date($validTo);
    if(!$expire) return 0;
    $now = new DateTime();
    if($expire < $now) return 0;
    $diff = $now->diff($expire);
    return (int)$diff->days;
}
