<!DOCTYPE html>
<?php
session_start();
if(($_SESSION['role']??'')!=='admin') header('Location: login.php');
$__admin_user = strtoupper(trim((string)($_SESSION['user'] ?? $_SESSION['username'] ?? 'ADMIN')));
$__admin_role = 'Admin';
?>
<html lang="tr" data-bs-theme="dark">
<head>
  <meta charset="UTF-8">
  <title>ECU PRATIX - ADMIN</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <style>
  :root{
    --bg0:#050506;
    --bg1:#0b0b0e;
    --card:#0f0f14;
    --card2:#12121a;
    --stroke:rgba(255,255,255,.08);
    --stroke2:rgba(255,255,255,.12);
    --txt:#eaeaf0;
    --muted:#9aa0a6;
    --soft:#151520;
    --soft2:#1b1b28;
    --accent:#5b8cff;
    --accent2:#7c5cff;
    --good:#35f0a2;
    --warn:#ffd44d;
    --bad:#ff5a78;
  }

  html,body{height:100%}
  body{
    margin:0;
    background:
      radial-gradient(900px 450px at 12% 0%, rgba(91,140,255,.20), transparent 60%),
      radial-gradient(900px 450px at 88% 0%, rgba(124,92,255,.18), transparent 60%),
      radial-gradient(1200px 600px at 50% 120%, rgba(53,240,162,.08), transparent 55%),
      var(--bg0);
    color:var(--txt);
    font-family: ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, Arial, "Noto Sans", "Liberation Sans", sans-serif;
  }

  /* LAYOUT */
  .sidebar{
    height:100vh;
    position:fixed;
    inset:0 auto 0 0;
    width:280px;
    padding:18px 16px;
    overflow:auto;
    background: linear-gradient(180deg, rgba(18,20,24,.96), rgba(10,10,14,.96));
    border-right:1px solid var(--stroke);
    backdrop-filter: blur(14px);
  }
  .main{
    margin-left:280px;
    padding:92px 28px 60px;
    min-height:100vh;
  }

  /* TOP NAV (Rocker-like) */
  .topnav{
    position:fixed;
    left:280px;
    right:0;
    top:0;
    height:72px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    padding:0 22px;
    background: linear-gradient(180deg, rgba(12,14,18,.92), rgba(12,14,18,.60));
    border-bottom:1px solid rgba(255,255,255,.08);
    backdrop-filter: blur(16px);
    z-index: 50;
  }
  .top-left{display:flex;align-items:center;gap:12px;min-width:320px}
  .burger{
    width:42px;height:42px;border-radius:14px;
    display:flex;align-items:center;justify-content:center;
    border:1px solid rgba(255,255,255,.12);
    background: rgba(255,255,255,.05);
    color:#fff;
  }
  .burger:hover{background: rgba(255,255,255,.08)}
  .searchbox{position:relative;flex:1;max-width:520px}
  .searchbox i{position:absolute;left:14px;top:50%;transform:translateY(-50%);opacity:.7}
  .searchbox input{
    width:100%;
    height:44px;
    padding:0 14px 0 40px;
    border-radius:14px;
    border:1px solid rgba(255,255,255,.10);
    background: rgba(0,0,0,.22);
    color:#fff;
    outline:none;
  }
  .searchbox input:focus{border-color: rgba(91,140,255,.45); box-shadow:0 0 0 .18rem rgba(91,140,255,.14)}
  .top-right{display:flex;align-items:center;gap:10px}
  .iconbtn{
    width:42px;height:42px;border-radius:14px;
    display:flex;align-items:center;justify-content:center;
    border:1px solid rgba(255,255,255,.12);
    background: rgba(255,255,255,.05);
    color:#e8e8ef;
    position:relative;
  }
  .iconbtn:hover{background: rgba(255,255,255,.08)}
  .badge-dot{
    position:absolute;top:8px;right:8px;
    min-width:18px;height:18px;border-radius:999px;
    padding:0 6px;
    display:flex;align-items:center;justify-content:center;
    font-size:11px;font-weight:800;
    background: rgba(255,90,120,.95);
    border:1px solid rgba(255,255,255,.25);
    color:#fff;
  }
  .profile{
    display:flex;align-items:center;gap:10px;
    padding:6px 10px;
    border-radius:16px;
    border:1px solid rgba(255,255,255,.12);
    background: rgba(255,255,255,.05);
    color:#fff;
  }
  .avatar{
    width:38px;height:38px;border-radius:14px;
    display:flex;align-items:center;justify-content:center;
    background: radial-gradient(16px 16px at 30% 30%, rgba(255,255,255,.18), rgba(255,255,255,.06));
    border:1px solid rgba(255,255,255,.12);
    font-weight:900;
  }
  .pmeta{line-height:1.05}
  .pname{font-weight:800;font-size:13px}
  .prole{font-size:12px;color:rgba(255,255,255,.65)}

  /* Collapsed sidebar */
  body.sb-collapsed .sidebar{width:86px;padding:18px 10px}
  body.sb-collapsed .main{margin-left:86px}
  body.sb-collapsed .topnav{left:86px}
  body.sb-collapsed .navitem span, body.sb-collapsed .brand-left .logo, body.sb-collapsed .brand-left .sub{display:none}
  body.sb-collapsed .brand{justify-content:center}
  body.sb-collapsed .navitem{justify-content:center}


  /* BRAND */
  .brand{
    display:flex;
    align-items:center;
    justify-content:space-between;
    gap:10px;
    padding:12px 12px;
    border-radius:18px;
    border:1px solid rgba(255,255,255,.08);
    background: linear-gradient(180deg, rgba(255,255,255,.06), rgba(255,255,255,.03));
    box-shadow: 0 16px 45px rgba(0,0,0,.35);
  }
  .brand-left{display:flex; gap:12px; align-items:center}
  .brand-mark{
    width:40px; height:40px; border-radius:14px;
    background: radial-gradient(16px 16px at 30% 30%, rgba(255,255,255,.18), rgba(255,255,255,.06));
    border:1px solid rgba(255,255,255,.10);
    display:flex; align-items:center; justify-content:center;
  }
  .brand-mark i{font-size:18px; color:#cfe0ff}
  .logo{font-weight:900; letter-spacing:.7px; line-height:1}
  .sub{font-size:12px; color:var(--muted)}
  .pill{
    font-size:12px;
    padding:5px 10px;
    border-radius:999px;
    background: rgba(255,255,255,.05);
    border:1px solid rgba(255,255,255,.10);
    color:#d6d6de;
  }

  /* NAV */
  .navgroup{margin-top:14px}
  .navitem{
    display:flex;
    align-items:center;
    gap:10px;
    padding:11px 12px;
    border-radius:16px;
    color:#d5d5df;
    text-decoration:none;
    transition: all .15s ease;
    border:1px solid transparent;
  }
  .navitem i{opacity:.9}
  .navitem:hover{
    background: rgba(255,255,255,.05);
    border-color: rgba(255,255,255,.08);
    transform: translateY(-1px);
    color:#fff;
  }
  .navitem.active{
    background: linear-gradient(180deg, rgba(91,140,255,.18), rgba(124,92,255,.10));
    border:1px solid rgba(91,140,255,.25);
    color:#fff;
  }
  .navsep{
    height:1px;
    background: rgba(255,255,255,.08);
    margin:14px 8px;
  }

  /* TOP HEADER */
  .topbar{
    display:flex;
    align-items:flex-end;
    justify-content:space-between;
    gap:12px;
    margin-bottom:14px;
  }
  .page-title{font-size:28px; font-weight:900; letter-spacing:.2px; margin:0}
  .page-sub{color:var(--muted); margin-top:4px}

  /* CARDS */
  .cardx{
    background: linear-gradient(180deg, rgba(255,255,255,.05), rgba(255,255,255,.02));
    border:1px solid var(--stroke);
    border-radius:20px;
    box-shadow: 0 18px 55px rgba(0,0,0,.35);
  }
  .cardx .card-header{
    background: transparent;
    border-bottom: 1px solid rgba(255,255,255,.06);
  }
  .cardx:hover{border-color: rgba(255,255,255,.12)}
  .tag{
    font-size:12px;
    padding:4px 10px;
    border-radius:999px;
    border:1px solid rgba(255,255,255,.14);
    color:#d3d3dc;
    background: rgba(255,255,255,.04);
  }

  .kpi-wrap{display:flex; align-items:center; justify-content:space-between; gap:10px}
  .kpi{font-size:30px; font-weight:900; letter-spacing:.4px}
  .kpi-ico{
    width:44px; height:44px; border-radius:16px;
    display:flex; align-items:center; justify-content:center;
    border:1px solid rgba(255,255,255,.12);
    background: rgba(255,255,255,.05);
  }
  .kpi-ico i{font-size:18px; color:#cfe0ff}

  /* FORMS */
  .form-control,.form-select{
    background: rgba(10,10,14,.72);
    border:1px solid rgba(255,255,255,.12);
    color:#fff;
    border-radius:14px;
  }
  .form-control:focus,.form-select:focus{
    border-color: rgba(91,140,255,.45);
    box-shadow: 0 0 0 .18rem rgba(91,140,255,.18);
  }

  /* BUTTONS */
  .btn-soft{
    background: rgba(255,255,255,.06);
    border:1px solid rgba(255,255,255,.12);
    color:#fff;
    border-radius:14px;
  }
  .btn-soft:hover{background: rgba(255,255,255,.09)}
  .btn-warning{border-radius:14px}
  .btn{box-shadow:none}

  /* TABLES */
  .table{--bs-table-bg:transparent; --bs-table-color:var(--txt)}
  .table thead th{
    color:#cfd0da;
    font-weight:700;
    border-bottom:1px solid rgba(255,255,255,.10) !important;
    position: sticky;
    top: 0;
    background: rgba(10,10,14,.92);
    backdrop-filter: blur(10px);
    z-index: 2;
  }
  .table tbody tr{border-color: rgba(255,255,255,.06)}
  .table tbody tr:hover{background: rgba(255,255,255,.04)}
  .table td{border-color: rgba(255,255,255,.06)}
  .table-responsive{border-radius:16px; overflow:auto}

  .muted{color:var(--muted)}
.softbox{border:1px solid var(--stroke); background: rgba(255,255,255,.03); border-radius:14px;}
</style>

<style id="swal-force-white-visible">
/* === FORCE SWEETALERT TEXT VISIBLE (WHITE) === */
.swal2-title,
.swal2-html-container,
.swal2-content,
.swal2-popup{
  color:#ffffff !important;
  opacity:1 !important;
  filter:none !important;
  mix-blend-mode:normal !important;
}
.swal2-title{ font-weight:900 !important; }
.swal2-html-container{ font-weight:900 !important; }

.ecu-swal-title,
.ecu-swal-html{
  color:#ffffff !important;
  opacity:1 !important;
}

.swal-table-notfound{
  color:#ffffff !important;
  font-weight:900 !important;
  font-size:18px !important;
  line-height:1.35 !important;
  text-align:center !important;
  text-shadow: 0 0 10px rgba(0,0,0,0.9) !important;
}
</style>

</head>
<body>
  <div class="sidebar">
    <div class="brand mb-3">
  <div class="brand-left">
    <div class="brand-mark"><i class="bi bi-shield-lock"></i></div>
    <div>
      <div class="logo">ECU PRATIX</div>
      <div class="sub">Admin Dashboard • GEN3 Dark Pro</div>
    </div>
  </div>
  <span class="pill">v27</span>
</div>

<div class="navgroup">
<a href="#" class="navitem active" data-view="dash"><i class="bi bi-speedometer2"></i><span>Dashboard</span></a>
    <a href="#" class="navitem" data-view="users"><i class="bi bi-people"></i><span>Kullanıcılar</span></a>
    <a href="#" class="navitem" data-view="activity"><i class="bi bi-receipt"></i><span>İşlem Logları</span></a>
    <a href="#" class="navitem" data-view="auto_dtc"><i class="bi bi-magic"></i><span>AUTO DTC</span></a>
    <a href="#" class="navitem" data-view="library"><i class="bi bi-collection"></i><span>Kütüphane</span></a>
    <a href="#" class="navitem" data-view="packages"><i class="bi bi-box-seam"></i><span>Paketler</span></a>
    <a href="#" class="navitem" data-view="teach"><i class="bi bi-cpu"></i><span>Yeni Profil</span></a>
    <a href="simulator.php" class="navitem"><i class="bi bi-flask2"></i><span>Simülatör</span></a>

    </div>
<div class="navsep"></div>
<a href="#" class="navitem text-danger" id="btnLogout"><i class="bi bi-box-arrow-right"></i><span>Çıkış</span></a>
  </div>

  <div class="main">

    <!-- TOP NAV -->
    <div class="topnav">
      <div class="top-left">
        <button class="burger" id="btnToggleSidebar" type="button" title="Menü"><i class="bi bi-list"></i></button>
        <div class="searchbox">
          <i class="bi bi-search"></i>
          <input id="globalSearch" type="text" placeholder="Search (users, profiles, logs)">
        </div>
      </div>
      <div class="top-right">
        <button class="iconbtn" type="button" title="Tema"><i class="bi bi-sun"></i></button>
        <button class="iconbtn" type="button" title="Uyarılar"><i class="bi bi-bell"></i><span class="badge-dot" id="notifDot">7</span></button>
        <button class="iconbtn" type="button" title="Kısayollar"><i class="bi bi-grid"></i></button>
        <div class="profile" title="<?php echo htmlspecialchars($__admin_user); ?>">
          <div class="avatar"><?php echo htmlspecialchars(substr($__admin_user,0,1)); ?></div>
          <div class="pmeta">
            <div class="pname"><?php echo htmlspecialchars($__admin_user); ?></div>
            <div class="prole"><?php echo htmlspecialchars($__admin_role); ?></div>
          </div>
        </div>
      </div>
    </div>

    <!-- DASHBOARD -->
    <div id="view_dash">
      <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
          <div class="h3 mb-0">Dashboard</div>
          <div class="muted">Son eklenenler • son 10 işlem • giriş/çıkış</div>
        </div>
        <button class="btn btn-soft" id="btnRefreshDash">Yenile</button>
      </div>

      <div class="row g-3">
        <div class="col-md-3">
          <div class="cardx p-3">
  <div class="muted">Toplam Profil</div>
  <div class="kpi-wrap">
    <div class="kpi" id="kpiProfiles">-</div>
    <div class="kpi-ico"><i class="bi bi-database"></i></div>
  </div>
</div>
        </div>
        <div class="col-md-3">
          <div class="cardx p-3">
  <div class="muted">Toplam Kullanıcı</div>
  <div class="kpi-wrap">
    <div class="kpi" id="kpiUsers">-</div>
    <div class="kpi-ico"><i class="bi bi-people"></i></div>
  </div>
</div>
        </div>
        <div class="col-md-3">
          <div class="cardx p-3">
  <div class="muted">Bugün Giriş</div>
  <div class="kpi-wrap">
    <div class="kpi" id="kpiLogins">-</div>
    <div class="kpi-ico"><i class="bi bi-box-arrow-in-right"></i></div>
  </div>
</div>
        </div>
        <div class="col-md-3">
          <div class="cardx p-3">
  <div class="muted">Son 24s İşlem</div>
  <div class="kpi-wrap">
    <div class="kpi" id="kpiActions24">-</div>
    <div class="kpi-ico"><i class="bi bi-activity"></i></div>
  </div>
</div>
        </div>
      </div>

      <!-- ROCKER-LIKE CHARTS -->
      <div class="row g-3 mt-1">
        <div class="col-lg-8">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Activity Overview</div>
              <span class="tag">last 7 days</span>
            </div>
            <div class="p-3">
              <canvas id="chartActivity" height="170" style="width:100%"></canvas>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Order Status</div>
              <span class="tag">profiles</span>
            </div>
            <div class="p-3">
              <canvas id="chartBars" height="170" style="width:100%"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div class="row g-3 mt-1">
        <div class="col-lg-6">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Son Eklenen Profiller</div>
              <span class="tag" id="dashProfilesHint">library</span>
            </div>
            <div class="p-3">
              <div class="table-responsive">
                <table class="table table-sm align-middle mb-0">
                  <thead><tr><th>#</th><th>Profil</th><th>Marka</th><th>ECU</th><th>Paket</th><th>Boyut</th></tr></thead>
                  <tbody id="dashProfiles"></tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Kullanıcıların Son 10 İşlemi</div>
              <span class="tag">audit</span>
            </div>
            <div class="p-3">
              <div class="table-responsive">
                <table class="table table-sm align-middle mb-0">
                  <thead><tr><th>Zaman</th><th>Kullanıcı</th><th>Aksiyon</th><th>Detay</th></tr></thead>
                  <tbody id="dashLastActions"></tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <div class="col-12">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Giriş / Çıkış Kayıtları</div>
              <span class="tag">login/logout</span>
            </div>
            <div class="p-3">
              <div class="table-responsive">
                <table class="table table-sm align-middle mb-0">
                  <thead><tr><th>Zaman</th><th>Kullanıcı</th><th>Aksiyon</th><th>IP</th></tr></thead>
                  <tbody id="dashLogins"></tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>

    <!-- USERS -->
    <div id="view_users" style="display:none">
      <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
          <div class="h3 mb-0">Kullanıcı Yönetimi</div>
          <div class="muted">Kullanıcı ekle/sil • aktif/pasif • rol</div>
        </div>
        <button class="btn btn-warning" id="btnAddUser">+ Kullanıcı Ekle</button>
      </div>

      <div class="cardx">
        <div class="card-header p-3 d-flex align-items-center justify-content-between">
          <div class="fw-bold">Kullanıcılar</div>
          <button class="btn btn-soft btn-sm" id="btnRefreshUsers">Yenile</button>
        </div>
        <div class="p-3">
          <div class="table-responsive">
            <table class="table table-sm align-middle mb-0">
              <thead><tr><th>Kullanıcı</th><th>Rol</th><th>Durum</th><th>Başlangıç</th><th>Bitiş</th><th>Paket</th><th>Limit</th><th>Kalan</th><th class="text-end">Aksiyon</th></tr></thead>
              <tbody id="usersTable"></tbody>
            </table>
          </div>
        </div>
      </div>
    </div>


    <!-- PACKAGES -->
    <div id="view_packages" style="display:none">
      <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
          <div class="h3 mb-0">Paket Yönetimi</div>
          <div class="muted">Paket oluştur/düzenle • günlük limit • marka/grup kısıtları</div>
        </div>
        <div class="d-flex gap-2">
          <button class="btn btn-warning" id="btnAddPkg">+ Paket</button>
          <button class="btn btn-soft" id="btnRefreshPkg">Yenile</button>
        </div>
      </div>

      <div class="cardx">
        <div class="card-header p-3 d-flex align-items-center justify-content-between">
          <div class="fw-bold">Paketler</div>
          <span class="tag">packages</span>
        </div>
        <div class="p-3">
          <div class="table-responsive">
            <table class="table table-sm align-middle mb-0">
              <thead><tr><th>ID</th><th>Ad</th><th>Durum</th><th>Günlük Limit</th><th>Brands</th><th>Groups</th><th class="text-end">Aksiyon</th></tr></thead>
              <tbody id="pkgTable"></tbody>
            </table>
          </div>
        </div>
      </div>
    </div>


    <!-- ACTIVITY -->
    <div id="view_activity" style="display:none">
      <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
          <div class="h3 mb-0">İşlem Logları</div>
          <div class="muted">Son işlemler • filtrele • kullanıcı bazlı son 10</div>
        </div>
        <button class="btn btn-soft" id="btnRefreshActivity">Yenile</button>
      </div>

      <div class="row g-3">
        <div class="col-lg-8">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Son İşlemler</div>
              <span class="tag">audit</span>
            </div>
            <div class="p-3">
              <div class="table-responsive">
                <table class="table table-sm align-middle mb-0">
                  <thead><tr><th>Zaman</th><th>Kullanıcı</th><th>Rol</th><th>Aksiyon</th><th>IP</th></tr></thead>
                  <tbody id="auditRecent"></tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-4">
          <div class="cardx p-3">
            <div class="fw-bold mb-2">Kullanıcı Bazlı Son 10</div>
            <select class="form-select mb-2" id="auditUserSel"></select>
            <button class="btn btn-soft w-100 mb-3" id="btnLoadUserLast">Getir</button>

            <div class="table-responsive" style="max-height:520px;overflow:auto">
              <table class="table table-sm align-middle mb-0">
                <thead><tr><th>Zaman</th><th>Aksiyon</th></tr></thead>
                <tbody id="auditUserLast"></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>

    
    <!-- AUTO DTC RULES -->
    <div id="view_auto_dtc" style="display:none">
      <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
          <div class="h3 mb-0">AUTO DTC</div>
          <div class="muted">Kategori bazlı Keyword + DTC Code tanımı • user tarafında tek tuşla OFF seçimi</div>
        </div>
        <div class="d-flex gap-2">
          <button class="btn btn-soft" id="btnAutoDtcReload">Yenile</button>
          <button class="btn btn-primary" id="btnAutoDtcSave"><i class="bi bi-save2 me-2"></i>Kaydet</button>
        </div>
      </div>

      <div class="cardx p-3">
        <div class="row g-3" id="autoDtcGrid"></div>
        <div class="muted mt-3" style="font-size:12px">
          <b>Not:</b> Keywords açıklama alanında aranır. Codes alanına <b>P2002,P0401</b> gibi kodları virgülle yaz.
        </div>
      </div>
    </div>

<!-- LIBRARY -->
    <div id="view_library" style="display:none">
      <div class="d-flex align-items-center justify-content-between mb-3">
        <div>
          <div class="h3 mb-0">Kütüphane</div>
          <div class="muted">Ekle/çıkar/düzenle • marka/ecu • kod sayısı ve detaylar</div>
        </div>
        <button class="btn btn-soft" id="btnRefreshLibrary">Yenile</button>
      </div>

      <div class="row g-3">
        <div class="col-lg-4">
          <div class="cardx p-3">
            <div class="fw-bold mb-2">Özet</div>
            <div class="muted mb-2">ECU marka / kod sayısı</div>
            <div class="table-responsive">
              <table class="table table-sm align-middle mb-0">
                <thead><tr><th>Marka</th><th>Profil</th><th>Kod</th></tr></thead>
                <tbody id="libStats"></tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="col-lg-8">
          <div class="cardx">
            <div class="card-header p-3 d-flex align-items-center justify-content-between">
              <div class="fw-bold">Profil Kayıtları</div>
              <input class="form-control form-control-sm" style="max-width:260px" id="libSearch" placeholder="Ara (profil/marka/ecu)">
            </div>
            <div class="p-3">
              <div class="table-responsive">
                <table class="table table-sm align-middle mb-0">
                  <thead>
                    <tr>
                      <th>#</th><th>Profil</th><th>Marka</th><th>ECU</th><th>Paket</th><th>Boyut</th><th>Read</th><th>Patch</th><th class="text-end">Aksiyon</th>
                    </tr>
                  </thead>
                  <tbody id="libTable"></tbody>
                </table>
              </div>
              <div class="muted mt-2">Not: Kod sayısı = patch tablo adedi (profile patch_tables). İstersen gerçek DTC sayısını da ekleriz.</div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- TEACH (original flow preserved) -->
    <div id="view_teach" style="display:none">
      <!-- Original admin create UI is kept below by including existing block -->
      <div class="h3 mb-2">Yeni Profil Öğret</div>
      <div class="muted mb-3">Binary + JSON yükle • okuma metodu seç • tablo seç • patch config kaydet</div>

      
    <div id="create">
        <h3>Yeni Profil Öğret</h3>
        <div class="card p-4 mt-3 bg-dark border-secondary">
            <div class="row"><div class="col"><input type="file" id="bin" class="form-control"></div><div class="col"><input type="file" id="json" class="form-control"></div></div>
            <button class="btn btn-warning w-100 mt-2" onclick="loadFiles()">Dosyaları Yükle</button>
            <div id="config" class="d-none mt-4">
                <div class="row">
                    <div class="col-5"><label>Okuma Metodu</label><select id="method" class="form-control" multiple style="height:300px">
                        <option value="1. GPEC2 (COL1)">1. GPEC2 (COL1)</option>
                        <option value="2. EMS3150 (6C:COL5)">2. EMS3150 (6C:COL5)</option>
                        <option value="3. EMS3150 (8C:COL3)">3. EMS3150 (8C:COL3)</option>
                        <option value="4. CRD2/CRD3 (COL0)">4. CRD2/CRD3 (COL0)</option>
                        <option value="5. EMS3155 (6C:COL0)">5. EMS3155 (6C:COL0)</option>
                        <option value="6. EMS3155 (8C:COL4)">6. EMS3155 (8C:COL4)</option>
                        <option value="7. MAN EDC17CV42 (SPN+FMI)">7. MAN EDC17CV42 (SPN+FMI)</option>
                        <option value="8. ACM/MCM (COL4+SWAP)">8. ACM/MCM (COL4+SWAP)</option>
                        <option value="9. NGC4/5 (COL5+FIX)">9. NGC4/5 (COL5+FIX)</option>
                        <option value="10. EDC16/ME7 (OBD2 ALL)">10. EDC16/ME7 (OBD2 ALL)</option>
                        <option value="11. EDC16/ME7 (OEM ALL)">11. EDC16/ME7 (OEM ALL)</option>
                        <option value="12. BOSCH EDC15 (COL0)">12. BOSCH EDC15 (COL0)</option>
                        <option value="13. EDC17 (OBD2 MULTI)">13. EDC17 (OBD2 MULTI)</option>
                        <option value="14. EDC17 (OEM MULTI)">14. EDC17 (OEM MULTI)</option>
                        <option value="15. SIEMENS PPD1 (GROUP)">15. SIEMENS PPD1 (GROUP)</option>
                        <option value="16. SIMOS PCR2.1 (GROUP)">16. SIMOS PCR2.1 (GROUP)</option>
                        <option value="17. VALEO VD56.1 (HEX8)">17. VALEO VD56.1 (HEX8)</option>
                        <option value="18. SIEMENS SDI7/SDI8 (COL1)">18. SIEMENS SDI7/SDI8 (COL1)</option>
                        <option value="19. SIEMENS SID201 (ALL COLS)">19. SIEMENS SID201 (ALL COLS)</option>
                        <option value="20. BMW MSV80 (GROUP COL0..COL5)">20. BMW MSV80 (GROUP COL0..COL5)</option>
                        <option value="21. DELPHI DCM3.1/DCM3.2 (ALL COLS)">21. DELPHI DCM3.1/DCM3.2 (ALL COLS)</option>
                    </select></div>
                    <div class="col-7"><label>DTC Tablosu</label><select id="table" class="form-control" multiple style="height:300px"></select><button class="btn btn-info btn-sm mt-2 w-100" onclick="testRead()">Test Okuma</button></div>
                </div>
                <div id="readRes" class="bg-black p-2 mt-2 font-monospace text-success d-none" style="max-height:100px;overflow:auto"></div>
                <hr class="border-secondary my-4">
                <h5 class="text-warning">Patch Ayarları</h5>
                <select id="pTable" class="form-control mb-2"></select>
                <div id="dynCols" class="d-flex flex-wrap gap-2"></div>
                <button class="btn btn-light btn-sm mt-2" onclick="addRule()">+ Kural Ekle</button>
                <ul id="ruleList" class="mt-2 text-warning small"></ul>
                <hr class="border-secondary my-4">
                <h5 class="text-info">Profil Bilgileri</h5>
                <div class="row g-2">
                    <div class="col-md-4"><input type="text" id="brand" class="form-control" placeholder="MARKA (örn: VW)"></div>
                    <div class="col-md-4"><input type="text" id="ecuModel" class="form-control" placeholder="ECU MODEL (örn: MD1CS004)"></div>
                    <div class="col-md-4">
                        <select id="brandGroup" class="form-select">
                            <option value="">GRUP (Yok/Diğer)</option>
                            <option value="VAG GRUBU">VAG GRUBU</option>
                            <option value="PSA GRUBU">PSA GRUBU</option>
                            <option value="GM">GM</option>
                            <option value="FCA">FCA</option>
                            <option value="JRL">JRL</option>
                            <option value="TOYOTA">TOYOTA</option>
                            <option value="HYUNDAI">HYUNDAI</option>
                            <option value="RENAULT">RENAULT</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                      <div class="d-flex gap-2 align-items-center">
                        <input type="file" id="brandLogo" class="form-control" accept="image/*">
                        <button type="button" class="btn btn-soft" onclick="openLogoLibrary()" title="Logo Kütüphanesi">
                          <i class="bi bi-images"></i>
                        </button>
                      </div>
                      <input type="hidden" id="brandLogoPick" value="">
                      <div class="mt-2 d-flex align-items-center gap-2" id="brandLogoPreview" style="display:none">
                        <img id="brandLogoPreviewImg" src="" style="width:44px;height:44px;object-fit:contain;border-radius:10px;border:1px solid rgba(255,255,255,.12);background:rgba(0,0,0,.25);padding:4px">
                        <div class="muted" style="font-size:12px;line-height:1.15">
                          Seçilen Logo<br><span id="brandLogoPreviewTxt" style="opacity:.75"></span>
                        </div>
                        <button type="button" class="btn btn-outline-danger btn-sm" onclick="clearLogoPick()" title="Kaldır"><i class="bi bi-x-lg"></i></button>
                      </div>
                    </div>
                    <div class="col-md-6"><input type="text" id="pName" class="form-control" placeholder="Profil Adı"></div>
                </div>
                <div class="row g-2 mt-2">
                    <div class="col-md-12">
                        <label class="text-info small mb-1">Paket</label>
                        <select id="profilePackage" class="form-select">
                            <option value="">(Yok)</option>
                        </select>
                        <div class="text-secondary small mt-1">Bu profil hangi paket(ler)de görünsün. Boş = herkes.</div>
                    </div>
                </div>
                <button class="btn btn-success w-100 mt-3" onclick="save()">Profili Kaydet</button>
            </div>
        </div>
    </div>
    <div id="lib" style="display:none"><h3>Kütüphane</h3><table class="table table-dark table-hover mt-3"><thead><tr><th>ID</th><th>Adı</th><th>İşlem</th></tr></thead><tbody id="libBody"></tbody></table></div>
</div>
<script>
let token, rules=[], tData={};
const BRAND_TO_GROUP = {
  // VAG GRUBU
  'VW':'VAG GRUBU','VOLKSWAGEN':'VAG GRUBU','AUDI':'VAG GRUBU','SEAT':'VAG GRUBU','SKODA':'VAG GRUBU','PORSCHE':'VAG GRUBU','BUGATTI':'VAG GRUBU','BENTLEY':'VAG GRUBU',
  // PSA
  'PEUGEOT':'PSA GRUBU','CITROEN':'PSA GRUBU','CİTROEN':'PSA GRUBU','DS':'PSA GRUBU',
  // GM
  'OPEL':'GM','CHEVROLET':'GM',
  // FCA
  'FIAT':'FCA','FİAT':'FCA','IVECO':'FCA','İVECO':'FCA','JEEP':'FCA','LANCIA':'FCA','LANCİA':'FCA','ALFA':'FCA','ALFA ROMEO':'FCA','ALPINE':'FCA','ALPİNE':'FCA','DODGE':'FCA','DOODGE':'FCA','FERRARI':'FCA','FERRARİ':'FCA','MASERATI':'FCA','MASARATI':'FCA',
  // JRL
  'JAGUAR':'JRL','LANDROVER':'JRL','LAND ROVER':'JRL',
  // TOYOTA
  'TOYOTA':'TOYOTA','LEXUS':'TOYOTA',
  // HYUNDAI
  'HYUNDAI':'HYUNDAI','HYUNDAİ':'HYUNDAI','KIA':'HYUNDAI','KİA':'HYUNDAI',
  // RENAULT
  'RENAULT':'RENAULT','DACIA':'RENAULT','DACİA':'RENAULT','NISSAN':'RENAULT'
};

function normBrand(s){
  return String(s||'').trim().toUpperCase()
    .replaceAll('İ','I').replaceAll('İ','I')
    .replaceAll('Ş','S').replaceAll('Ğ','G').replaceAll('Ü','U').replaceAll('Ö','O').replaceAll('Ç','C');
}

$('#brand').on('change blur', function(){
  const b = normBrand($(this).val());
  if(!b) return;
  const g = BRAND_TO_GROUP[b];
  if(!g) return;
  // marka bir gruba dahilse sor
  Swal.fire({
    title:'Grup Seç',
    text:`${$(this).val()} için grup belirlendi. Onayla veya değiştir.`,
    input:'select',
    inputOptions:{
      'VAG GRUBU':'VAG GRUBU','PSA GRUBU':'PSA GRUBU','GM':'GM','FCA':'FCA','JRL':'JRL','TOYOTA':'TOYOTA','HYUNDAI':'HYUNDAI','RENAULT':'RENAULT'
    },
    inputValue:g,
    confirmButtonText:'Tamam'
  }).then(res=>{ if(res.isConfirmed) $('#brandGroup').val(res.value); });
});
function loadFiles(){
    let fd=new FormData(); fd.append('bin_file',$('#bin')[0].files[0]); fd.append('json_file',$('#json')[0].files[0]); fd.append('action','admin_load_files');
    $.ajax({url:'api.php',type:'POST',data:fd,processData:false,contentType:false,success:r=>{
        if(r.status=='ok'){ token=r.token; $('#config').removeClass('d-none'); let h=""; r.tables.forEach(t=>{ h+=`<option value="${t.id}">${t.text}</option>`; tData[t.id]=t.cols; }); $('#table').html(h); $('#pTable').html('<option value="">Seçiniz...</option>'+h); }
    }});
}
$('#pTable').change(function(){
    let c=tData[$(this).val()]||1, h="";
    for(let i=0;i<c;i++) h+=`<input type="text" class="form-control form-control-sm d-val" data-c="${i}" placeholder="Col${i}" style="width:60px">`;
    $('#dynCols').html(h);
});
function addRule(){
    let t=$('#pTable').val(), v={}; $('.d-val').each(function(){ if($(this).val()) v[$(this).data('c')]=$(this).val(); });
    rules.push({table:t,values_by_col:v}); $('#ruleList').append(`<li>${t} ${JSON.stringify(v)}</li>`);
}
function testRead(){ $.post('api.php',{action:'admin_read_test',token:token,methods:$('#method').val(),tables:$('#table').val()},r=>{ $('#readRes').html(r.data.map(d=>`R:${d.ROW} ${d.DTC}`).join('<br>')).removeClass('d-none'); }); }
function save(){
    const fd = new FormData();
    fd.append('action','save_profile');
    fd.append('token', token);
    fd.append('profile_name', $('#pName').val());
    ( $('#method').val() || [] ).forEach(v => fd.append('read_methods[]', v));
    ( $('#table').val() || [] ).forEach(v => fd.append('read_tables[]', v));
    fd.append('patch_config', JSON.stringify(rules));
    fd.append('brand', $('#brand').val());
    fd.append('ecu_model', $('#ecuModel').val());
    fd.append('brand_group', $('#brandGroup').val());
    fd.append('package_id', $('#profilePackage').val());
    if($('#brandLogo')[0].files[0]) fd.append('brand_logo', $('#brandLogo')[0].files[0]);
    const pick = ($('#brandLogoPick').val()||'').trim();
    if(pick) fd.append('brand_logo_pick', pick);

    $.ajax({
      url:'api.php',
      type:'POST',
      data:fd,
      processData:false,
      contentType:false,
      success:r=>Swal.fire(r.msg || 'Kaydedildi')
    });
}

function clearLogoPick(){
  $('#brandLogoPick').val('');
  $('#brandLogoPreview').hide();
  $('#brandLogoPreviewImg').attr('src','');
  $('#brandLogoPreviewTxt').text('');
}

function openLogoLibrary(){
  apiPost('admin_list_logo_library', {}, (r)=>{
    if(!r || r.status!=='ok'){ Swal.fire('Hata','Logo kütüphanesi okunamadı','error'); return; }
    const list = r.logos||[];
    let html = `
      <div style="text-align:left">
        <input id="logoSearch" class="swal2-input" placeholder="Ara..." style="margin:0 0 10px 0">
        <div id="logoGrid" style="display:grid;grid-template-columns:repeat(6,1fr);gap:10px;max-height:55vh;overflow:auto;padding:4px">
          ${list.map(p=>`
            <div class="logoItem" data-path="${p}" style="cursor:pointer;border:1px solid rgba(255,255,255,.12);border-radius:14px;padding:10px;background:rgba(0,0,0,.22);display:flex;flex-direction:column;align-items:center;gap:8px">
              <img src="${p}" style="width:64px;height:64px;object-fit:contain">
              <div style="font-size:11px;opacity:.75;text-align:center;word-break:break-word">${p.split('/').pop()}</div>
            </div>
          `).join('')}
        </div>
      </div>
    `;
    Swal.fire({
      title: 'Logo Kütüphanesi',
      html,
      width: 980,
      showCancelButton: true,
      confirmButtonText: 'Kapat',
      didOpen: ()=>{
        const inp = document.getElementById('logoSearch');
        const grid = document.getElementById('logoGrid');
        if(inp){
          inp.addEventListener('input', ()=>{
            const q = (inp.value||'').toLowerCase();
            Array.from(grid.querySelectorAll('.logoItem')).forEach(el=>{
              const name = (el.getAttribute('data-path')||'').toLowerCase();
              el.style.display = name.includes(q) ? 'flex' : 'none';
            });
          });
        }
        Array.from(grid.querySelectorAll('.logoItem')).forEach(el=>{
          el.addEventListener('click', ()=>{
            const p = el.getAttribute('data-path');
            if(!p) return;
            $('#brandLogoPick').val(p);
            $('#brandLogoPreviewImg').attr('src', p);
            $('#brandLogoPreviewTxt').text(p.split('/').pop());
            $('#brandLogoPreview').css('display','flex');
            Swal.close();
          });
        });
      }
    });
  });
}

function clearLogoPick(){
  $('#brandLogoPick').val('');
  $('#brandLogoPreview').hide();
  $('#brandLogoPreviewImg').attr('src','');
  $('#brandLogoPreviewTxt').text('');
}

function openLogoLibrary(){
  apiPost('admin_list_logo_library', {}, (r)=>{
    if(!r || r.status!=='ok') return Swal.fire('Hata', (r&&r.msg)||'Logo kütüphanesi okunamadı', 'error');
    const logos = r.logos||[];
    const makeGrid = (flt)=>{
      const q = (flt||'').toLowerCase().trim();
      const items = logos.filter(p=> !q || p.toLowerCase().includes(q) );
      const cards = items.slice(0, 320).map(p=>{
        return `<button type="button" class="btn btn-soft" style="width:110px;height:110px;display:flex;flex-direction:column;align-items:center;justify-content:center;gap:6px;border-radius:16px" onclick="__pickLogo('${p.replace(/'/g,"\\'")}')">
          <img src="${p}" style="width:70px;height:70px;object-fit:contain">
          <div class="muted" style="font-size:10px;max-width:96px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">${p.split('/').pop()}</div>
        </button>`;
      }).join('');
      return `<div class="d-flex flex-wrap gap-2" style="max-height:58vh;overflow:auto">${cards || '<div class="muted">Logo yok</div>'}</div>`;
    };
    window.__pickLogo = (p)=>{
      $('#brandLogoPick').val(p);
      $('#brandLogoPreviewImg').attr('src', p);
      $('#brandLogoPreviewTxt').text(p.split('/').pop());
      $('#brandLogoPreview').show();
      Swal.close();
    };
    Swal.fire({
      title:'Logo Kütüphanesi',
      width: 900,
      html:`
        <div style="text-align:left">
          <div class="muted" style="font-size:12px;margin-bottom:8px">Kütüphaneden logo seç (302 adet). Seçtiğinde profil logosu olarak kaydolur.</div>
          <input id="logoSearch" class="swal2-input" style="margin:0 0 10px 0" placeholder="Ara: vw, bmw, ...">
          <div id="logoGrid">${makeGrid('')}</div>
        </div>
      `,
      showConfirmButton:false,
      showCancelButton:true,
      didOpen: ()=>{
        const inp = document.getElementById('logoSearch');
        inp && inp.addEventListener('input', ()=>{ document.getElementById('logoGrid').innerHTML = makeGrid(inp.value); });
      }
    });
  });
}
function loadLib(){ $.post('api.php',{action:'get_profiles'},r=>{ $('#libBody').html(r.profiles.map(p=>`<tr><td>${p.id}</td><td>${p.name}</td><td><button class="btn btn-sm btn-danger" onclick="del(${p.id})">Sil</button></td></tr>`).join('')); }); }
function del(i){ $.post('api.php',{action:'delete_profile',id:i},loadLib); }
</script>

<script id="swal-force-white-visible-js">
(function(){
  try{
    if(!window.Swal) return;
    if(window.Swal.__forceWhiteVisible) return;
    window.Swal.__forceWhiteVisible = true;

    var Swal = window.Swal;
    var oldFire = Swal.fire.bind(Swal);

    Swal.fire = function(a,b,c){
      var opts;
      if(a && typeof a === 'object'){
        opts = Object.assign({}, a);
      }else{
        opts = { title: (a||''), text: (b||''), icon: c };
      }

      var all = String((opts.title||'') + ' ' + (opts.text||'') + ' ' + (opts.html||'')).toUpperCase();

      // Replace any "table not found" style message
      if(all.indexOf('TABLO') !== -1 && (all.indexOf('BULUNAM') !== -1 || all.indexOf('UYGUN') !== -1)){
        opts.icon = 'warning';
        opts.title = '';
        opts.html = '<div style="width:100%;margin:-6px 0 12px 0;"><img src="data:image/svg+xml;base64,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" alt="binary" style="width:100%;max-height:140px;object-fit:cover;border-radius:14px;display:block;opacity:0.95;border:1px solid rgba(0,255,154,.20);box-shadow:0 0 22px rgba(0,255,154,.10);"></div>'+ '<div class="swal-table-notfound">UYGUN TABLO BULUNAMADI.<br>LÜTFEN ADMİNDEN TABLO TALEP EDİNİZ.</div>';
        delete opts.text;
      }

      var userDidOpen = opts.didOpen;

      opts.didOpen = function(el){
        try{
          var popup = Swal.getPopup && Swal.getPopup();
          if(popup){
            popup.style.setProperty('opacity','1','important');
            popup.style.setProperty('filter','none','important');
            popup.style.setProperty('background','#000000','important');
          }
          var t = Swal.getTitle && Swal.getTitle();
          if(t){
            t.style.setProperty('color','#ffffff','important');
            t.style.setProperty('opacity','1','important');
            t.style.setProperty('font-weight','900','important');
          }
          var h = Swal.getHtmlContainer && Swal.getHtmlContainer();
          if(h){
            h.style.setProperty('color','#ffffff','important');
            h.style.setProperty('opacity','1','important');
            h.style.setProperty('font-weight','900','important');
          }
        }catch(e){}
        if(typeof userDidOpen === 'function'){ try{ userDidOpen(el); }catch(e){} }
      };

      return oldFire(opts);
    };
  }catch(e){}
})();
</script>

</body>
</html>

    </div>

  </div>

<script>
function apiPost(action, data, cb){
  data = data || {}; data.action = action;
  $.post('api.php', data, cb, 'json').fail(()=>Swal.fire('Hata','API erişilemiyor','error'));
}
function fmtTs(ts){
  try{ return ts.replace('T',' ').replace('Z',''); }catch(e){ return ts||''; }
}
function safeJson(x){ try{ return JSON.stringify(x); }catch(e){ return ''; } }


let __pkgCache = [];
function loadPackages(cb){
  apiPost('admin_list_packages', {}, (r)=>{
    if(r.status!=='ok'){ __pkgCache=[]; if(cb) cb([]); return; }
    __pkgCache = r.packages||[];
    if(cb) cb(__pkgCache);
  });
}
function pkgOptionsHtml(selected){
  const pkgs = __pkgCache || [];
  const opts = ['<option value="">(Yok)</option>'].concat(pkgs.map(p=>`<option value="${p.id}" ${p.id===selected?'selected':''}>${p.id} — ${p.name}</option>`));
  return opts.join('');
}

function _userPkgIds(u){
  // backward compatible: package_ids[] or package_id
  if(u && Array.isArray(u.package_ids) && u.package_ids.length) return u.package_ids;
  if(u && (u.package_id||'')) return [u.package_id];
  return [];
}

function pkgOptionsHtmlMulti(selectedIds){
  const sel = Array.isArray(selectedIds) ? selectedIds : (selectedIds?[selectedIds]:[]);
  const pkgs = __pkgCache || [];
  const opts = pkgs.map(p=>`<option value="${p.id}" ${sel.includes(p.id)?'selected':''}>${p.id} — ${p.name}</option>`);
  return opts.join('');
}

function pkgPillsHtml(ids){
  const arr = Array.isArray(ids)?ids:[];
  if(!arr.length) return '<span class="muted">-</span>';
  return arr.map(x=>`<span class="badge text-bg-dark me-1">${x}</span>`).join('');
}

function fillProfilePackageSelect(selected){
  const sel = document.getElementById('profilePackage');
  if(!sel) return;
  sel.innerHTML = pkgOptionsHtml(selected||'');
}
function openUserPolicy(username){
  // Ensure packages cache
  loadPackages(()=>{
    apiPost('admin_list_users', {}, (rr)=>{
      const users = rr.users||[];
      const u = users.find(x=>x.username===username) || {};
      const selIds = _userPkgIds(u);
      apiPost('admin_user_usage_today', {username}, (uu)=>{
        const remain = (uu && uu.remain!==undefined) ? uu.remain : '-';
        const limit = (uu && uu.limit!==undefined) ? uu.limit : '-';
        const used = (uu && uu.count!==undefined) ? uu.count : '-';
        Swal.fire({
          title: 'Kullanıcı Politikası',
          html: `
            <div style="text-align:left">
              <div class="muted mb-2"><b>${username}</b> • Bugün: <b>${used}</b> / <b>${limit}</b> • Kalan: <b>${remain}</b></div>
              <div class="row g-2">
                <div class="col-6">
                  <label class="muted" style="font-size:12px">Başlangıç (YYYY-MM-DD)</label>
                  <input id="up_vf" class="swal2-input" style="margin:6px 0" value="${u.valid_from||''}" placeholder="2026-01-23">
                </div>
                <div class="col-6">
                  <label class="muted" style="font-size:12px">Bitiş (YYYY-MM-DD)</label>
                  <input id="up_vt" class="swal2-input" style="margin:6px 0" value="${u.valid_to||''}" placeholder="2026-12-31">
                </div>
                <div class="col-12">
                  <label class="muted" style="font-size:12px">Paket</label>
                  <select id="up_pkg" class="swal2-select" multiple style="width:100%;min-height:120px;padding:10px;border-radius:12px;background:#111;color:#fff;border:1px solid #333">
                    ${pkgOptionsHtmlMulti(selIds)}
                  </select>
                  <div class="muted" style="font-size:12px;margin-top:6px">CTRL ile çoklu seçim yapabilirsiniz.</div>
                </div>
                <div class="col-12">
                  <label class="muted" style="font-size:12px">Günlük Limit (boş = paket)</label>
                  <input id="up_dl" class="swal2-input" style="margin:6px 0" value="${(u.daily_limit===undefined||u.daily_limit===null)?'':u.daily_limit}" placeholder="20">
                </div>
                <div class="col-12 muted" style="font-size:12px;margin-top:6px">
                  Limit: 24 saat içinde toplam patch işlemi sayısıdır (user_patch). Limit dolunca işlem engellenir.
                </div>
              </div>
            </div>
          `,
          showCancelButton:true,
          confirmButtonText:'Kaydet',
          preConfirm: ()=>{
            const sel = Array.from(document.getElementById('up_pkg').selectedOptions||[]).map(o=>o.value).filter(Boolean);
            return {
              username,
              valid_from: document.getElementById('up_vf').value.trim(),
              valid_to: document.getElementById('up_vt').value.trim(),
              package_ids: JSON.stringify(sel),
              daily_limit: document.getElementById('up_dl').value.trim()
            };
          }
        }).then(res=>{
          if(!res.isConfirmed) return;
          apiPost('admin_update_user_policy', res.value, (rx)=>{
            if(rx.status==='ok'){ Swal.fire('OK','Kaydedildi','success'); loadUsers(); }
            else Swal.fire('Hata', rx.msg||'', 'error');
          });
        });
      });
    });
  });
}


function setActiveNav(view){
  $('.navitem').removeClass('active');
  $('.navitem[data-view="'+view+'"]').addClass('active');
  $('[id^="view_"]').hide();
  $('#view_'+view).show();
}


function loadAutoDtc(){
  apiPost('admin_get_auto_dtc_rules', {}, (r)=>{
    if(r.status!=='ok') return;
    const rules = r.rules || {};
    const cats = ['DPF','EGR','LAMBDA','NOX','FLAPS','ADBLUE','TVA','CAT'];
    $('#autoDtcGrid').html(cats.map(c=>{
      const kw = (rules[c] && rules[c].keywords) ? rules[c].keywords.join(',') : '';
      const cd = (rules[c] && rules[c].codes) ? rules[c].codes.join(',') : '';
      return `
      <div class="col-xl-6">
        <div class="cardx p-3">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <div class="fw-bold"><i class="bi bi-magic me-2"></i>${c}</div>
            <span class="tag">AUTO</span>
          </div>
          <label class="muted" style="font-size:12px">Keywords</label>
          <input class="form-control form-control-sm mb-2" data-cat="${c}" data-kind="keywords" value="${(kw||'').replace(/"/g,'&quot;')}" placeholder="dpf, soot, particulate">
          <label class="muted" style="font-size:12px">Codes</label>
          <input class="form-control form-control-sm" data-cat="${c}" data-kind="codes" value="${(cd||'').replace(/"/g,'&quot;')}" placeholder="P2002, P242F">
        </div>
      </div>`;
    }).join(''));
  });
}
function saveAutoDtc(){
  const rules = {};
  $('#autoDtcGrid input').each(function(){
    const cat = String($(this).data('cat')||'').toUpperCase();
    const kind = String($(this).data('kind')||'');
    const val = String($(this).val()||'');
    if(!rules[cat]) rules[cat] = {keywords:[], codes:[]};
    rules[cat][kind] = val.split(',').map(x=>x.trim()).filter(x=>x);
  });
  apiPost('admin_save_auto_dtc_rules', {rules: JSON.stringify(rules)}, (r)=>{
    if(r.status==='ok') Swal.fire({toast:true,position:'top-end',timer:2000,showConfirmButton:false,icon:'success',title:'AUTO DTC kaydedildi'});
    else Swal.fire('Hata', r.msg||'Kaydetme hatası','error');
  });
}

function loadEcuCards(){
  const u = $('#ecuCardUserSel').val() || '';
  apiPost('admin_ecu_cards', {user:u, limit:5000}, (r)=>{
    if(r.status!=='ok') return;
    const cards = r.cards || [];
    const html = cards.map(c=>{
      const up = c.upload || null;
      const pa = c.patch || null;
      const fa = c.fail || null;
      const title = `${c.brand||'-'} • ${c.ecu||'-'}`;
      const prof = c.profile||'-';
      const last = fmtTs(c.last_ts||'');
      return `
      <div class="col-12 col-xl-6">
        <div class="cardx p-3">
          <div class="d-flex align-items-start justify-content-between">
            <div>
              <div class="fw-bold" style="font-size:16px">${title}</div>
              <div class="muted" style="font-size:12px">${c.user||''} • ${prof}</div>
            </div>
            <span class="tag">${last}</span>
          </div>

          <div class="row g-2 mt-2">
            <div class="col-md-6">
              <div class="softbox p-2">
                <div class="muted" style="font-size:12px"><i class="bi bi-upload me-1"></i>Upload</div>
                ${up ? `
                  <div><b>${(up.file||'').slice(0,40)}</b></div>
                  <div class="muted" style="font-size:12px">OEM:${up.oem_count||0} • OBD2:${up.obd2_count||0}</div>
                  <div class="muted" style="font-size:12px">SIM:${up.similarity??'-'} • ADDR:${up.addr_score??'-'}</div>
                ` : `<div class="muted">-</div>`}
              </div>
            </div>

            <div class="col-md-6">
              <div class="softbox p-2">
                <div class="muted" style="font-size:12px"><i class="bi bi-wrench-adjustable me-1"></i>Patch</div>
                ${pa ? `
                  <div class="muted" style="font-size:12px">OFF Groups: <b>${pa.off_groups||0}</b> • OFF Rows: <b>${pa.off_rows||0}</b></div>
                  <div class="muted" style="font-size:12px">OUT: ${(pa.file_out||'').slice(0,40)}</div>
                ` : `<div class="muted">-</div>`}
              </div>
            </div>

            <div class="col-12">
              <div class="softbox p-2" style="border-color: rgba(255,90,120,.25)">
                <div class="muted" style="font-size:12px"><i class="bi bi-exclamation-triangle me-1"></i>Son Hata</div>
                ${fa ? `
                  <div><b>${fa.reason||''}</b> <span class="muted" style="font-size:12px">${fmtTs(fa.ts||'')}</span></div>
                  <div class="muted" style="font-size:12px">${fa.msg||''}</div>
                ` : `<div class="muted">-</div>`}
              </div>
            </div>
          </div>
        </div>
      </div>`;
    }).join('');
    $('#ecuCards').html(html || `<div class="muted">Kayıt yok</div>`);
  });
}

$('.navitem').on('click', function(e){
  e.preventDefault();
  const v = $(this).data('view');
  setActiveNav(v);
  if(v==='dash') loadDashboard();
  if(v==='users') loadUsers();
  if(v==='activity') loadActivity();
  if(v==='library') loadLibrary();
  if(v==='packages') loadPackagesView();
  if(v==='auto_dtc') loadAutoDtc();
});

$('#btnLogout').on('click', function(e){
  e.preventDefault();
  apiPost('logout', {}, ()=>location.href='login.php');
});

$('#btnRefreshDash').on('click', loadDashboard);
$('#btnRefreshUsers').on('click', loadUsers);
$('#btnRefreshActivity').on('click', loadActivity);
$('#btnAutoDtcReload').on('click', loadAutoDtc);
$('#btnAutoDtcSave').on('click', saveAutoDtc);
$('#btnEcuCardsRefresh').on('click', loadEcuCards);

$('#btnRefreshLibrary').on('click', loadLibrary);
$('#btnRefreshPkg').on('click', loadPackagesView);

function loadDashboard(){
  apiPost('admin_profiles_detailed', {}, (r)=>{
    if(r.status!=='ok') return;
    const p = r.profiles || [];
    $('#kpiProfiles').text(p.length);
    const rows = p.slice(-8).reverse();
    $('#dashProfiles').html(rows.map((it,idx)=>{
      return `<tr><td>${it.id}</td><td>${it.name||''}</td><td>${it.brand||''}</td><td>${it.ecu_model||''}</td><td class="muted">${it.size||0}</td></tr>`;
    }).join('') || `<tr><td colspan="5" class="muted">Kayıt yok</td></tr>`);
  });

  apiPost('admin_list_users', {}, (r)=>{
    if(r.status!=='ok') return;
    const u = r.users||[];
    $('#kpiUsers').text(u.length);
  });

  apiPost('admin_audit_recent', {limit: 10}, (r)=>{
    const rows = r.rows||[];
    $('#dashLastActions').html(rows.map(it=>{
      const det = it.details ? safeJson(it.details).slice(0,60) : '';
      return `<tr><td class="muted">${fmtTs(it.ts)}</td><td>${it.user||''}</td><td>${it.action||''}</td><td class="muted">${det}</td></tr>`;
    }).join('') || `<tr><td colspan="4" class="muted">Kayıt yok</td></tr>`);

    // KPI 24h
    const now = Date.now();
    let c24=0;
    rows.forEach(()=>{}); // noop
    apiPost('admin_audit_recent', {limit: 200}, (rr)=>{
      const all = rr.rows||[];
      all.forEach(it=>{
        const t = Date.parse(it.ts||'');
        if(!isNaN(t) && (now - t) <= 24*3600*1000) c24++;
      });
      $('#kpiActions24').text(c24);
    });
  });

  apiPost('admin_audit_logins', {limit: 20}, (r)=>{
    const rows = r.rows||[];
    $('#dashLogins').html(rows.map(it=>{
      return `<tr><td class="muted">${fmtTs(it.ts)}</td><td>${it.user||''}</td><td>${it.action||''}</td><td class="muted">${it.ip||''}</td></tr>`;
    }).join('') || `<tr><td colspan="4" class="muted">Kayıt yok</td></tr>`);

    // KPI today logins
    const today = new Date(); today.setHours(0,0,0,0);
    let c=0;
    rows.forEach(it=>{
      const t = Date.parse(it.ts||'');
      if(!isNaN(t) && t>=today.getTime() && it.action==='login') c++;
    });
    $('#kpiLogins').text(c);
  });
}

function loadUsers(){
  apiPost('admin_list_users', {}, (r)=>{
    if(r.status!=='ok') return;
    const rows = r.users||[];
    $('#usersTable').html(rows.map(it=>{
      const active = (it.active ?? true);
      return `<tr>
        <td><b>${it.username||''}</b><div class="muted" style="font-size:12px">created: ${(it.created_at||'').replace('T',' ').replace('Z','')}</div></td>
        <td>${it.role||''}</td>
        <td>${active?'<span class="badge text-bg-success">aktif</span>':'<span class="badge text-bg-secondary">pasif</span>'}</td>
        <td class="muted">${it.valid_from||''}</td>
        <td class="muted">${it.valid_to||''}</td>
        <td>${pkgPillsHtml(_userPkgIds(it))}</td>
        <td class="muted">${(it.daily_limit===undefined||it.daily_limit===null||it.daily_limit==='')?'<span class="muted">paket</span>':it.daily_limit}</td>
        <td><span class="badge text-bg-dark" id="remain_${it.username}">-</span></td>
        <td class="text-end">
          <button class="btn btn-soft btn-sm" onclick="openUserPolicy('${it.username}')"><i class="bi bi-sliders2"></i> Politika</button>
          <button class="btn btn-soft btn-sm" onclick="toggleUser('${it.username}', ${active?0:1})">${active?'Pasif Yap':'Aktif Yap'}</button>
          <button class="btn btn-danger btn-sm" onclick="deleteUser('${it.username}')">Sil</button>
        </td>
      </tr>`;
    }).join('') || `<tr><td colspan="9" class="muted">Kullanıcı yok</td></tr>`);
    // fill selector for activity view
    $('#auditUserSel').html(rows.map(u=>`<option value="${u.username}">${u.username} (${u.role})</option>`).join(''));
    // ECU cards filter
    $('#ecuCardUserSel').html(`<option value="">Tümü</option>` + rows.map(u=>`<option value="${u.username}">${u.username}</option>`).join(''));
    // usage badges
    rows.forEach(u=>{
      apiPost('admin_user_usage_today', {username:u.username}, (uu)=>{
        if(!uu || uu.status!=='ok') return;
        const el = document.getElementById('remain_'+u.username);
        if(!el) return;
        if(uu.limit && uu.limit>0) el.textContent = (uu.remain + ' / ' + uu.limit);
        else el.textContent = '∞';
      });
    });
  });
}
function toggleUser(username, active){
  apiPost('admin_toggle_user', {username, active}, (r)=>{
    if(r.status==='ok') loadUsers();
  });
}
function deleteUser(username){
  Swal.fire({title:'Sil?', text: username, icon:'warning', showCancelButton:true, confirmButtonText:'Sil'}).then(res=>{
    if(!res.isConfirmed) return;
    apiPost('admin_delete_user', {username}, (r)=>{ if(r.status==='ok') loadUsers(); });
  });
}
$('#btnAddUser').on('click', ()=>{
  Swal.fire({
    title:'Kullanıcı Ekle',
    html: `
      <input id="nu" class="swal2-input" placeholder="Kullanıcı adı">
      <input id="np" class="swal2-input" placeholder="Şifre">
      <select id="nr" class="swal2-select" style="width:85%;padding:10px;border-radius:10px;background:#111;color:#fff;border:1px solid #333">
        <option value="user">user</option>
        <option value="admin">admin</option>
      </select>
    `,
    focusConfirm:false,
    preConfirm: ()=>{
      return {u: document.getElementById('nu').value.trim(), p: document.getElementById('np').value, r: document.getElementById('nr').value};
    },
    showCancelButton:true,
    confirmButtonText:'Ekle'
  }).then(res=>{
    if(!res.isConfirmed) return;
    apiPost('admin_add_user', {username:res.value.u, password:res.value.p, role:res.value.r}, (r)=>{
      if(r.status==='ok'){ loadUsers(); Swal.fire('OK','Eklendi','success'); }
      else Swal.fire('Hata', r.msg||'','error');
    });
  });
});

function loadActivity(){
  apiPost('admin_audit_recent', {limit: 80}, (r)=>{
    const rows = r.rows||[];
    $('#auditRecent').html(rows.map(it=>{
      return `<tr><td class="muted">${fmtTs(it.ts)}</td><td>${it.user||''}</td><td class="muted">${it.role||''}</td><td>${it.action||''}</td><td class="muted">${it.ip||''}</td></tr>`;
    }).join('') || `<tr><td colspan="5" class="muted">Kayıt yok</td></tr>`);
  });
  // refresh user list for selector
  loadUsers();
  setTimeout(loadEcuCards, 150);
}
$('#btnLoadUserLast').on('click', ()=>{
  const u = $('#auditUserSel').val();
  apiPost('admin_audit_user_last', {username:u, limit: 10}, (r)=>{
    const rows = r.rows||[];
    $('#auditUserLast').html(rows.map(it=>`<tr><td class="muted">${fmtTs(it.ts)}</td><td>${it.action||''}</td></tr>`).join('') || `<tr><td colspan="2" class="muted">Kayıt yok</td></tr>`);
  });
});

let __libCache = [];
function loadLibrary(){
  loadPackages(()=>{
  apiPost('admin_library_stats', {}, (r)=>{
    const rows = r.brands||[];
    $('#kpiProfiles').text(r.total_profiles||'-');
    $('#libStats').html(rows.map(it=>`<tr><td>${it.brand}</td><td>${it.profiles}</td><td class="muted">${it.code_count}</td></tr>`).join('') || `<tr><td colspan="3" class="muted">Kayıt yok</td></tr>`);
  });
  apiPost('admin_profiles_detailed', {}, (r)=>{
    if(r.status!=='ok') return;
    __libCache = r.profiles||[];
    renderLibraryTable(__libCache);
  });
  });
}
function renderLibraryTable(list){
  $('#libTable').html(list.map(it=>{
    return `<tr>
      <td>${it.id}</td>
      <td><b>${it.name||''}</b></td>
      <td><input class="form-control form-control-sm" value="${(it.brand||'').replace(/"/g,'&quot;')}" onchange="updMeta(${it.id}, this.value, null, null)"></td>
      <td><input class="form-control form-control-sm" value="${(it.ecu_model||'').replace(/"/g,'&quot;')}" onchange="updMeta(${it.id}, null, this.value, null)"></td>
      <td><select class="form-select form-select-sm" onchange="updMeta(${it.id}, null, null, null, this.value)">${pkgOptionsHtml(it.package_id||"")}</select></td>
      <td class="muted">${it.size||0}</td>
      <td class="muted">${it.read_tables_count||0}</td>
      <td class="muted">${it.patch_tables_count||0}</td>
      <td class="text-end">
        <button class="btn btn-soft btn-sm" onclick="editGroup(${it.id}, '${(it.brand_group||'').replace(/'/g,'&#39;')}')">Grup</button>
        <button class="btn btn-danger btn-sm" onclick="delProfile(${it.id})">Sil</button>
      </td>
    </tr>`;
  }).join('') || `<tr><td colspan="9" class="muted">Kayıt yok</td></tr>`);
}
function updMeta(id, brand, ecu, grp, pkg){
  const cur = __libCache.find(x=>x.id==id) || {};
  const payload = {id};
  payload.brand = (brand===null? (cur.brand||'') : brand);
  payload.ecu_model = (ecu===null? (cur.ecu_model||'') : ecu);
  payload.brand_group = (grp===null? (cur.brand_group||'') : grp);
  payload.package_id = (pkg===null? (cur.package_id||'') : pkg);
  apiPost('admin_profile_update_meta', payload, (r)=>{
    if(r.status==='ok'){ /* ok */ }
  });
}
function editGroup(id, current){
  Swal.fire({title:'Brand Group', input:'text', inputValue: current||'', showCancelButton:true}).then(res=>{
    if(!res.isConfirmed) return;
    updMeta(id, null, null, res.value);
  });
}
function delProfile(id){
  Swal.fire({title:'Sil?', text:'Profil #'+id, icon:'warning', showCancelButton:true, confirmButtonText:'Sil'}).then(res=>{
    if(!res.isConfirmed) return;
    apiPost('delete_profile', {id}, (r)=>{ if(r.status==='ok') loadLibrary(); });
  });
}
$('#libSearch').on('input', function(){
  const q = $(this).val().toLowerCase().trim();
  if(!q){ renderLibraryTable(__libCache); return; }
  renderLibraryTable(__libCache.filter(it=>{
    return (it.name||'').toLowerCase().includes(q) || (it.brand||'').toLowerCase().includes(q) || (it.ecu_model||'').toLowerCase().includes(q);
  }));
});


// -----------------------------
// PACKAGES VIEW (CRUD)
// -----------------------------
function renderPackagesTable(list){
  const tb = $('#pkgTable');
  const rows = (list||[]).map(p=>{
    const act = (p.active===false)?'<span class="badge text-bg-secondary">pasif</span>':'<span class="badge text-bg-success">aktif</span>';
    const brands = (p.allowed_brands||[]).join(', ');
    const groups = (p.allowed_brand_groups||[]).join(', ');
    return `<tr>
      <td><b>${p.id||''}</b></td>
      <td>${p.name||''}</td>
      <td>${act}</td>
      <td class="muted">${(p.daily_limit??'')}</td>
      <td class="muted" style="max-width:240px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis" title="${brands.replace(/"/g,'&quot;')}">${brands||'-'}</td>
      <td class="muted" style="max-width:220px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis" title="${groups.replace(/"/g,'&quot;')}">${groups||'-'}</td>
      <td class="text-end">
        <button class="btn btn-soft btn-sm" onclick="editPackage('${(p.id||'').replace(/'/g,'&#39;')}')"><i class="bi bi-pencil"></i> Düzenle</button>
        <button class="btn btn-danger btn-sm" onclick="deletePackage('${(p.id||'').replace(/'/g,'&#39;')}')">Sil</button>
      </td>
    </tr>`;
  }).join('');
  tb.html(rows || `<tr><td colspan="7" class="muted">Paket yok</td></tr>`);
}
function loadPackagesView(){
  loadPackages((list)=>{
    renderPackagesTable(list);
    // also refresh profile-package selector in Teach view
    fillProfilePackageSelect($('#profilePackage').val()||'');
  });
}
function openPackageModal(mode, pkg){
  pkg = pkg || {};
  const isEdit = (mode==='edit');
  Swal.fire({
    title: isEdit ? 'Paketi Düzenle' : 'Yeni Paket',
    html: `
      <div style="text-align:left">
        <label class="muted" style="font-size:12px">Paket ID</label>
        <input id="pkg_id" class="swal2-input" style="margin:6px 0" ${isEdit?'readonly':''} value="${(pkg.id||'')}" placeholder="PRO">
        <label class="muted" style="font-size:12px">Ad</label>
        <input id="pkg_name" class="swal2-input" style="margin:6px 0" value="${(pkg.name||'')}" placeholder="Pro Paket">
        <div class="row g-2">
          <div class="col-6">
            <label class="muted" style="font-size:12px">Günlük Limit</label>
            <input id="pkg_daily" class="swal2-input" style="margin:6px 0" value="${(pkg.daily_limit??'')}" placeholder="20">
          </div>
          <div class="col-6">
            <label class="muted" style="font-size:12px">Durum</label>
            <select id="pkg_active" class="swal2-select" style="width:100%;padding:10px;border-radius:12px;background:#111;color:#fff;border:1px solid #333">
              <option value="1" ${(pkg.active===false)?'':'selected'}>Aktif</option>
              <option value="0" ${(pkg.active===false)?'selected':''}>Pasif</option>
            </select>
          </div>
          <div class="col-12">
            <label class="muted" style="font-size:12px">Allowed Brands (virgülle)</label>
            <input id="pkg_brands" class="swal2-input" style="margin:6px 0" value="${((pkg.allowed_brands||[]).join(', ')).replace(/"/g,'&quot;')}" placeholder="VW, AUDI, SKODA">
          </div>
          <div class="col-12">
            <label class="muted" style="font-size:12px">Allowed Groups (virgülle)</label>
            <input id="pkg_groups" class="swal2-input" style="margin:6px 0" value="${((pkg.allowed_brand_groups||[]).join(', ')).replace(/"/g,'&quot;')}" placeholder="VAG GRUBU, PSA GRUBU">
          </div>
          <div class="col-12">
            <label class="muted" style="font-size:12px">Not</label>
            <input id="pkg_notes" class="swal2-input" style="margin:6px 0" value="${(pkg.notes||'').replace(/"/g,'&quot;')}" placeholder="...">
          </div>
        </div>
      </div>
    `,
    showCancelButton:true,
    confirmButtonText: isEdit ? 'Güncelle' : 'Ekle',
    preConfirm: ()=>{
      const id = document.getElementById('pkg_id').value.trim();
      const name = document.getElementById('pkg_name').value.trim();
      const daily = document.getElementById('pkg_daily').value.trim();
      const active = document.getElementById('pkg_active').value==='1' ? 1 : 0;
      const brands = document.getElementById('pkg_brands').value.split(',').map(x=>x.trim()).filter(Boolean).join(',');
      const groups = document.getElementById('pkg_groups').value.split(',').map(x=>x.trim()).filter(Boolean).join(',');
      const notes = document.getElementById('pkg_notes').value.trim();
      if(!id){ Swal.showValidationMessage('Paket ID gerekli'); return false; }
      if(!name){ Swal.showValidationMessage('Paket adı gerekli'); return false; }
      return {id,name,daily_limit:daily,active,allowed_brands:brands,allowed_brand_groups:groups,notes};
    }
  }).then(res=>{
    if(!res.isConfirmed) return;
    const v = res.value||{};
    const action = isEdit ? 'admin_update_package' : 'admin_add_package';
    apiPost(action, v, (r)=>{
      if(r.status==='ok'){
        Swal.fire('OK', isEdit?'Güncellendi':'Eklendi', 'success');
        loadPackagesView();
      } else Swal.fire('Hata', r.msg||'','error');
    });
  });
}
function editPackage(id){
  const p = (__pkgCache||[]).find(x=>x.id===id) || null;
  if(!p) return;
  openPackageModal('edit', p);
}
function deletePackage(id){
  Swal.fire({title:'Sil?', text:id, icon:'warning', showCancelButton:true, confirmButtonText:'Sil'}).then(res=>{
    if(!res.isConfirmed) return;
    apiPost('admin_delete_package', {id}, (r)=>{
      if(r.status==='ok'){ loadPackagesView(); Swal.fire('OK','Silindi','success'); }
      else Swal.fire('Hata', r.msg||'', 'error');
    });
  });
}
$('#btnAddPkg').on('click', ()=> openPackageModal('add', {}));

// -----------------------------
// SIMPLE CANVAS CHARTS (no libs)
// -----------------------------
function _ctx(id){
  const c = document.getElementById(id);
  if(!c) return null;
  const dpr = window.devicePixelRatio||1;
  // make sure canvas matches CSS size
  const w = c.getBoundingClientRect().width;
  const h = c.getAttribute('height') ? parseInt(c.getAttribute('height'),10) : c.getBoundingClientRect().height;
  c.width = Math.max(1, Math.floor(w*dpr));
  c.height = Math.max(1, Math.floor(h*dpr));
  const ctx = c.getContext('2d');
  ctx.setTransform(dpr,0,0,dpr,0,0);
  return {c,ctx,w,h};
}

function drawLineChart(id, a, b, labels){
  const o = _ctx(id); if(!o) return;
  const {ctx,w,h} = o;
  ctx.clearRect(0,0,w,h);
  // grid
  ctx.globalAlpha = 0.25;
  ctx.strokeStyle = 'white';
  ctx.lineWidth = 1;
  for(let i=0;i<=4;i++){
    const y = 16 + (h-36)*i/4;
    ctx.beginPath(); ctx.moveTo(14,y); ctx.lineTo(w-14,y); ctx.stroke();
  }
  ctx.globalAlpha = 1;

  const maxV = Math.max(1, ...a, ...b);
  const padL = 18, padR = 14, padT = 12, padB = 24;
  const X = (i,n)=> padL + (w-padL-padR)*(n<=1?0:i/(n-1));
  const Y = (v)=> padT + (h-padT-padB) * (1 - (v/maxV));

  function _line(arr, stroke){
    ctx.lineWidth = 3;
    ctx.strokeStyle = stroke;
    ctx.beginPath();
    arr.forEach((v,i)=>{ const x=X(i,arr.length), y=Y(v); if(i===0) ctx.moveTo(x,y); else ctx.lineTo(x,y); });
    ctx.stroke();
  }

  _line(a, '#2a7fff');
  _line(b, '#ff7a2a');

  // labels
  if(labels && labels.length){
    ctx.fillStyle = 'rgba(255,255,255,.55)';
    ctx.font = '12px ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial';
    labels.forEach((t,i)=>{ ctx.fillText(t, X(i,labels.length)-6, h-8); });
  }
}

function drawBarChart(id, arr, labels){
  const o = _ctx(id); if(!o) return;
  const {ctx,w,h} = o;
  ctx.clearRect(0,0,w,h);
  const maxV = Math.max(1,...arr);
  const padL=18,padR=14,padT=12,padB=24;
  const n = arr.length;
  const slot = (w-padL-padR)/n;
  const bw = Math.max(10, slot*0.42);
  arr.forEach((v,i)=>{
    const x = padL + i*slot + (slot-bw)/2;
    const hh = (h-padT-padB)*(v/maxV);
    const y = padT + (h-padT-padB) - hh;
    // gradient like rocker
    const g = ctx.createLinearGradient(0,y,0,y+hh);
    g.addColorStop(0,'#ff3b6a');
    g.addColorStop(1,'#ff8a00');
    ctx.fillStyle = g;
    ctx.beginPath();
    const r = 6;
    ctx.moveTo(x, y+hh);
    ctx.lineTo(x, y+r);
    ctx.quadraticCurveTo(x, y, x+r, y);
    ctx.lineTo(x+bw-r, y);
    ctx.quadraticCurveTo(x+bw, y, x+bw, y+r);
    ctx.lineTo(x+bw, y+hh);
    ctx.closePath();
    ctx.fill();
  });
  if(labels && labels.length){
    ctx.fillStyle = 'rgba(255,255,255,.55)';
    ctx.font = '12px ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial';
    labels.forEach((t,i)=>{ ctx.fillText(t, padL + i*slot + (slot/2)-8, h-8); });
  }
}

function renderDashboardCharts(){
  // simple demo series (we will refresh after dashboard loads)
  const labels = ['Mo','Tu','We','Th','Fr','Sa','Su'];
  const a = [6,22,14,18,9,12,10];
  const b = [5,15,12,11,14,8,9];
  drawLineChart('chartActivity', a, b, labels);
  drawBarChart('chartBars', [8,6,14,9,12,7], ['Jan','Feb','Mar','Apr','May','Jun']);
}

// sidebar toggle
$('#btnToggleSidebar').on('click', function(){
  $('body').toggleClass('sb-collapsed');
  setTimeout(()=>{ renderDashboardCharts(); }, 180);
});

// initial
$(function(){
  setActiveNav('dash');
  loadDashboard();
  renderDashboardCharts();
  loadPackages(()=>{ fillProfilePackageSelect(''); });
  $(window).on('resize', function(){ renderDashboardCharts(); });
});
</script>

</body>
</html
      <div class="cardx mt-3">
        <div class="card-header p-3 d-flex align-items-center justify-content-between">
          <div class="fw-bold">ECU İşlem Kartları</div>
          <div class="d-flex gap-2" style="min-width:360px">
            <select class="form-select form-select-sm" id="ecuCardUserSel"></select>
            <button class="btn btn-soft btn-sm" id="btnEcuCardsRefresh">Yenile</button>
          </div>
        </div>
        <div class="p-3" id="ecuCardsWrap">
          <div class="row g-3" id="ecuCards"></div>
        </div>
      </div>
>