<?php
session_start();
require_once __DIR__ . '/config.php';
ensure_schema();
require_user();
$pdo=db();
$st=$pdo->prepare("SELECT * FROM requests WHERE user_id=? ORDER BY id DESC LIMIT 200");
$st->execute([(int)$_SESSION['user_id']]);
$rows=$st->fetchAll();
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo h(APP_NAME); ?> • My Requests</title>
<link rel="stylesheet" href="<?php echo h(BASE_URL); ?>/assets/css/app.css"></head>
<body class="frameGlow"><div class="bgDots"></div><div class="network"></div>
<div style="max-width:1100px;margin:6vh auto;padding:24px;position:relative;z-index:2">
  <div class="card">
    <div class="cardHeader"><div class="cardTitle"><span class="ico"></span> My Requests</div><a class="badge teal" href="request_new.php">+ New Request</a></div>
    <div class="body">
      <table style="width:100%;border-collapse:collapse">
        <tr style="color:rgba(155,176,208,.85);font-size:12px;text-transform:uppercase;letter-spacing:.12em">
          <th align="left">ID</th><th align="left">Vehicle</th><th align="left">ECU</th><th align="left">Status</th><th align="left">Total</th><th></th>
        </tr>
        <?php foreach($rows as $r): ?>
        <tr>
          <td style="padding:10px 0;border-bottom:1px solid rgba(255,255,255,.06)">#<?php echo (int)$r['id']; ?></td>
          <td style="border-bottom:1px solid rgba(255,255,255,.06)"><?php echo h($r['manufacturer'].' '.$r['model']); ?></td>
          <td style="border-bottom:1px solid rgba(255,255,255,.06)"><?php echo h($r['ecu']); ?></td>
          <td style="border-bottom:1px solid rgba(255,255,255,.06)"><span class="badge"><?php echo h($r['status']); ?></span></td>
          <td style="border-bottom:1px solid rgba(255,255,255,.06)"><b><?php echo h(number_format((float)$r['total_credit'],2)); ?></b> CR</td>
          <td style="border-bottom:1px solid rgba(255,255,255,.06)"><a class="badge teal" href="request_view.php?id=<?php echo (int)$r['id']; ?>">View</a></td>
        </tr>
        <?php endforeach; ?>
      </table>
      <div class="note"><a href="logout.php">Logout</a></div>
    </div>
  </div>
</div>
</body></html>
