<?php
session_start();
require_once __DIR__ . '/config.php';
ensure_schema();
require_user();
$pdo=db();
$id=(int)($_GET['id']??0);
$st=$pdo->prepare("SELECT * FROM requests WHERE id=? AND user_id=? LIMIT 1");
$st->execute([$id,(int)$_SESSION['user_id']]);
$r=$st->fetch();
if(!$r){ http_response_code(404); echo "Not found"; exit; }
$mods=$pdo->prepare("SELECT m.* FROM request_mods rm JOIN modifications m ON m.id=rm.mod_id WHERE rm.request_id=? ORDER BY m.category,m.sort_order,m.id");
$mods->execute([$id]);
$ml=$mods->fetchAll();
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo h(APP_NAME); ?> • Request #<?php echo (int)$r['id']; ?></title>
<link rel="stylesheet" href="<?php echo h(BASE_URL); ?>/assets/css/app.css"></head>
<body class="frameGlow"><div class="bgDots"></div><div class="network"></div>
<div style="max-width:1200px;margin:5vh auto;padding:24px;position:relative;z-index:2">
  <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap">
    <div><div class="h1">Request #<?php echo (int)$r['id']; ?></div><div class="subtitle"><?php echo h($r['manufacturer'].' '.$r['model'].' • '.$r['ecu']); ?></div></div>
    <a class="badge teal" href="dashboard.php">Back</a>
  </div>
  <div class="grid2" style="margin-top:16px">
    <div class="card">
      <div class="cardHeader"><div class="cardTitle"><span class="ico"></span> Vehicle Information</div></div>
      <div class="body">
        <div class="row">
          <div class="field"><label>Make & Model</label><div class="input"><?php echo h($r['manufacturer'].' '.$r['model']); ?></div></div>
          <div class="field"><label>Engine</label><div class="input"><?php echo h($r['engine']?:'-'); ?></div></div>
        </div>
        <div class="row">
          <div class="field"><label>ECU Type</label><div class="input"><?php echo h($r['ecu']); ?></div></div>
          <div class="field"><label>Device</label><div class="input"><?php echo h($r['device']?:'-'); ?></div></div>
        </div>
        <div class="field"><label>Requested Modifications</label>
          <div class="input" style="height:auto">
            <?php if(!$ml): ?><small>No options selected.</small>
            <?php else: foreach($ml as $m): ?>
              <span class="badge teal" style="margin:4px 6px 0 0;display:inline-flex"><?php echo h($m['name']); ?> • <?php echo h(number_format((float)$m['credit'],2)); ?> CR</span>
            <?php endforeach; endif; ?>
          </div>
        </div>
        <div class="field"><label>Notes</label><div class="input" style="height:auto"><?php echo nl2br(h($r['notes']?:'-')); ?></div></div>
      </div>
    </div>
    <div class="card">
      <div class="cardHeader"><div class="cardTitle"><span class="ico"></span> Request Summary</div><span class="badge warn"><?php echo h($r['status']); ?></span></div>
      <div class="body">
        <div style="display:flex;justify-content:space-between;align-items:baseline;padding:12px;border-radius:16px;border:1px solid rgba(255,255,255,.08);background:rgba(255,255,255,.03)">
          <div>Total Cost</div><div style="font-weight:950;font-size:24px"><?php echo h(number_format((float)$r['total_credit'],2)); ?> <span style="font-size:12px;color:rgba(155,176,208,.85)">CR</span></div>
        </div>
        <div class="hr"></div>
        <div class="row">
          <div class="field"><label>Priority</label><div class="input"><?php echo h($r['priority']); ?></div></div>
          <div class="field"><label>Submitted</label><div class="input"><?php echo h($r['created_at']); ?></div></div>
        </div>
        <div class="field"><label>Uploaded File</label><div class="input"><?php echo h($r['original_filename']); ?></div><small>Stored: <?php echo h($r['stored_filename']); ?></small></div>
        <div class="hr"></div>
        <div class="row">
          <div class="field"><label>Payment</label><div class="input"><?php echo h($r['payment_status']??'UNPAID'); ?></div></div>
          <div class="field"><label>Admin Price</label><div class="input"><?php echo h($r['admin_price']===null?'-':$r['admin_price']); ?></div></div>
        </div>
        <div class="row" style="gap:12px;flex-wrap:wrap">
          <a class="btnLink" href="<?php echo h(BASE_URL); ?>/download.php?type=ori&id=<?php echo (int)$r['id']; ?>" style="flex:1;justify-content:center">Download ORI</a>
          <?php if(($r['status']??'')==='COMPLETED' && !empty($r['result_stored_filename'])): ?>
            <a class="btnLink" href="<?php echo h(BASE_URL); ?>/download.php?type=mod&id=<?php echo (int)$r['id']; ?>" style="flex:1;justify-content:center">Download MOD</a>
          <?php else: ?>
            <div class="btnLink" style="flex:1;justify-content:center;opacity:.55;cursor:not-allowed">MOD not ready</div>
          <?php endif; ?>
        </div>

      </div>
    </div>
  </div>
</div>
</body></html>
