<div class="kpis">
  <div class="card span3 kpiGlowB"><div class="kpi"><h3>Toplam Kullanıcı</h3><div class="val" id="kpiUsersTotal">—</div><div class="sub">panel_users</div></div></div>
  <div class="card span3 kpiGlowG"><div class="kpi"><h3>Aktif</h3><div class="val" id="kpiUsersActive">—</div><div class="sub">Normal + Hızlı</div></div></div>
  <div class="card span3 kpiGlowY"><div class="kpi"><h3>Süresi Yaklaşan</h3><div class="val" id="kpiUsersExpSoon">—</div><div class="sub">7 gün</div></div></div>
  <div class="card span3 kpiGlowR"><div class="kpi"><h3>Pasif</h3><div class="val" id="kpiUsersInactive">—</div><div class="sub">Bitiş geçmiş</div></div></div>
</div>



<div class="usersNavBar">
  <div class="usersNavInner">
    <a class="uNavItem active" href="?p=users">
      <span class="dot g"></span><span>Kullanıcılar</span>
    </a>
    <a class="uNavItem " href="?p=bans">
      <span class="dot r"></span><span>Ban Sistemi</span>
    </a>
    <a class="uNavItem " href="?p=user_logs">
      <span class="dot b"></span><span>Loglar</span>
    </a>
    <div class="uNavHint">Kullanıcı yönetimi • ban • audit log</div>
  </div>
</div>
<div class="card">
  <div class="panelHd">
    <h2>Kullanıcılar</h2>
    <div class="actions">
      <span class="chip">DONGLE doğrulama</span>
      <span class="badge b">STEP</span>
    </div>
  </div>

  <div class="pad">
    <div class="usersToolbar">
      <div class="usersLeft">
        <div class="dtcSearch" style="min-width:340px;">
          <span class="ico">⌕</span>
          <input id="userSearch" placeholder="Ara: isim, email, telefon, dongle..." />
        </div>

        <button class="btnSmall" onclick="openCountryPicker()">Ülke (Seç)</button>

        <select id="supportStatus" class="select">
          <option value="">Tümü (Destek)</option>
          <option value="Normal">Normal</option>
          <option value="Hizli">Hızlı</option>
        </select>
      </div>

      <div class="usersRight">
        <select id="pageSize" class="select">
          <option value="10">10 / sayfa</option>
          <option value="25">25 / sayfa</option>
          <option value="50" selected>50 / sayfa</option>
          <option value="100">100 / sayfa</option>
        </select>
        <button class="btn" onclick="openUserForm()">+ Yeni Kullanıcı</button>
      </div>
    </div>

    <div class="chipRow" id="countryChips" style="margin-top:10px;"></div>
  </div>

  <div class="tableWrap">
    <table id="usersTable">
      <thead>
        <tr>
          <th style="width:84px;">ID</th>
          <th>İsim Soyisim</th>
          <th>E-mail</th>
          <th>Telefon</th>
          <th>Password</th>
          <th>Adres</th>
          <th>Ülke</th>
          <th>Dongle Seri No</th>
          <th>Kullanıcı Paketi</th>
          <th>Başlangıç</th>
          <th>Bitiş</th>
          <th>Destek</th>
          <th style="width:86px;">Detay</th>
        </tr>
      </thead>
      <tbody id="usersBody"></tbody>
    </table>
  </div>

  <div class="pad" style="display:flex;align-items:center;justify-content:space-between;gap:12px;flex-wrap:wrap;">
    <div class="muted" id="usersInfo">—</div>
    <div class="pager">
      <button class="btnSmall" id="prevPage">‹ Önce</button>
      <span class="muted" id="pageLabel" style="font-size:12px;">—</span>
      <button class="btnSmall" id="nextPage">Sonra ›</button>
    </div>
  </div>
</div>

<!-- Country Picker Modal -->
<div class="modal" id="countryModal" aria-hidden="true">
  <div class="modalBackdrop" onclick="closeCountryPicker()"></div>
  <div class="modalCard">
    <div class="modalHd">
      <div>
        <div class="modalTitle">Ülke Seçimi</div>
        <div class="muted" style="font-size:12px;">Tüm ülkeler listesi • Çoklu seçim (checkbox)</div>
      </div>
      <button class="btnSmall ghost" onclick="closeCountryPicker()">Kapat ✕</button>
    </div>

    <div class="pad">
      <div class="usersToolbar" style="margin:0;">
        <div class="dtcSearch" style="min-width:420px;">
          <span class="ico">⌕</span>
          <input id="countrySearch" placeholder="Ülke ara..." />
        </div>
        <div style="display:flex;gap:8px;flex-wrap:wrap;">
          <button class="btnSmall" onclick="countrySelectAll(true)">Hepsini Seç</button>
          <button class="btnSmall ghost" onclick="countrySelectAll(false)">Temizle</button>
          <button class="btnSmall" onclick="applyCountryFilter()">Uygula</button>
        </div>
      </div>
    </div>

    <div class="pad" style="padding-top:0;">
      <div class="countryGrid" id="countryGrid"></div>
    </div>
  </div>
</div>

<!-- User Form Modal -->
<div class="modal" id="userFormModal" aria-hidden="true">
  <div class="modalBackdrop" onclick="closeUserForm()"></div>
  <div class="modalCard">
    <div class="modalHd">
      <div>
        <div class="modalTitle" id="ufTitle">Yeni Kullanıcı</div>
        <div class="muted" id="ufSub" style="font-size:12px;">Form</div>
      </div>
      <button class="btnSmall ghost" onclick="closeUserForm()">Kapat ✕</button>
    </div>

    <div class="pad">
      <form id="userForm" onsubmit="return saveUserForm(event)">
        <div class="formGrid">
          <div class="field"><label>İsim Soyisim</label><input id="fName" required /></div>
          <div class="field"><label>E-mail</label><input id="fEmail" type="email" required /></div>
          <div class="field"><label>Telefon</label><input id="fPhone" /></div>
          <div class="field"><label>Password</label><input id="fPass" type="text" /></div>

          <div class="field span12"><label>Adres</label><input id="fAddress" /></div>

          <div class="field"><label>Ülke</label><select id="fCountry"></select></div>
          <div class="field"><label>Dongle Seri Numarası</label><input id="fDongle" placeholder="DNG-XXXX-XXXX" /></div>

          <div class="field span12">
            <label>Kullanıcı Paketi</label>

            <div class="packWrap">
              <div class="packTabs">
                <button type="button" class="packTab active" data-tab="base">Ana Paketler</button>
                <button type="button" class="packTab" data-tab="update">Yıllık Güncelleme</button>
                <div class="packHint">Update seçilince <b>Bitiş +1Y</b></div>
              </div>

              <div class="packPane" id="packPaneBase">
                <div class="packGrid" id="packBoxBase"></div>
              </div>

              <div class="packPane hidden" id="packPaneUpdate">
                <div class="packGrid" id="packBoxUpdate"></div>
              </div>

              <div class="packDivider"></div>
              <div class="muted" style="font-size:12px;margin:6px 0 8px 0;">DTC Paketleri (aktivasyon)</div>
              <div class="packGrid" id="packBoxDtc"></div>
            </div>

            <div class="muted" style="font-size:11px;margin-top:8px;">
              Paketler sayfasından çekilecek (şimdilik demo).
            </div>
          </div>

          <div class="field"><label>Başlangıç Tarihi</label><input id="fStart" type="date" /></div>
          <div class="field"><label>Bitiş Tarihi</label><input id="fEnd" type="date" /></div>

          <div class="field">
            <label>Destek Durumu</label>
            <select id="fSupport"><option value="Normal">Normal</option><option value="Hizli">Hızlı</option></select>
          </div>

          <div class="field span12" style="display:flex;gap:10px;justify-content:flex-end;margin-top:6px;flex-wrap:wrap;">
            <button class="btnSmall ghost" type="button" onclick="closeUserForm()">İptal</button>
            <button class="btnSmall" type="submit">Kaydet</button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
(function(){
  const PACKS = [
    {id:"CAR", name:"CAR"},
    {id:"TRUCK-BUS", name:"TRUCK-BUS"},
    {id:"TRACTOR", name:"TRACTOR"},
    {id:"MACHINERY", name:"MACHINERY"},
    {id:"FULL", name:"FULL"},

    // Yıllık güncelleme paketleri (seçildiğinde bitiş +1 yıl)
    {id:"CAR_UPDATE_1Y", name:"CAR • Yıllık Güncelleme (+1Y)", type:"update"},
    {id:"TRUCK-BUS_UPDATE_1Y", name:"TRUCK-BUS • Yıllık Güncelleme (+1Y)", type:"update"},
    {id:"TRACTOR_UPDATE_1Y", name:"TRACTOR • Yıllık Güncelleme (+1Y)", type:"update"},
    {id:"MACHINERY_UPDATE_1Y", name:"MACHINERY • Yıllık Güncelleme (+1Y)", type:"update"},
    {id:"FULL_UPDATE_1Y", name:"FULL • Yıllık Güncelleme (+1Y)", type:"update"},
  ];

  // DTC paketleri: kullanıcı sadece seçili DTC paketi kapsamında işlem yapabilir (aktivasyon)
  const DTC_PACKS = [
    {id:"DTC_CAR", name:"CAR"},
    {id:"DTC_TRUCK-BUS", name:"TRUCK-BUS"},
    {id:"DTC_TRACTOR", name:"TRACTOR"},
    {id:"DTC_MACHINERY", name:"MACHINERY"},
    {id:"DTC_FULL", name:"FULL"},
  ];

  function seedCountries(){
    window.__ALL_COUNTRIES = [
      "Afghanistan","Albania","Algeria","Andorra","Angola","Antigua and Barbuda","Argentina","Armenia","Australia","Austria","Azerbaijan",
      "Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia and Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina Faso","Burundi",
      "Cabo Verde","Cambodia","Cameroon","Canada","Central African Republic","Chad","Chile","China","Colombia","Comoros","Congo","Costa Rica","Côte d’Ivoire","Croatia","Cuba","Cyprus","Czechia",
      "Denmark","Djibouti","Dominica","Dominican Republic",
      "Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Eswatini","Ethiopia",
      "Fiji","Finland","France",
      "Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala","Guinea","Guinea-Bissau","Guyana",
      "Haiti","Honduras","Hungary",
      "Iceland","India","Indonesia","Iran","Iraq","Ireland","Israel","Italy",
      "Jamaica","Japan","Jordan",
      "Kazakhstan","Kenya","Kiribati","Kuwait","Kyrgyzstan",
      "Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg",
      "Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar",
      "Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","North Korea","North Macedonia","Norway",
      "Oman",
      "Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal",
      "Qatar",
      "Romania","Russia","Rwanda",
      "Saint Kitts and Nevis","Saint Lucia","Saint Vincent and the Grenadines","Samoa","San Marino","Sao Tome and Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Somalia","South Africa","South Korea","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Sweden","Switzerland","Syria",
      "Taiwan","Tajikistan","Tanzania","Thailand","Timor-Leste","Togo","Tonga","Trinidad and Tobago","Tunisia","Turkey",
      "Turkmenistan","Tuvalu",
      "Uganda","Ukraine","United Arab Emirates","United Kingdom","United States","Uruguay","Uzbekistan",
      "Vanuatu","Vatican City","Venezuela","Vietnam",
      "Yemen",
      "Zambia","Zimbabwe"
    ];
  }
  seedCountries();

  const USERS = [];
  const sampleCountries = ["Turkey","France","Spain","Morocco","Côte d’Ivoire","Germany","Italy","United Kingdom"];
  const support = ["Normal","Hizli"];
  for(let i=1;i<=78;i++){
    USERS.push({
      id:i,
      name:"User "+String(i).padStart(2,"0")+" Surname",
      email:"user"+i+"@mail.com",
      phone:"+90 5"+String((i*37)%100).padStart(2,"0")+" "+String((i*91)%1000).padStart(3,"0")+" "+String((i*17)%10000).padStart(4,"0"),
      password:"••••••••",
      address:"Address line "+i,
      country: sampleCountries[i%sampleCountries.length],
      dongle:"DNG-"+String(1000+i)+"-"+String(2000+i),
      packs: (i%3===0? ["FULL"] : (i%2===0? ["CAR","TRUCK-BUS"] : ["CAR"])),
      dtc_packs: (i%4===0 ? ["DTC_FULL"] : (i%2===0 ? ["DTC_CAR"] : [])),
      start:"2026-01-01",
      end:(i%9===0 ? "2026-01-15" : "2026-12-31"),
      support: support[i%support.length],
      banned: (i%13===0),
      ban_until: (i%13===0 ? "2026-03-01" : ""),
      ban_forever: (i%29===0),
    });
  }

  let page = 1;
  let pageSize = 50;
  let q = "";
  let supportFilter = "";
  let selectedCountries = [];

  const body = document.getElementById('usersBody');
  const info = document.getElementById('usersInfo');
  const pageLabel = document.getElementById('pageLabel');
  const chips = document.getElementById('countryChips');

  const userFormModal = document.getElementById('userFormModal');
  const ufTitle = document.getElementById('ufTitle');
  const ufSub = document.getElementById('ufSub');
  const fName = document.getElementById('fName');
  const fEmail = document.getElementById('fEmail');
  const fPhone = document.getElementById('fPhone');
  const fPass = document.getElementById('fPass');
  const fAddress = document.getElementById('fAddress');
  const fCountry = document.getElementById('fCountry');
  const fDongle = document.getElementById('fDongle');
  const fStart = document.getElementById('fStart');
  const fEnd = document.getElementById('fEnd');
  const fSupport = document.getElementById('fSupport');
  const packBoxBase = document.getElementById('packBoxBase');
  const packBoxUpdate = document.getElementById('packBoxUpdate');
  const packBoxDtc = document.getElementById('packBoxDtc');

  let editingId = null;


  function isExpired(u){
    // demo current date fixed to keep stable
    const now = new Date("2026-02-06T00:00:00");
    const end = new Date((u.end||"1970-01-01")+"T00:00:00");
    return end < now;
  }
  function rowClass(u){
    let c = "";
    if(u.ban_forever || u.banned) c += " rowBanned";
    if(isExpired(u)) c += " rowExpired";
    return c;
  }

  function packsText(p){ return (p||[]).join(", "); }
  function packsTextFull(u){
    const base = packsText(u.packs);
    const dtc = packsText(u.dtc_packs);
    if(base && dtc) return base + " • DTC: " + dtc;
    if(dtc) return "DTC: " + dtc;
    return base;
  }

  function isoDate(d){
    const y=d.getFullYear();
    const m=String(d.getMonth()+1).padStart(2,'0');
    const day=String(d.getDate()).padStart(2,'0');
    return `${y}-${m}-${day}`;
  }
  function addYears(iso, years){
    if(!iso) return "";
    const d=new Date(iso+"T00:00:00");
    d.setFullYear(d.getFullYear()+years);
    return isoDate(d);
  }
  function packSelected(){
    const arr=[];
    [packBoxBase, packBoxUpdate].forEach(box=>{
      if(!box) return;
      box.querySelectorAll('input[type="checkbox"]').forEach(i=>{ if(i.checked) arr.push(i.value); });
    });
    return arr;
  }

  function dtcPackSelected(){
    const arr=[];
    if(!packBoxDtc) return arr;
    packBoxDtc.querySelectorAll('input[type="checkbox"]').forEach(i=>{ if(i.checked) arr.push(i.value); });
    return arr;
  }
  function countUpdatePacks(arr){
    return (arr||[]).filter(x=>String(x).includes("_UPDATE_1Y")).length;
  }
  function recalcEndDateFromPacks(){
    const selected = packSelected();
    const add = countUpdatePacks(selected);
    if(add<=0) return;

    const todayIso = isoDate(new Date());
    const base = (fEnd.value || fStart.value || todayIso);
    fEnd.value = addYears(base, add);
  }

  function filtered(){
    return USERS.filter(u=>{
      if(supportFilter && u.support !== supportFilter) return false;
      if(selectedCountries.length && !selectedCountries.includes(u.country)) return false;
      if(q){
        const t = (u.name+" "+u.email+" "+u.phone+" "+u.address+" "+u.country+" "+u.dongle+" "+packsTextFull(u)+" "+u.support).toUpperCase();
        if(!t.includes(q.toUpperCase())) return false;
      }
      return true;
    });
  }

  function renderChips(){
    if(!chips) return;
    if(!selectedCountries.length){
      chips.innerHTML = "<span class='chip'>Ülke filtresi: <b>Yok</b></span>";
      return;
    }
    chips.innerHTML = selectedCountries.map(c=>`<span class="chip chipX">${c}<button onclick="removeCountryChip('${c.replace(/'/g,"\\'")}')">✕</button></span>`).join("")
      + `<span class="chip chipX"><b>${selectedCountries.length}</b> ülke seçili</span>`;
  }
  window.removeCountryChip = function(c){
    selectedCountries = selectedCountries.filter(x=>x!==c);
    renderChips(); render();
  }

  function render(){
    const list = filtered();
    const total = list.length;
    const pages = Math.max(1, Math.ceil(total / pageSize));
    page = Math.min(page, pages);

    const start = (page-1)*pageSize;
    const slice = list.slice(start, start+pageSize);

    body.innerHTML = slice.map(u=>`
      <tr class="uRow ${rowClass(u)}" data-uid="${u.id}" title="Detay için tıkla">
        <td class="mono">#${u.id}</td>
        <td><div class="nameCell"><b>${u.name}</b>${u.ban_forever || u.banned ? `<span class="lock">🔒</span>` : ``}</div></td>
        <td>${u.email}</td>
        <td>${u.phone}</td>
        <td>••••••••</td>
        <td>${u.address}</td>
        <td><span class="badge y">${u.country}</span></td>
        <td class="mono">${u.dongle}</td>
        <td><span class="badge g">${packsTextFull(u)}</span></td>
        <td class="mono">${u.start}</td>
        <td class="mono">${u.end}</td>
        <td>${u.support==="Hizli" ? "<span class='badge r'>Hızlı</span>" : "<span class='badge b'>Normal</span>"}</td>
        <td>
          <button class="rowExpand" type="button" aria-label="Detay">
            <span class="chev">⌄</span>
          </button>
        </td>
      </tr>
      <tr class="uDrawer" data-uid="${u.id}">
        <td colspan="13">
          <div class="drawerWrap"><div class="drawerBox">
            <div class="drawerTop">
              <div class="drawerTitle">
                <span class="badge g">#${u.id}</span>
                <b>${u.name}</b>
                <span class="muted mono">${u.email}</span>
              </div>
              <div class="drawerMeta">
                <span class="chip">Dongle: <b class="mono">${u.dongle}</b></span>
                <span class="chip">Ülke: <b>${u.country}</b></span>
                <span class="chip">Paket: <b>${packsTextFull(u)}</b></span>
              </div>
            </div>

            <div class="drawerGrid">
              <div class="uBox"><div class="muted">Telefon</div><div class="mono">${u.phone}</div></div>
              <div class="uBox"><div class="muted">Adres</div><div>${u.address}</div></div>
              <div class="uBox"><div class="muted">Başlangıç</div><div class="mono">${u.start}</div></div>
              <div class="uBox"><div class="muted">Bitiş</div><div class="mono">${u.end}</div></div>
            </div>

            <div class="drawerActions">
              <div class="actCenter">
                <button class="actBtn2" type="button" onclick='openUserForm(${JSON.stringify(u).replace(/'/g,"&#39;")})'><span class="actI2">✎</span><span>Düzenle</span></button>
                <a class="actBtn2 ghost" href="?p=bans&id=${u.id}"><span class="actI2">⛔</span><span>Ban</span></a>
                <a class="actBtn2" href="?p=user_logs&id=${u.id}"><span class="actI2">🧾</span><span>Log</span></a>
                <button class="actBtn2 danger" type="button" onclick="deleteUser(${u.id})"><span class="actI2">🗑</span><span>Sil</span></button>
              </div>
            </div>
          </div></div>
        </td>
      </tr>
`).join("");

    info.textContent = `Gösterilen: ${total? Math.min(start+1,total):0}-${Math.min(start+pageSize,total)} / ${total}`;
    pageLabel.textContent = `Sayfa ${page} / ${pages}`;

    const now = new Date("2026-02-06");
    const active = USERS.filter(u=>new Date(u.end) >= now).length;
    const inactive = USERS.length - active;
    const expSoon = USERS.filter(u=>{
      const d = new Date(u.end) - now;
      return d>=0 && d <= (7*24*3600*1000);
    }).length;
    document.getElementById('kpiUsersTotal').textContent = String(USERS.length);
    document.getElementById('kpiUsersActive').textContent = String(active);
    document.getElementById('kpiUsersInactive').textContent = String(inactive);
    document.getElementById('kpiUsersExpSoon').textContent = String(expSoon);
  }

  document.getElementById('userSearch').addEventListener('input', (e)=>{ q = (e.target.value||"").trim(); page=1; render(); });
  document.getElementById('supportStatus').addEventListener('change', (e)=>{ supportFilter = e.target.value; page=1; render(); });
  document.getElementById('pageSize').addEventListener('change', (e)=>{ pageSize = Number(e.target.value||50); page=1; render(); });
  document.getElementById('prevPage').addEventListener('click', ()=>{ page=Math.max(1,page-1); render(); });
  document.getElementById('nextPage').addEventListener('click', ()=>{ const pages=Math.max(1, Math.ceil(filtered().length/pageSize)); page=Math.min(pages,page+1); render(); });

  // Country picker
  const countryModal = document.getElementById('countryModal');
  const countryGrid = document.getElementById('countryGrid');
  const countrySearch = document.getElementById('countrySearch');

  window.openCountryPicker = function(){
    buildCountryGrid();
    countryModal.setAttribute('aria-hidden','false');
    setTimeout(()=>{ countrySearch && countrySearch.focus(); }, 50);
  }
  window.closeCountryPicker = function(){ countryModal.setAttribute('aria-hidden','true'); }
  function buildCountryGrid(){
    const q = (countrySearch?.value||"").trim().toLowerCase();
    const list = window.__ALL_COUNTRIES.filter(c => !q || c.toLowerCase().includes(q));
    countryGrid.innerHTML = list.map(c=>{
      const checked = selectedCountries.includes(c) ? "checked" : "";
      const safe = c.replace(/"/g,'&quot;');
      return `<label class="countryItem"><input type="checkbox" data-country="${safe}" ${checked}/><span>${safe}</span></label>`;
    }).join("");
  }
  window.countrySelectAll = function(on){
    const inputs = countryGrid.querySelectorAll('input[type="checkbox"]');
    inputs.forEach(i=> i.checked = on);
  }
  window.applyCountryFilter = function(){
    const inputs = countryGrid.querySelectorAll('input[type="checkbox"]');
    const picked = [];
    inputs.forEach(i=>{ if(i.checked) picked.push(i.getAttribute('data-country')); });
    selectedCountries = picked;
    renderChips();
    closeCountryPicker();
    page=1; render();
  }
  if(countrySearch){ countrySearch.addEventListener('input', ()=> buildCountryGrid()); }

  // User form
  function buildCountrySelect(){
    fCountry.innerHTML = window.__ALL_COUNTRIES.map(c=>`<option value="${c.replace(/"/g,'&quot;')}">${c}</option>`).join("");
  }
  function buildPackBox(selected, selectedDtc){
    const sel = selected || [];
    const selDtc = selectedDtc || [];
    const base = PACKS.filter(p=>!String(p.id).includes("_UPDATE_1Y"));
    const upd  = PACKS.filter(p=>String(p.id).includes("_UPDATE_1Y"));

    packBoxBase.innerHTML = base.map(p=>{
      const on = sel.includes(p.id) ? "checked" : "";
      return `<label class="packCard"><input type="checkbox" value="${p.id}" ${on}/><span class="packName">${p.name}</span></label>`;
    }).join("");

    packBoxUpdate.innerHTML = upd.map(p=>{
      const on = sel.includes(p.id) ? "checked" : "";
      return `<label class="packCard update"><input type="checkbox" value="${p.id}" ${on}/><span class="packName">${p.name}</span></label>`;
    }).join("");

    if(packBoxDtc){
      packBoxDtc.innerHTML = DTC_PACKS.map(p=>{
        const on = selDtc.includes(p.id) ? "checked" : "";
        return `<label class="packCard"><input type="checkbox" value="${p.id}" ${on}/><span class="packName">${p.name}</span></label>`;
      }).join("");
    }
  }

  function bindPackEvents(){
    [packBoxBase, packBoxUpdate].forEach(box=>{
      if(!box) return;
      box.addEventListener('change', ()=>{ recalcEndDateFromPacks(); });
    });
  }


  window.openUserForm = function(u){
    buildCountrySelect();
    if(!u){
      editingId = null;
      ufTitle.textContent = "Yeni Kullanıcı";
      ufSub.textContent = "Kayıt";
      fStart.disabled = false;
      fName.value=""; fEmail.value=""; fPhone.value=""; fPass.value=""; fAddress.value="";
      fDongle.value=""; fStart.value=""; fEnd.value=""; fSupport.value="Normal";
      fCountry.value="Turkey";
      buildPackBox([], []);
      bindPackEvents();
    }else{
      editingId = u.id;
      ufTitle.textContent = "Kullanıcı Düzenle";
      ufSub.textContent = "#"+u.id+" • "+u.name;
      // İlk açılış tarihi sabit (sonradan paket eklenirse geçerli kalır)
      fStart.disabled = true;
      fName.value=u.name||""; fEmail.value=u.email||""; fPhone.value=u.phone||"";
      fPass.value="";
      fAddress.value=u.address||"";
      fCountry.value=u.country||"Turkey";
      fDongle.value=u.dongle||"";
      fStart.value=u.start||"";
      fEnd.value=u.end||"";
      fSupport.value=u.support||"Normal";
      buildPackBox(u.packs||[], u.dtc_packs||[]);
      bindPackEvents();
    }
    userFormModal.setAttribute('aria-hidden','false');
  }
  window.closeUserForm = function(){ userFormModal.setAttribute('aria-hidden','true'); }


  function deleteUser(id){
    if(!id){ toast("User yok"); return; }
    if(!confirm("Kullanıcı silinsin mi? (#"+id+")")) return;
    const i = USERS.findIndex(x=>x.id===id);
    if(i>=0){
      USERS.splice(i,1);
      toast("Kullanıcı silindi (demo)");
      page = 1;
      render();
    }else{
      toast("Kullanıcı bulunamadı");
    }
  }
  window.deleteUser = deleteUser;

  function toggleDrawer(uid){
    const row = body.querySelector(`tr.uRow[data-uid="${uid}"]`);
    const dr  = body.querySelector(`tr.uDrawer[data-uid="${uid}"]`);
    if(!row || !dr) return;

    const wrap = dr.querySelector(".drawerWrap");
    const isOpen = dr.classList.contains("open");

    // close others
    body.querySelectorAll("tr.uDrawer.open").forEach(x=>{
      x.classList.remove("open");
      const w = x.querySelector(".drawerWrap");
      if(w){ w.style.maxHeight = "0px"; w.style.opacity = "0"; }
    });
    body.querySelectorAll("tr.uRow.open").forEach(x=>x.classList.remove("open"));
    body.querySelectorAll(".rowExpand .chev").forEach(c=>{ c.textContent="⌄"; });

    if(isOpen){
      // close current
      dr.classList.remove("open");
      row.classList.remove("open");
      if(wrap){ wrap.style.maxHeight="0px"; wrap.style.opacity="0"; }
      const chev = row.querySelector(".rowExpand .chev");
      if(chev) chev.textContent = "⌄";
      return;
    }

    // open current with soft animation
    dr.classList.add("open");
    row.classList.add("open");
    const chev = row.querySelector(".rowExpand .chev");
    if(chev) chev.textContent = "⌃";

    if(wrap){
      wrap.style.opacity = "0";
      wrap.style.maxHeight = "0px";
      requestAnimationFrame(()=>{
        const h = wrap.scrollHeight;
        wrap.style.maxHeight = (h+8)+"px";
        wrap.style.opacity = "1";
      });
    }
    row.scrollIntoView({block:"nearest", behavior:"smooth"});
  }

  // Click to open drawer (row or expand btn)
  body.addEventListener("click", (e)=>{
    const expand = e.target.closest(".rowExpand");
    const tr = e.target.closest("tr.uRow");
    if(!tr) return;
    // prevent toggle when clicking on inner controls (none on row)
    const uid = tr.getAttribute("data-uid");
    if(uid) toggleDrawer(uid);
  });

  window.saveUserForm = function(ev){
    ev.preventDefault();
    const selectedPacks = packSelected();
    const selectedDtcPacks = dtcPackSelected();

    const data = {
      name: fName.value.trim(),
      email: fEmail.value.trim(),
      phone: fPhone.value.trim(),
      password: "••••••••",
      address: fAddress.value.trim(),
      country: fCountry.value,
      dongle: fDongle.value.trim(),
      packs: selectedPacks,
      dtc_packs: selectedDtcPacks,
      start: (fStart.disabled && editingId!=null ? (fStart.value || (USERS.find(x=>x.id===editingId)?.start||"")) : fStart.value),
      end: fEnd.value,
      support: fSupport.value
    };

    if(!data.name || !data.email){ toast("İsim ve email zorunlu"); return false; }

    if(editingId == null){
      const nextId = USERS.length ? Math.max(...USERS.map(x=>x.id))+1 : 1;
      USERS.unshift({id: nextId, ...data});
      toast("Kullanıcı eklendi (demo)");
    }else{
      const idx = USERS.findIndex(x=>x.id===editingId);
      if(idx>=0){
        USERS[idx] = { ...USERS[idx], ...data };
        toast("Kullanıcı güncellendi (demo)");
      }
    }
    closeUserForm();
    page=1; render();
    return false;
  }

  renderChips();
  render();
})();
</script>
