<?php
// UI-ONLY (STEP): Kullanıcı logları (DB sonra)
// Kullanım: ?p=user_logs&id=123
$uid = isset($_GET['id']) ? intval($_GET['id']) : 0;
?>

<div class="usersNavBar">
  <div class="usersNavInner">
    <a class="uNavItem " href="?p=users">
      <span class="dot g"></span><span>Kullanıcılar</span>
    </a>
    <a class="uNavItem " href="?p=bans">
      <span class="dot r"></span><span>Ban Sistemi</span>
    </a>
    <a class="uNavItem active" href="?p=user_logs">
      <span class="dot b"></span><span>Loglar</span>
    </a>
    <div class="uNavHint">Kullanıcı yönetimi • ban • audit log</div>
  </div>
</div>
<div class="card">
  <div class="panelHd">
    <h2>Kullanıcı Logları</h2>
    <div class="actions">
      <span class="chip">audit</span>
      <span class="badge b">LOG</span>
    </div>
  </div>

  <div class="pad">
    <div class="usersToolbar" style="margin:0;">
      <div class="usersLeft">
        <div class="dtcSearch" style="min-width:360px;">
          <span class="ico">⌕</span>
          <input id="logSearch" placeholder="Ara: ip, ülke, şehir, dosya, event..." />
        </div>
        <select id="logType" class="select">
          <option value="">Tümü</option>
          <option value="LOGIN">Giriş</option>
          <option value="LOGOUT">Çıkış</option>
          <option value="FILE_PROCESS">İşlenen Dosya</option>
          <option value="FILE_QUERY">Sorgulanan Dosya</option>
        </select>
      </div>
      <div class="usersRight">
        <select id="userPick" class="select" style="min-width:180px;">
          <option value="">Kullanıcı Seç (Tümü)</option>
        </select>

        <div class="chip">Seçili: <b class="mono" id="logUser">#<?= $uid ?: '—' ?></b></div>
        <button class="btnSmall" onclick="toast('DB adımı: export csv')">Export</button>
      </div>
    </div>

    <div class="userDetail" id="userDetail" style="margin-top:12px;"></div>

    <div class="muted" style="font-size:12px;margin-top:10px;">
      Log içeriği: <b>giriş/çıkış</b>, <b>işlediği dosya</b>, <b>sorguladığı dosya</b>,
      <b>IP • ülke • şehir</b> ve detaylar. (Bu adım UI; DB/gerçek log kaydı bir sonraki adım.)
    </div>

    <div class="card" style="margin-top:14px;">
      <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
        <h2>Log Akışı</h2>
        <div class="actions"><span class="badge y">stream</span></div>
      </div>
      <div class="tableWrap">
        <table id="logTable">
          <thead>
            <tr>
              <th style="width:150px;">Tarih</th>
              <th style="width:120px;">Event</th>
              <th style="width:140px;">IP</th>
              <th style="width:140px;">Ülke</th>
              <th style="width:160px;">Şehir</th>
              <th style="width:160px;">Marka</th>
              <th style="width:170px;">ECU</th>
              <th>Detay</th>
            </tr>
          </thead>
          <tbody id="logBody"></tbody>
        </table>
      </div>
      <div class="pad muted" id="logInfo" style="font-size:12px;">—</div>
    </div>
  </div>
</div>

<script>
(function(){
  const uidParam = <?= $uid ?>;
  const body = document.getElementById('logBody');
  const info = document.getElementById('logInfo');
  const search = document.getElementById('logSearch');
  const typeSel = document.getElementById('logType');
  const userPick = document.getElementById('userPick');
  const userDetail = document.getElementById('userDetail');

  // Demo log data
  const LOGS = [];
  const evs = ["LOGIN","LOGOUT","FILE_PROCESS","FILE_QUERY"];
  const countries = [["Turkey","Istanbul"],["France","Paris"],["Spain","Madrid"],["Morocco","Casablanca"],["Germany","Berlin"],["Italy","Milano"]];
  function pick(a){ return a[Math.floor(Math.random()*a.length)]; }
  function rndIP(){ return `${Math.floor(50+Math.random()*150)}.${Math.floor(Math.random()*255)}.${Math.floor(Math.random()*255)}.${Math.floor(Math.random()*255)}`; }

  for(let i=0;i<140;i++){
    const [co,ci]=pick(countries);
    const ev=pick(evs);
    const d=new Date(Date.now() - i*3600*1000);
    const ts=d.toISOString().slice(0,19).replace('T',' ');
    const det = ev==="FILE_PROCESS" ? `MOD çıktı: file_${1000+i}.bin • DTC: ${Math.floor(Math.random()*40)} seçildi`
              : ev==="FILE_QUERY" ? `Sorgu: ori_${900+i}.bin • ECU: EDC17CP45`
              : ev==="LOGIN" ? `Giriş başarılı • Dongle: DNG-${1000+(uid||12)}-${2000+(uid||12)}`
              : `Oturum kapandı`;
    const u = (uidParam || (10 + (i%25))); // demo users 10..34
    const brand = (ev==='FILE_PROCESS' || ev==='FILE_QUERY') ? pick(['VW','BMW','FORD','MERCEDES','RENAULT','FIAT','VOLVO']) : '';
    const ecu = (ev==='FILE_PROCESS' || ev==='FILE_QUERY') ? pick(['EDC17CP45','MD1CS004','SID807','DCM6.2','MED17.5','PCR2.1']) : '';
    LOGS.push({uid: u, ts, ev, ip:rndIP(), country:co, city:ci, brand, ecu, det});
  }


  function uniq(arr){ return Array.from(new Set(arr)); }
  function userMeta(uid){
    // demo meta (DB adımında panel_users'dan gelecek)
    return {
      id: uid,
      name: `User ${String(uid).padStart(2,'0')} Surname`,
      email: `user${uid}@mail.com`,
      phone: `+90 5${String((uid*37)%100).padStart(2,'0')} ${String((uid*91)%1000).padStart(3,'0')} ${String((uid*17)%10000).padStart(4,'0')}`,
      dongle: `DNG-${1000+uid}-${2000+uid}`,
      country: pick(['Turkey','France','Spain','Morocco','Germany','Italy']),
      city: pick(['Istanbul','Paris','Madrid','Casablanca','Berlin','Milano']),
    };
  }
  function renderUserDetail(uid){
    if(!userDetail) return;
    if(!uid){ userDetail.innerHTML = ""; return; }
    const m = userMeta(uid);
    userDetail.innerHTML = `
      <div class="card" style="box-shadow:none;border-color:rgba(255,255,255,.08);">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>Seçili Kullanıcı Detayı</h2>
          <div class="actions"><span class="badge g">#${m.id}</span></div>
        </div>
        <div class="pad" style="display:grid;grid-template-columns:repeat(12,1fr);gap:12px;">
          <div class="uBox" style="grid-column:span 4;"><div class="muted">İsim</div><div><b>${m.name}</b></div></div>
          <div class="uBox" style="grid-column:span 4;"><div class="muted">E-mail</div><div class="mono">${m.email}</div></div>
          <div class="uBox" style="grid-column:span 4;"><div class="muted">Telefon</div><div class="mono">${m.phone}</div></div>
          <div class="uBox" style="grid-column:span 4;"><div class="muted">Dongle</div><div class="mono">${m.dongle}</div></div>
          <div class="uBox" style="grid-column:span 4;"><div class="muted">Ülke</div><div>${m.country}</div></div>
          <div class="uBox" style="grid-column:span 4;"><div class="muted">Şehir</div><div>${m.city}</div></div>
        </div>
      </div>
    `;
  }

  // Populate user select
  if(userPick){
    const ids = uniq(LOGS.map(x=>x.uid)).sort((a,b)=>a-b);
    userPick.innerHTML = `<option value="">Kullanıcı Seç (Tümü)</option>` + ids.map(id=>`<option value="${id}">#${id}</option>`).join("");
    if(uidParam){ userPick.value = String(uidParam); }
  }
  function render(){
    const q=(search.value||"").trim().toUpperCase();
    const t=typeSel.value;
    const list = LOGS.filter(x=>{
      const pickId = userPick && userPick.value ? Number(userPick.value) : 0;
      if(pickId && x.uid!==pickId) return false;
      if(t && x.ev!==t) return false;
      if(q){
        const hay=(x.ts+" "+x.ev+" "+x.ip+" "+x.country+" "+x.city+" "+x.det).toUpperCase();
        if(!hay.includes(q)) return false;
      }
      return true;
    });

    body.innerHTML = list.slice(0,250).map(x=>`
      <tr>
        <td class="mono">${x.ts}</td>
        <td>${badgeEv(x.ev)}</td>
        <td class="mono">${x.ip}</td>
        <td><span class="badge y">${x.country}</span></td>
        <td>${x.city}</td>
        <td>${x.brand || '-'}</td>
        <td>${x.ecu || '-'}</td>
        <td>${x.det}</td>
      </tr>
    `).join("");

    info.textContent = `Toplam: ${list.length} kayıt`;
    const pickId = userPick && userPick.value ? Number(userPick.value) : 0;
    document.getElementById('logUser').textContent = pickId? ("#"+pickId) : (uidParam? ("#"+uidParam) : "—");
    renderUserDetail(pickId || uidParam || 0);
  }

  function badgeEv(ev){
    if(ev==="LOGIN") return "<span class='badge g'>LOGIN</span>";
    if(ev==="LOGOUT") return "<span class='badge r'>LOGOUT</span>";
    if(ev==="FILE_PROCESS") return "<span class='badge b'>FILE_PROCESS</span>";
    return "<span class='badge y'>FILE_QUERY</span>";
  }

  search.addEventListener('input', render);
  typeSel.addEventListener('change', render);
  if(userPick){ userPick.addEventListener('change', render); }
  render();
})();
</script>
