<?php require_once __DIR__ . "/../includes/auth.php"; ?>
<div class="card">
  <div class="panelHd">
    <h2>Profil Öğretme (Teach)</h2>
    <div class="actions"><span class="badge g">admin</span></div>
  </div>
  <div class="pad">
    <div class="muted">Binary + JSON yükle → tablo seç → yöntem seç → test → patch preview → profili kaydet.</div>

    <div class="teachFlow" style="margin-top:12px;">
      <div class="teachRow">

      <div class="card teachBlock" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>1) Dosyaları Yükle</h2>
          <div class="actions"><span class="chip">admin_load_files</span></div>
        </div>
        <div class="pad">
          <div class="formRow">
            <label>BIN Dosyası</label>
            <input id="binFile" type="file" class="input" accept=".bin,.ori,.mod,.dat,*/*">
          </div>
          <div class="formRow">
            <label>JSON Harita</label>
            <input id="jsonFile" type="file" class="input" accept=".json,application/json">
          </div>
          <div style="display:flex;gap:10px;flex-wrap:wrap;margin-top:10px;">
            <button class="btn" onclick="teachUpload()">Yükle & Tablo Listele</button>
            <span class="chip mono">Token: <b id="tok">—</b></span>
            <span class="chip">Maps: <b id="mapCount">0</b></span>
          </div>
          <div class="muted" style="margin-top:8px;">Not: Token, öğretme/test/kayıt işlemleri için kullanılır.</div>
        </div>
      </div>

      <div class="card teachBlock" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>2) Tablo Seçimi</h2>
          <div class="actions"><span class="chip">read_tables</span></div>
        </div>
        <div class="pad">
          <div class="muted">Yükleme sonrası tablolar burada listelenir.</div>
          <div class="formRow" style="margin-top:10px;">
            <label>Tablolar (çoklu seçim)</label>
            <select id="tablesSel" class="select" multiple size="10"></select>
          </div>
        </div>
      </div>

      <div class="card teachBlock" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>3) Yöntem & Test</h2>
          <div class="actions"><span class="chip">admin_read_test</span></div>
        </div>
        <div class="pad">
          <div class="muted">Not: Test çıktısında ilk 50 satır yeter.</div>
          <div class="formRow" style="margin-top:8px;">
            <label>Yöntemler (çoklu seçim)</label>
            <select id="methodsSel" class="select" multiple size="8"></select>
          </div>
          <div style="display:flex;gap:10px;flex-wrap:wrap;margin-top:10px;">
            <button class="btn" onclick="teachTest()">Test Oku</button>
            <button class="btn ghost" onclick="teachPatchPreview()">Patch Preview</button>
          </div>
          <div class="formRow" style="margin-top:10px;">
            <label>Sonuç / Log</label>
            <pre id="out" class="pre" style="max-height:260px;overflow:auto;"></pre>
          </div>
        </div>
      </div>

      </div><!-- /teachRow (1-3) -->

      <div class="teachRow">

      <div class="card teachBlock" style="box-shadow:none;min-width:560px;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>4) Patch Tablo Seçimi • Patch Value Girişi</h2>
          <div class="actions" style="gap:8px;">
            <button class="btn ghost" type="button" onclick="patchFillAllValue('0xFFFF')">FFFF</button>
            <button class="btn ghost" type="button" onclick="patchFillAllValue('0x0000')">0000</button>
            <button class="btn ghost" type="button" onclick="patchFillAllValue('65535')">65535</button>
            <button class="btn ghost" type="button" onclick="patchClearAll()">Clear</button>
          </div>
        </div>
        <div class="pad">
          <div class="grid2" style="gap:10px;align-items:start;">
            <div class="formRow" style="margin:0;">
              <label>Patch Tablolar (çoklu seçim)</label>
              <select id="patchTablesSel" class="select" multiple size="8"></select>
              <div class="muted" style="margin-top:6px;">Seçtikten sonra sağ tarafta kolon bazlı patch value gir.</div>
            </div>
            <div>
              <div id="patchMatrix" class="muted">Patch tablo seçilmedi.</div>
            </div>
          </div>
          <details style="margin-top:10px;">
            <summary class="muted" style="cursor:pointer;">Patch Config (JSON) — ileri kullanım</summary>
            <textarea id="patchCfg" class="textarea mono" rows="7">[]</textarea>
            <div class="muted">Bu alan otomatik doldurulur. İstersen elle düzenleyebilirsin.</div>
          </details>
        </div>
      </div>

      <div class="card teachBlock" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>5) Paket ID</h2>
          <div class="actions"><span class="chip">package_id</span></div>
        </div>
        <div class="pad">
          <div class="formRow">
            <label>Paket ID</label>
            <div class="muted" style="margin-top:-2px;">CAR • TRUCK-BUS • TRACTOR • MACHINERY • FULL</div>
            <div class="packGrid" id="pkgBoxTeach" style="margin-top:10px;grid-template-columns: repeat(5, minmax(0,1fr));"></div>
            <input id="packageId" class="input" style="margin-top:10px;" placeholder="Seçim otomatik doldurur (istersen elle yaz)" />
          </div>
        </div>
      </div>

      <div class="card teachBlock" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>6) Meta & Kaydet</h2>
          <div class="actions"><span class="chip">save_profile</span></div>
        </div>
        <div class="pad">
          <div class="formRow">
            <label>Profil Adı</label>
            <input id="profileName" class="input" placeholder="Örn: VW Golf EDC17CP45 v1">
          </div>
          <div class="grid2" style="margin-top:10px;">
            <div class="formRow" style="margin:0;">
              <label>Marka</label>
              <input id="brand" class="input" placeholder="VW / BMW / ...">
            </div>
            <div class="formRow" style="margin:0;">
              <label>ECU Model</label>
              <input id="ecuModel" class="input" placeholder="EDC17CP45 / MD1CS...">
            </div>
          </div>
          <div class="formRow" style="margin-top:10px;">
            <label>Marka Grup</label>
            <input id="brandGroup" class="input" placeholder="Car / Truck / Tractor ...">
          </div>
          <button class="btn" style="margin-top:8px;" onclick="teachSave()">Profili Kaydet</button>
        </div>
      </div>

      </div><!-- /teachRow (4-6) -->

    </div>

  </div>
</div>

<script>
const API = "modules/dtc_admin/api.php";
let TOKEN = "";
let TABLES_META = []; // [{id,text,cols}]

function q(id){ return document.getElementById(id); }
function toast2(t){ if(window.toast) toast(t); else alert(t); }

async function loadMethods(){
  try{
    const r = await fetch("modules/dtc_admin/methods.json?"+Date.now());
    const j = await r.json();
    const sel = q("methodsSel");
    sel.innerHTML = "";
    (j.methods||[]).forEach(m=>{
      const o = document.createElement("option");
      o.value = m; o.textContent = m;
      sel.appendChild(o);
    });
  }catch(e){
    console.error(e);
  }
}
loadMethods();

// Paket quick seçimi (checkbox -> tek seçim)
(function(){
  const box = document.getElementById('pkgBoxTeach');
  if(!box) return;
  const PKGS = ["CAR","TRUCK-BUS","TRACTOR","MACHINERY","FULL"];
  box.innerHTML = PKGS.map(p=>
    `<label class="packCard" style="min-height:40px;"><input type="checkbox" value="${p}"><span class="packName">${p}</span></label>`
  ).join("");
  box.addEventListener('change', (e)=>{
    const inp = document.getElementById('packageId');
    if(!inp) return;
    const t = e.target;
    if(!(t && t.matches && t.matches('input[type="checkbox"]'))) return;
    // tek seçim
    if(t.checked){
      box.querySelectorAll('input[type="checkbox"]').forEach(x=>{ if(x!==t) x.checked=false; });
      inp.value = t.value;
    } else {
      inp.value = "";
    }
  });
})();

function selectedOptions(sel){
  return Array.from(sel.selectedOptions).map(o=>o.value);
}

async function teachUpload(){
  const bf = q("binFile").files[0];
  const jf = q("jsonFile").files[0];
  if(!bf || !jf){ toast2("BIN + JSON seç"); return; }
  const fd = new FormData();
  fd.append("action","admin_load_files");
  fd.append("bin_file", bf);
  fd.append("json_file", jf);
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  if(j.status!=="ok"){ toast2(j.msg||"Hata"); return; }
  TOKEN = j.token;
  q("tok").textContent = TOKEN;
  q("mapCount").textContent = j.count || 0;
  TABLES_META = (j.tables||[]);
  const sel = q("tablesSel");
  sel.innerHTML = "";
  TABLES_META.forEach(t=>{
    const o = document.createElement("option");
    o.value = t.id;
    o.textContent = t.text;
    sel.appendChild(o);
  });

  // Patch tables selector uses same JSON table list
  const psel = q("patchTablesSel");
  psel.innerHTML = "";
  TABLES_META.forEach(t=>{
    const o = document.createElement("option");
    o.value = t.id;
    o.textContent = t.text;
    psel.appendChild(o);
  });

  // reset patch UI
  q("patchCfg").value = "[]";
  renderPatchMatrix();
  toast2("Yüklendi");
}

function getTableMeta(id){
  return (TABLES_META||[]).find(x=>x.id===id) || null;
}

function parseVal(v){
  const s = String(v||"").trim();
  if(!s) return null;
  // allow: 0xFFFF, FFFF, 65535
  if(/^0x[0-9a-f]+$/i.test(s)) return parseInt(s, 16);
  if(/^[0-9a-f]+$/i.test(s) && /[a-f]/i.test(s)) return parseInt(s, 16);
  if(/^[0-9]+$/.test(s)) return parseInt(s, 10);
  return null;
}

function buildPatchCfgFromUI(){
  const selected = selectedOptions(q("patchTablesSel"));
  const cfg = [];
  selected.forEach(tid=>{
    const meta = getTableMeta(tid);
    const cols = meta ? (parseInt(meta.cols||0,10) || 0) : 0;
    const values_by_col = {};
    for(let c=0;c<cols;c++){
      const inp = document.getElementById(`pv_${safeId(tid)}_${c}`);
      if(!inp) continue;
      const n = parseVal(inp.value);
      if(n !== null && !Number.isNaN(n)) values_by_col[String(c)] = n;
    }
    cfg.push({ table: tid, values_by_col });
  });
  q("patchCfg").value = JSON.stringify(cfg, null, 2);
}

// Patch table seçiminde matrix'i yenile
try {
  q("patchTablesSel").addEventListener('change', ()=>renderPatchMatrix());
} catch(e) {}

function safeId(str){
  return String(str||'').replace(/[^a-zA-Z0-9_\-]/g,'_');
}

function renderPatchMatrix(){
  const box = q("patchMatrix");
  const selected = selectedOptions(q("patchTablesSel"));
  if(!selected.length){
    box.innerHTML = "Patch tablo seçilmedi.";
    q("patchCfg").value = "[]";
    return;
  }

  const wrap = document.createElement('div');
  wrap.style.display = 'grid';
  wrap.style.gap = '10px';

  selected.forEach(tid=>{
    const meta = getTableMeta(tid);
    const cols = meta ? (parseInt(meta.cols||0,10) || 0) : 0;
    const card = document.createElement('div');
    card.className = 'card';
    card.style.boxShadow = 'none';
    card.style.border = '1px solid rgba(255,255,255,.08)';

    const hd = document.createElement('div');
    hd.className = 'panelHd';
    hd.style.borderBottom = '1px solid rgba(255,255,255,.08)';
    const h2 = document.createElement('h2');
    h2.style.fontSize = '13px';
    h2.textContent = tid;
    const acts = document.createElement('div');
    acts.className = 'actions';
    const btn = document.createElement('button');
    btn.className = 'btn ghost';
    btn.type = 'button';
    btn.textContent = 'Fill';
    btn.onclick = ()=>patchFillOnePrompt(tid);
    acts.appendChild(btn);
    hd.appendChild(h2);
    hd.appendChild(acts);
    card.appendChild(hd);

    const pad = document.createElement('div');
    pad.className = 'pad';
    const grid = document.createElement('div');
    grid.style.display = 'grid';
    grid.style.gridTemplateColumns = 'repeat(auto-fit, minmax(140px, 1fr))';
    grid.style.gap = '8px';

    for(let c=0;c<cols;c++){
      const fr = document.createElement('div');
      fr.className = 'formRow';
      fr.style.margin = '0';
      const lb = document.createElement('label');
      lb.textContent = `COL ${c}`;
      const inp = document.createElement('input');
      inp.className = 'input mono';
      inp.placeholder = '0xFFFF / FFFF / 65535';
      inp.id = `pv_${safeId(tid)}_${c}`;
      inp.oninput = ()=>buildPatchCfgFromUI();
      fr.appendChild(lb);
      fr.appendChild(inp);
      grid.appendChild(fr);
    }
    pad.appendChild(grid);
    card.appendChild(pad);
    wrap.appendChild(card);
  });

  box.innerHTML = '';
  box.appendChild(wrap);
  buildPatchCfgFromUI();
}

function patchFillOnePrompt(tid){
  const meta = getTableMeta(tid);
  const cols = meta ? (parseInt(meta.cols||0,10) || 0) : 0;
  const v = prompt('Bu tablo için tüm kolonlara yazılacak değer (örn 0xFFFF):', '0xFFFF');
  if(v===null) return;
  for(let c=0;c<cols;c++){
    const inp = document.getElementById(`pv_${safeId(tid)}_${c}`);
    if(inp) inp.value = v;
  }
  buildPatchCfgFromUI();
}

function patchFillAllPrompt(){
  const v = prompt('Seçili tüm patch tabloların tüm kolonlarına yazılacak değer (örn 0xFFFF):', '0xFFFF');
  if(v===null) return;
  const selected = selectedOptions(q("patchTablesSel"));
  selected.forEach(tid=>{
    const meta = getTableMeta(tid);
    const cols = meta ? (parseInt(meta.cols||0,10) || 0) : 0;
    for(let c=0;c<cols;c++){
      const inp = document.getElementById(`pv_${safeId(tid)}_${c}`);
      if(inp) inp.value = v;
    }
  });
  buildPatchCfgFromUI();
}

function patchFillAllValue(v){
  const selected = selectedOptions(q("patchTablesSel"));
  if(!selected.length) return;
  selected.forEach(tid=>{
    const meta = getTableMeta(tid);
    const cols = meta ? (parseInt(meta.cols||0,10) || 0) : 0;
    for(let c=0;c<cols;c++){
      const inp = document.getElementById(`pv_${safeId(tid)}_${c}`);
      if(inp) inp.value = v;
    }
  });
  buildPatchCfgFromUI();
}

function patchClearAll(){
  const selected = selectedOptions(q("patchTablesSel"));
  selected.forEach(tid=>{
    const meta = getTableMeta(tid);
    const cols = meta ? (parseInt(meta.cols||0,10) || 0) : 0;
    for(let c=0;c<cols;c++){
      const inp = document.getElementById(`pv_${safeId(tid)}_${c}`);
      if(inp) inp.value = '';
    }
  });
  q("patchCfg").value = "[]";
  buildPatchCfgFromUI();
}

async function teachTest(){
  if(!TOKEN){ toast2("Önce yükle"); return; }
  const fd = new FormData();
  fd.append("action","admin_read_test");
  fd.append("token", TOKEN);
  fd.append("limit", "50");
  selectedOptions(q("methodsSel")).forEach(x=>fd.append("methods[]", x));
  selectedOptions(q("tablesSel")).forEach(x=>fd.append("tables[]", x));
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  q("out").textContent = JSON.stringify(j, null, 2);
  if(j.status!=="ok") toast2(j.msg||"Hata");
}

async function teachPatchPreview(){
  if(!TOKEN){ toast2("Önce yükle"); return; }
  const cfg = q("patchCfg").value.trim() || "[]";
  const fd = new FormData();
  fd.append("action","admin_patch_preview");
  fd.append("token", TOKEN);
  fd.append("patch_config", cfg);
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  q("out").textContent = JSON.stringify(j, null, 2);
  if(j.status!=="ok") toast2(j.msg||"Hata");
}

async function teachSave(){
  if(!TOKEN){ toast2("Önce yükle"); return; }
  const name = q("profileName").value.trim();
  if(!name){ toast2("Profil adı boş"); return; }
  const cfg = q("patchCfg").value.trim() || "[]";

  const fd = new FormData();
  fd.append("action","save_profile");
  fd.append("token", TOKEN);
  fd.append("profile_name", name);
  fd.append("package_id", q("packageId").value.trim());
  fd.append("brand", q("brand").value.trim());
  fd.append("ecu_model", q("ecuModel").value.trim());
  fd.append("brand_group", q("brandGroup").value.trim());
  selectedOptions(q("methodsSel")).forEach(x=>fd.append("read_methods[]", x));
  selectedOptions(q("tablesSel")).forEach(x=>fd.append("read_tables[]", x));
  fd.append("patch_config", cfg);

  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  q("out").textContent = JSON.stringify(j, null, 2);
  if(j.status==="ok"){ toast2("Kaydedildi"); }
  else toast2(j.msg||"Hata");
}
</script>
