<?php
// UI-ONLY (STEP): Ban sistemi (DB sonra)
// Kullanım: ?p=bans&id=123
$uid = isset($_GET['id']) ? intval($_GET['id']) : 0;
?>

<div class="usersNavBar">
  <div class="usersNavInner">
    <a class="uNavItem " href="?p=users">
      <span class="dot g"></span><span>Kullanıcılar</span>
    </a>
    <a class="uNavItem active" href="?p=bans">
      <span class="dot r"></span><span>Ban Sistemi</span>
    </a>
    <a class="uNavItem " href="?p=user_logs">
      <span class="dot b"></span><span>Loglar</span>
    </a>
    <div class="uNavHint">Kullanıcı yönetimi • ban • audit log</div>
  </div>
</div>
<div class="card">
  <div class="panelHd">
    <h2>Kullanıcı Ban Sistemi</h2>
    <div class="actions">
      <span class="chip">Anti-manipülasyon</span>
      <span class="badge r">BAN</span>
    </div>
  </div>

  <div class="pad">
    <div class="muted" style="font-size:12px;">
      Amaç: Manipülasyon yapan kullanıcıları <b>7 / 15 / 30 / 180 gün</b> veya <b>SÜRESİZ</b> sistemden uzaklaştırmak.
      (Bu adım UI; DB/uygulama bir sonraki adım.)
    </div>

    <div class="banGrid" style="margin-top:14px;">
      <div class="banCard">
        <div class="banTitle">Seçili Kullanıcı</div>
        <div class="banUser mono" id="banUser">#<?= $uid ?: '—' ?></div>
        <div class="muted" style="font-size:11px;margin-top:6px;">Users sayfasından “Ban” ile gel.</div>
      </div>

      <div class="banCard">
        <div class="banTitle">Ban Süresi</div>
        <div class="banBtns">
          <button class="btnSmall" onclick="setBanDays(7)">7 Gün</button>
          <button class="btnSmall" onclick="setBanDays(15)">15 Gün</button>
          <button class="btnSmall" onclick="setBanDays(30)">30 Gün</button>
          <button class="btnSmall" onclick="setBanDays(180)">180 Gün</button>
          <button class="btnSmall danger" onclick="setBanForever()">Süresiz</button>
        </div>
        <div class="muted" id="banPreview" style="font-size:12px;margin-top:10px;">—</div>
      </div>

      <div class="banCard">
        <div class="banTitle">Sebep / Not</div>
        <textarea id="banReason" class="ta" placeholder="Örn: dosya manipülasyonu, kredi kötüye kullanım, şüpheli IP değişimi..."></textarea>
        <div style="display:flex;justify-content:flex-end;gap:10px;margin-top:10px;flex-wrap:wrap;">
          <button class="btnSmall ghost" onclick="removeBan(<?= $uid ?>)">Ban Kaldır</button>
          <button class="btnSmall danger" onclick="applyBan(<?= $uid ?>)">Ban Uygula</button>
        </div>
      </div>
    </div>

    <div class="card" style="margin-top:14px;">
      <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
        <h2>Ban Geçmişi (Demo)</h2>
        <div class="actions"><span class="badge y">history</span></div>
      </div>
      <div class="tableWrap">
        <table>
          <thead>
            <tr>
              <th style="width:110px;">UserID</th>
              <th>Durum</th>
              <th>Süre</th>
              <th>Başlangıç</th>
              <th>Bitiş</th>
              <th>Not</th>
            </tr>
          </thead>
          <tbody id="banHistory"></tbody>
        </table>
      </div>
      <div class="pad muted" style="font-size:12px;">DB bağlayınca gerçek kayıtlar burada listelenecek.</div>
    </div>
  </div>
</div>

<script>
(function(){
  const uid = <?= $uid ?>;
  let banDays = 0;
  let forever = false;

  function iso(d){
    const y=d.getFullYear(), m=String(d.getMonth()+1).padStart(2,'0'), da=String(d.getDate()).padStart(2,'0');
    return `${y}-${m}-${da}`;
  }
  function preview(){
    const now = new Date();
    if(!uid){ document.getElementById('banPreview').textContent = "Kullanıcı seçilmedi."; return; }
    if(forever){
      document.getElementById('banPreview').innerHTML = `<span class="badge r">SÜRESİZ</span> • Başlangıç: <b>${iso(now)}</b>`;
      return;
    }
    if(!banDays){
      document.getElementById('banPreview').textContent = "Süre seç.";
      return;
    }
    const end = new Date(now.getTime() + banDays*24*3600*1000);
    document.getElementById('banPreview').innerHTML = `<span class="badge y">${banDays} gün</span> • ${iso(now)} → <b>${iso(end)}</b>`;
  }

  window.setBanDays = function(d){ forever=false; banDays=d; preview(); }
  window.setBanForever = function(){ banDays=0; forever=true; preview(); }

  window.removeBan = function(uid){
    if(!uid){ toast('User seçilmedi'); return; }
    // Demo: geçmişte bu kullanıcıya ait ilk satırı kaldır
    const tb = document.getElementById('banHistory');
    const rows = Array.from(tb.querySelectorAll('tr'));
    const row = rows.find(r => (r.querySelector('td')?.textContent||'').includes('#'+uid));
    if(row){ row.remove(); toast('Ban kaldırıldı (demo)'); }
    else { toast('Bu kullanıcı için ban yok (demo)'); }
  }

  window.applyBan = function(uid){
    if(!uid){ toast("User seçilmedi"); return; }
    if(!forever && !banDays){ toast("Ban süresi seç"); return; }
    const reason = (document.getElementById('banReason').value||"").trim();
    toast("BAN (demo) uygulandı");
    // Demo history push (UI)
    const now = new Date();
    const end = forever ? "SÜRESİZ" : iso(new Date(now.getTime()+banDays*24*3600*1000));
    const row = `<tr>
      <td class="mono">#${uid}</td>
      <td>${forever? "<span class='badge r'>BANNED</span>" : "<span class='badge y'>TEMP</span>"}</td>
      <td>${forever? "∞" : banDays+" gün"}</td>
      <td class="mono">${iso(now)}</td>
      <td class="mono">${end}</td>
      <td>${reason || "-"}</td>
    </tr>`;
    const tb = document.getElementById('banHistory');
    tb.insertAdjacentHTML('afterbegin', row);
  }

  // Seed demo
  const tb = document.getElementById('banHistory');
  const demo = [
    {u:12, st:"TEMP", d:"30 gün", s:"2026-01-01", e:"2026-01-31", n:"Şüpheli manipülasyon"},
    {u:7, st:"BANNED", d:"∞", s:"2025-12-11", e:"SÜRESİZ", n:"Kredi kötüye kullanım"},
  ];
  tb.innerHTML = demo.map(x=>`<tr>
    <td class="mono">#${x.u}</td>
    <td>${x.st==="BANNED" ? "<span class='badge r'>BANNED</span>" : "<span class='badge y'>TEMP</span>"}</td>
    <td>${x.d}</td>
    <td class="mono">${x.s}</td>
    <td class="mono">${x.e}</td>
    <td>${x.n}</td>
  </tr>`).join("");

  preview();
})();
</script>
