<?php
function nav_item($id, $label, $badgeText = '', $badgeClass = '') {
  $p = $_GET['p'] ?? 'dashboard';
  $active = ($p === $id) ? 'active' : '';
  $badge = $badgeText ? "<span class='badge {$badgeClass}'>".htmlspecialchars($badgeText)."</span>" : "";
  echo "<a class='{$active}' href='?p={$id}'><span>".htmlspecialchars($label)."</span>{$badge}</a>";
}
?>
<aside>
  <div class="brand">
    <div class="logo"></div>
    <div>
      <h1>ECUPRATIX • ADMIN</h1>
      <small>Dark Neon Console</small>
    </div>
  </div>

  <nav class="nav">
    <?php nav_item('dashboard', 'Dashboard', 'LIVE', 'b'); ?>
    <?php nav_item('users', 'Kullanıcılar', 'STEP', 'g'); ?>    <?php nav_item('dtc', 'DTC Yönetimi', 'UI', 'y'); ?>
    <?php nav_item('vehicles', 'Araçlar / ECU', 'panel_vehicle_meta'); ?>
    <?php nav_item('requests', 'Talepler', 'FLOW', 'y'); ?>
    <?php nav_item('tickets', 'Biletler', 'Tickets', 'r'); ?>
    <?php nav_item('files', 'Dosyalar', 'panel_chiptuning_files'); ?>
    <?php nav_item('arge', 'ARGE / Feed', 'Updates', 'g'); ?>
    <?php nav_item('plug', 'Plug / Lisans', 'panel_plug'); ?>
  </nav>

  <div class="asideFooter">
    <div class="asideTitle">Quick Status</div>
    <div class="pillRow">
      <div class="pill">Server: OK</div>
      <div class="pill">DB: Later</div>
      <div class="pill">Users: —</div>
      <div class="pill">Online: —</div>
    </div>
    <div style="margin-top:10px;display:flex;gap:10px;align-items:center;justify-content:space-between;">
      <a class="btnMini" href="logout.php">Çıkış</a>
      <span class="muted" style="font-size:11px;">v4 UI</span>
    </div>
  </div>
</aside>
