function toast(msg){
  const t=document.createElement('div');
  t.style.cssText=`position:fixed;right:18px;bottom:18px;z-index:9999;background:rgba(11,16,32,.92);
  border:1px solid rgba(255,255,255,.12);color:#E8EEFF;padding:12px 14px;border-radius:14px;
  box-shadow:0 20px 60px rgba(0,0,0,.55);font-family:system-ui;font-size:13px;`;
  t.textContent=msg; document.body.appendChild(t); setTimeout(()=>t.remove(),1800);
}
const logEl=document.getElementById("log");
if(logEl){
  const lines=[["INF","GET /admin/dashboard 200"],["OK","DB ping (later) ✓"],["INF","POST /api/files/list 200"],
    ["OK","USER online: dealer_fr"],["INF","POST /api/tickets/open 200"],["ERR","WARN: rate-limit threshold 78%"],
    ["OK","PATCH queue: 3 job(s)"],["INF","WS: online-map update broadcast"],["OK","UPLOAD received: 4MB.bin"],];
  function addLine(type,msg){
    const t=new Date().toLocaleTimeString();
    const c=type==="OK"?"ok":(type==="ERR"?"er":"inf");
    const div=document.createElement("div"); div.className="l";
    div.innerHTML=`<span class="t">${t}</span><span class="${c}">${type}</span><span>${msg}</span>`;
    logEl.prepend(div); while(logEl.children.length>80) logEl.removeChild(logEl.lastChild);
  }
  for(let i=0;i<10;i++){ const it=lines[Math.floor(Math.random()*lines.length)]; addLine(it[0],it[1]); }
  setInterval(()=>{ const it=lines[Math.floor(Math.random()*lines.length)]; addLine(it[0],it[1]); },1400);
}
window.addEventListener("keydown",(e)=>{
  if((e.ctrlKey||e.metaKey)&&e.key.toLowerCase()==="k"){ e.preventDefault(); const inp=document.getElementById("globalSearch"); if(inp) inp.focus(); }
});
