<?php
/**
 * reference_installer.php  (TEK DOSYA - SELF INSTALLER)
 * Konum: /portal/admin/reference_installer.php
 *
 * 1) Klasörleri ve dosyaları oluşturur
 * 2) Referans ekleme + kütüphane ekranlarını ekler
 * 3) Menüye ve router'a otomatik yamalamaya çalışır
 * 4) Bittiğinde silmek için: ?cleanup=1
 */

/* =========================
   DB AYARLARI (GEREKİRSE DÜZENLE)
   ========================= */
define('REF_DB_HOST', 'localhost');
define('REF_DB_NAME', 'aktifperformance_paneldtc');
define('REF_DB_USER', 'aktifperformance_paneldtc');
define('REF_DB_PASS', 'Emrecevik.1');

/* =========================
   PATHS
   ========================= */
$ADMIN_ROOT = __DIR__;
$INCLUDES   = $ADMIN_ROOT . '/includes';
$PAGES      = $ADMIN_ROOT . '/pages';
$MODULES    = $ADMIN_ROOT . '/modules';
$REFMOD     = $MODULES . '/reference';
$REFDATA    = $REFMOD . '/data';
$REFUP      = $REFMOD . '/uploads';

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function ensure_dir($path) {
  if (!is_dir($path)) {
    if (!@mkdir($path, 0777, true)) return [false, "mkdir failed: $path"];
  }
  @chmod($path, 0777);
  return [true, "ok: $path"];
}

function write_file($path, $content) {
  $dir = dirname($path);
  if (!is_dir($dir)) @mkdir($dir, 0777, true);
  $ok = @file_put_contents($path, $content);
  if ($ok === false) return [false, "write failed: $path"];
  return [true, "written: $path"];
}

function try_patch_menu($ADMIN_ROOT) {
  $candidates = [
    $ADMIN_ROOT . '/includes/layout_side.php',
    $ADMIN_ROOT . '/includes/sidebar.php',
    $ADMIN_ROOT . '/includes/side.php',
  ];

  $snippetA = "\n<!-- REF-LIB (AUTO) -->\n<li>\n  <a href=\"index.php?p=reference_library\">\n    <i class=\"fa fa-database\"></i>\n    <span>Referans Kütüphanesi</span>\n  </a>\n</li>\n<!-- /REF-LIB -->\n";
  $snippetB = "\n<!-- REF-LIB (AUTO) -->\n<?php if(function_exists('nav_item')){ nav_item('reference_library','Referans Kütüphanesi','LIB','g'); } ?>\n<!-- /REF-LIB -->\n";

  foreach ($candidates as $f) {
    if (!is_file($f)) continue;

    $txt = @file_get_contents($f);
    if ($txt === false) continue;

    if (strpos($txt, 'reference_library') !== false) {
      return [true, "Menu already has reference_library: " . basename($f)];
    }

    // nav_item varsa B, yoksa A
    $ins = (strpos($txt, 'nav_item(') !== false) ? $snippetB : $snippetA;

    // mümkünse "Araçlar" yakınına ekle
    $pos = stripos($txt, 'Araç');
    if ($pos === false) $pos = stripos($txt, 'ARAC');
    if ($pos === false) $pos = stripos($txt, 'vehicles');

    if ($pos !== false) {
      // pos sonrası ilk </ul> öncesine eklemeyi dene
      $ulEnd = stripos($txt, '</ul>', $pos);
      if ($ulEnd !== false) {
        $patched = substr($txt, 0, $ulEnd) . $ins . substr($txt, $ulEnd);
        if (@file_put_contents($f, $patched) !== false) {
          return [true, "Menu patched: " . basename($f)];
        }
      }
    }

    // olmazsa dosyanın sonuna ekle
    $patched = $txt . $ins;
    if (@file_put_contents($f, $patched) !== false) {
      return [true, "Menu appended: " . basename($f)];
    }
  }

  return [false, "Menu file not found (layout_side.php/sidebar.php). Manual add required."];
}

function try_patch_router($ADMIN_ROOT) {
  $index = $ADMIN_ROOT . '/index.php';
  if (!is_file($index)) return [false, "index.php not found"];

  $txt = @file_get_contents($index);
  if ($txt === false) return [false, "index.php read failed"];

  if (strpos($txt, "reference_library") !== false) {
    return [true, "Router already has reference_library"];
  }

  // 1) switch($page) / switch($p) case ekleme denemesi
  $caseBlock = "\n    case 'reference_library':\n        include __DIR__ . '/pages/reference_library.php';\n        break;\n    case 'reference_add':\n        include __DIR__ . '/pages/reference_add.php';\n        break;\n";

  // switch içine ekle: "default:" öncesine
  $defaultPos = strpos($txt, "default:");
  $switchPos  = strpos($txt, "switch");
  if ($switchPos !== false && $defaultPos !== false && $defaultPos > $switchPos) {
    $patched = substr($txt, 0, $defaultPos) . $caseBlock . substr($txt, $defaultPos);
    if (@file_put_contents($index, $patched) !== false) {
      return [true, "Router patched via switch-case insertion"];
    }
  }

  // 2) $allowed listesine ekleme denemesi
  // $allowed = ['a','b'...];
  if (preg_match("/\\$allowed\\s*=\\s*\\[(.*?)\\];/s", $txt, $m)) {
    $inside = $m[1];
    if (strpos($inside, "reference_library") === false) {
      // 'reference_library' ekle
      $newInside = rtrim($inside);
      $newInside = preg_replace("/\\s*$/", "", $newInside);
      $newInside = $newInside . ", 'reference_library', 'reference_add'";
      $patched = str_replace($m[0], "\$allowed = [{$newInside}];", $txt);
      if (@file_put_contents($index, $patched) !== false) {
        return [true, "Router patched via \$allowed list update (pages will load if your loader includes by p/page)"];
      }
    }
  }

  return [false, "Router patch not applied automatically. Manual add required."];
}

/* =========================
   CONTENTS TO WRITE
   ========================= */

$db_ref_php = <<<PHP
<?php
// includes/db_ref.php (auto-created)
// Reference module DB connector (safe + logs)
function ref_db(): mysqli {
    static \$db = null;
    if (\$db instanceof mysqli) return \$db;

    mysqli_report(MYSQLI_REPORT_OFF);

    \$db = @new mysqli('{$GLOBALS['REF_DB_HOST']}', '{$GLOBALS['REF_DB_USER']}', '{$GLOBALS['REF_DB_PASS']}', '{$GLOBALS['REF_DB_NAME']}');
    if (\$db->connect_errno) {
        error_log("[REF DB CONNECT ERROR] " . \$db->connect_error);
        die("REF DB bağlantı hatası: " . \$db->connect_error);
    }
    \$db->set_charset("utf8mb4");
    return \$db;
}
PHP;

$meta_provider_php = <<<PHP
<?php
require_once __DIR__ . "/../../includes/db_ref.php";

function ref_find_meta_columns(mysqli \$db): array {
    \$cols = [];
    \$res = \$db->query("SHOW COLUMNS FROM panel_vehicle_meta");
    if (!\$res) { error_log("[REF META] panel_vehicle_meta okunamadı: " . \$db->error); return [null, null]; }

    while (\$row = \$res->fetch_assoc()) \$cols[] = \$row['Field'];

    \$brandCol = null; \$ecuCol = null;

    foreach (\$cols as \$c) {
        \$lc = strtolower(\$c);
        if (strpos(\$lc,'marka') !== false || strpos(\$lc,'brand') !== false || \$lc==='make') { \$brandCol=\$c; break; }
    }
    foreach (\$cols as \$c) {
        \$lc = strtolower(\$c);
        if (\$lc==='ecu' || strpos(\$lc,'ecu') !== false) { \$ecuCol=\$c; break; }
    }
    return [\$brandCol, \$ecuCol];
}

function ref_get_brand_ecu_lists(): array {
    \$db = ref_db();
    [\$brandCol, \$ecuCol] = ref_find_meta_columns(\$db);

    \$brands=[]; \$ecus=[];

    if (\$brandCol) {
        \$q="SELECT DISTINCT `{\$brandCol}` AS v FROM panel_vehicle_meta WHERE `{\$brandCol}` IS NOT NULL AND `{\$brandCol}`<>'' ORDER BY `{\$brandCol}`";
        \$r=\$db->query(\$q);
        if (\$r) while(\$row=\$r->fetch_assoc()) \$brands[]=\$row['v'];
        else error_log("[REF META BRAND SQL] ".\$db->error);
    }
    if (\$ecuCol) {
        \$q="SELECT DISTINCT `{\$ecuCol}` AS v FROM panel_vehicle_meta WHERE `{\$ecuCol}` IS NOT NULL AND `{\$ecuCol}`<>'' ORDER BY `{\$ecuCol}`";
        \$r=\$db->query(\$q);
        if (\$r) while(\$row=\$r->fetch_assoc()) \$ecus[]=\$row['v'];
        else error_log("[REF META ECU SQL] ".\$db->error);
    }

    return [\$brands, \$ecus, \$brandCol, \$ecuCol];
}
PHP;

$save_php = <<<PHP
<?php
// modules/reference/save.php
\$dataFile = __DIR__ . "/data/references.json";
\$refs = json_decode(@file_get_contents(\$dataFile), true);
if (!is_array(\$refs)) \$refs = [];

if (empty(\$_FILES['ori']['tmp_name'])) die("Original BIN zorunlu");

\$id = substr(sha1_file(\$_FILES['ori']['tmp_name']), 0, 12);
\$dir = __DIR__ . "/uploads/" . \$id;

if (!is_dir(\$dir)) @mkdir(\$dir, 0777, true);
@chmod(__DIR__ . "/uploads", 0777);
@chmod(\$dir, 0777);

move_uploaded_file(\$_FILES['ori']['tmp_name'], \$dir . "/original.bin");

if (!empty(\$_FILES['mod']['tmp_name'])) {
  move_uploaded_file(\$_FILES['mod']['tmp_name'], \$dir . "/modified.bin");
}

\$refs[] = [
  "id" => \$id,
  "name" => \$_POST['name'] ?? '',
  "brand" => \$_POST['brand'] ?? [],
  "ecu" => \$_POST['ecu'] ?? [],
  "option" => \$_POST['option'] ?? [],
  "date" => date("Y-m-d H:i:s")
];

file_put_contents(\$dataFile, json_encode(\$refs, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
header("Location: ../../index.php?p=reference_library");
exit;
PHP;

$delete_php = <<<PHP
<?php
// modules/reference/delete.php
\$id = \$_GET['id'] ?? '';
\$dataFile = __DIR__ . "/data/references.json";
\$refs = json_decode(@file_get_contents(\$dataFile), true);
if (!is_array(\$refs)) \$refs = [];

\$refs = array_values(array_filter(\$refs, fn(\$r)=>((\$r['id'] ?? '') !== \$id)));
file_put_contents(\$dataFile, json_encode(\$refs, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

header("Location: ../../index.php?p=reference_library");
exit;
PHP;

$reference_add_page = <<<PHP
<?php
require_once __DIR__ . "/../modules/reference/meta_provider.php";
[\$brands,\$ecus,\$brandCol,\$ecuCol] = ref_get_brand_ecu_lists();
\$opts = ["DPF OFF","EGR OFF","ADBLUE OFF","STAGE 1","STAGE 2"];
?>
<div class="card">
  <div class="panelHd">
    <h2>Araçlar / ECU • Referans Ekle</h2>
    <div class="actions"><span class="chip">DB: panel_vehicle_meta</span></div>
  </div>

  <div class="pad">
    <div class="muted" style="margin-bottom:10px;">
      MarkaKolon: <b><?= htmlspecialchars(\$brandCol ?? 'BULUNAMADI') ?></b> —
      ECUKolon: <b><?= htmlspecialchars(\$ecuCol ?? 'BULUNAMADI') ?></b>
    </div>

    <form class="formGrid" action="modules/reference/save.php" method="post" enctype="multipart/form-data">
      <div>
        <label class="lbl">Name</label>
        <input class="in" type="text" name="name" required>
      </div>

      <div>
        <label class="lbl">MARKA</label>
        <div class="checkWrap">
          <?php foreach(\$brands as \$b): ?>
            <label class="chk"><input type="checkbox" name="brand[]" value="<?= htmlspecialchars(\$b) ?>"> <?= htmlspecialchars(\$b) ?></label>
          <?php endforeach; ?>
          <?php if(!\$brands): ?><div class="muted">Marka listesi boş (DB/kolon kontrol)</div><?php endif; ?>
        </div>
      </div>

      <div>
        <label class="lbl">ECU</label>
        <div class="checkWrap">
          <?php foreach(\$ecus as \$e): ?>
            <label class="chk"><input type="checkbox" name="ecu[]" value="<?= htmlspecialchars(\$e) ?>"> <?= htmlspecialchars(\$e) ?></label>
          <?php endforeach; ?>
          <?php if(!\$ecus): ?><div class="muted">ECU listesi boş (DB/kolon kontrol)</div><?php endif; ?>
        </div>
      </div>

      <div>
        <label class="lbl">Opsiyonlar</label>
        <div class="checkWrap">
          <?php foreach(\$opts as \$o): ?>
            <label class="chk"><input type="checkbox" name="option[]" value="<?= htmlspecialchars(\$o) ?>"> <?= htmlspecialchars(\$o) ?></label>
          <?php endforeach; ?>
        </div>
      </div>

      <div>
        <label class="lbl">Original bin</label>
        <input class="in" type="file" name="ori" required>
      </div>

      <div>
        <label class="lbl">Modified bin</label>
        <input class="in" type="file" name="mod">
      </div>

      <div style="grid-column:1/-1;display:flex;gap:10px;justify-content:flex-end;">
        <button class="btn g" type="submit">Kaydet (Öğret)</button>
        <a class="btn" href="?p=reference_library">Kütüphaneye Git</a>
      </div>
    </form>
  </div>
</div>
PHP;

$reference_library_page = <<<PHP
<?php
\$dataFile = __DIR__ . "/../modules/reference/data/references.json";
\$refs = json_decode(@file_get_contents(\$dataFile), true);
if (!is_array(\$refs)) \$refs = [];
?>
<div class="card">
  <div class="panelHd">
    <h2>Referans Kütüphanesi</h2>
    <div class="actions">
      <a class="btn" href="?p=reference_add">+ Referans Ekle</a>
    </div>
  </div>

  <div class="pad">
    <table class="table">
      <thead>
        <tr>
          <th>ID</th><th>Marka</th><th>ECU</th><th>Opsiyon</th><th>Eklenme</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach(\$refs as \$r): \$rid = htmlspecialchars(\$r['id'] ?? ''); ?>
        <tr class="rowClick" onclick="document.getElementById('d<?= \$rid ?>').classList.toggle('open')">
          <td><?= \$rid ?></td>
          <td><?= htmlspecialchars(implode(', ', \$r['brand'] ?? [])) ?></td>
          <td><?= htmlspecialchars(implode(', ', \$r['ecu'] ?? [])) ?></td>
          <td><?= htmlspecialchars(implode(', ', \$r['option'] ?? [])) ?></td>
          <td><?= htmlspecialchars(\$r['date'] ?? '') ?></td>
        </tr>
        <tr id="d<?= \$rid ?>" class="rowDetail">
          <td colspan="5">
            <div style="display:flex;justify-content:space-between;gap:12px;align-items:center;flex-wrap:wrap;">
              <div>
                <b><?= htmlspecialchars(\$r['name'] ?? '') ?></b><br>
                <a href="modules/reference/uploads/<?= \$rid ?>/original.bin">Original</a>
                <?php if (file_exists(__DIR__ . "/../modules/reference/uploads/\$rid/modified.bin")): ?>
                  | <a href="modules/reference/uploads/<?= \$rid ?>/modified.bin">Modified</a>
                <?php endif; ?>
              </div>
              <a class="btn r" href="modules/reference/delete.php?id=<?= \$rid ?>" onclick="return confirm('Silinsin mi?')">Sil</a>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>

    <?php if (!\$refs): ?>
      <div class="muted" style="margin-top:10px;">Henüz referans yok. “+ Referans Ekle” ile başla.</div>
    <?php endif; ?>
  </div>
</div>

<style>
.rowClick{cursor:pointer;}
.rowDetail{display:none;}
.rowDetail.open{display:table-row;}
</style>
PHP;

/* =========================
   RUN INSTALL
   ========================= */
$logs = [];

[$ok,$msg] = ensure_dir($REFMOD);  $logs[] = [$ok,$msg];
[$ok,$msg] = ensure_dir($REFDATA); $logs[] = [$ok,$msg];
[$ok,$msg] = ensure_dir($REFUP);   $logs[] = [$ok,$msg];

[$ok,$msg] = write_file($INCLUDES . '/db_ref.php', $db_ref_php); $logs[] = [$ok,$msg];
[$ok,$msg] = write_file($REFMOD . '/meta_provider.php', $meta_provider_php); $logs[] = [$ok,$msg];

[$ok,$msg] = write_file($REFMOD . '/save.php', $save_php); $logs[] = [$ok,$msg];
[$ok,$msg] = write_file($REFMOD . '/delete.php', $delete_php); $logs[] = [$ok,$msg];

if (!is_file($REFDATA . '/references.json')) {
  [$ok,$msg] = write_file($REFDATA . '/references.json', "[]"); $logs[] = [$ok,$msg];
} else {
  $logs[] = [true, "exists: modules/reference/data/references.json"];
}

[$ok,$msg] = write_file($PAGES . '/reference_add.php', $reference_add_page); $logs[] = [$ok,$msg];
[$ok,$msg] = write_file($PAGES . '/reference_library.php', $reference_library_page); $logs[] = [$ok,$msg];

[$menuOk,$menuMsg] = try_patch_menu($ADMIN_ROOT);
$logs[] = [$menuOk, $menuMsg];

[$routeOk,$routeMsg] = try_patch_router($ADMIN_ROOT);
$logs[] = [$routeOk, $routeMsg];

$manual = [];
if (!$menuOk) {
  $manual[] = "MENÜ: admin/includes/layout_side.php içine bir <li> ekle: index.php?p=reference_library";
}
if (!$routeOk) {
  $manual[] = "ROUTER: admin/index.php içinde p/page loader'ına şu 2 page'i bağla: reference_library => pages/reference_library.php, reference_add => pages/reference_add.php";
}

$cleanup = isset($_GET['cleanup']) && $_GET['cleanup'] == '1';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Reference Installer</title>
  <style>
    body{font-family:Arial;background:#0b0f14;color:#e6e6e6;padding:18px}
    .ok{color:#2dff7a} .bad{color:#ff4d4d}
    .box{border:1px solid rgba(255,255,255,.12);border-radius:10px;padding:14px;background:rgba(255,255,255,.04);margin-bottom:12px}
    code,pre{background:#0f1620;padding:10px;border-radius:8px;display:block;overflow:auto;color:#b7ffcf}
    a{color:#6cffd7}
  </style>
</head>
<body>

<div class="box">
  <h2>✅ Referans Sistemi Installer</h2>
  <div>Kurulum tamamlandıysa şu sayfaları dene:</div>
  <ul>
    <li><a href="index.php?p=reference_add">Araçlar/ECU • Referans Ekle</a></li>
    <li><a href="index.php?p=reference_library">Referans Kütüphanesi</a></li>
  </ul>
</div>

<div class="box">
  <h3>Log</h3>
  <ul>
    <?php foreach($logs as [$ok,$m]): ?>
      <li class="<?= $ok ? 'ok':'bad' ?>"><?= h(($ok?'OK: ':'FAIL: ') . $m) ?></li>
    <?php endforeach; ?>
  </ul>
</div>

<?php if ($manual): ?>
<div class="box">
  <h3 class="bad">⚠ Otomatik ekleme tamamlanamadı (dosya yapın farklı olabilir)</h3>
  <div>Aşağıdaki 2 şeyi manuel eklemen yeter:</div>
  <pre><?php echo h(implode("\n", $manual)); ?></pre>
</div>
<?php endif; ?>

<div class="box">
  <h3>İzinler</h3>
  <div>cPanel’de şu klasörlere 777 ver (yoksa bin upload’da sorun olur):</div>
  <pre>admin/modules/reference/data/
admin/modules/reference/uploads/</pre>
</div>

<div class="box">
  <h3>Installer’ı sil</h3>
  <div>Her şey çalışıyorsa güvenlik için installer’ı sil:</div>
  <pre><a href="?cleanup=1">reference_installer.php?cleanup=1</a></pre>
  <?php
    if ($cleanup) {
      $me = __FILE__;
      if (@unlink($me)) {
        echo "<div class='ok'>Installer silindi ✅</div>";
      } else {
        echo "<div class='bad'>Installer silinemedi ❌ (manuel sil)</div>";
      }
    }
  ?>
</div>

</body>
</html>
