<?php
$dataFile = __DIR__ . "/../modules/reference/data/references.json";
$refs = json_decode(@file_get_contents($dataFile), true);
if (!is_array($refs)) $refs = [];
?>
<div class="card">
  <div class="panelHd">
    <h2>Referans Kütüphanesi</h2>
    <div class="actions">
      <a class="btn" href="?p=reference_add">+ Referans Ekle</a>
    </div>
  </div>

  <div class="pad">
    <table class="table">
      <thead>
        <tr>
          <th>ID</th><th>Marka</th><th>ECU</th><th>Opsiyon</th><th>Eklenme</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($refs as $r): $rid = htmlspecialchars($r['id'] ?? ''); ?>
        <tr class="rowClick" onclick="document.getElementById('d<?= $rid ?>').classList.toggle('open')">
          <td><?= $rid ?></td>
          <td><?= htmlspecialchars(implode(', ', $r['brand'] ?? [])) ?></td>
          <td><?= htmlspecialchars(implode(', ', $r['ecu'] ?? [])) ?></td>
          <td><?= htmlspecialchars(implode(', ', $r['option'] ?? [])) ?></td>
          <td><?= htmlspecialchars($r['date'] ?? '') ?></td>
        </tr>
        <tr id="d<?= $rid ?>" class="rowDetail">
          <td colspan="5">
            <div style="display:flex;justify-content:space-between;gap:12px;align-items:center;flex-wrap:wrap;">
              <div>
                <b><?= htmlspecialchars($r['name'] ?? '') ?></b><br>
                <a href="modules/reference/uploads/<?= $rid ?>/original.bin">Original</a>
                <?php if (file_exists(__DIR__ . "/../modules/reference/uploads/$rid/modified.bin")): ?>
                  | <a href="modules/reference/uploads/<?= $rid ?>/modified.bin">Modified</a>
                <?php endif; ?>
              </div>
              <a class="btn r" href="modules/reference/delete.php?id=<?= $rid ?>" onclick="return confirm('Silinsin mi?')">Sil</a>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>

    <?php if (!$refs): ?>
      <div class="muted" style="margin-top:10px;">Henüz referans yok. “+ Referans Ekle” ile başla.</div>
    <?php endif; ?>
  </div>
</div>

<style>
.rowClick{cursor:pointer;}
.rowDetail{display:none;}
.rowDetail.open{display:table-row;}
</style>