<?php
require_once __DIR__ . "/../modules/reference/meta_provider.php";
[$brands,$ecus,$brandCol,$ecuCol] = ref_get_brand_ecu_lists();
$opts = ["DPF OFF","EGR OFF","ADBLUE OFF","STAGE 1","STAGE 2"];
?>
<div class="card">
  <div class="panelHd">
    <h2>Araçlar / ECU • Referans Ekle</h2>
    <div class="actions"><span class="chip">DB: panel_vehicle_meta</span></div>
  </div>

  <div class="pad">
    <div class="muted" style="margin-bottom:10px;">
      MarkaKolon: <b><?= htmlspecialchars($brandCol ?? 'BULUNAMADI') ?></b> —
      ECUKolon: <b><?= htmlspecialchars($ecuCol ?? 'BULUNAMADI') ?></b>
    </div>

    <form class="formGrid" action="modules/reference/save.php" method="post" enctype="multipart/form-data">
      <div>
        <label class="lbl">Name</label>
        <input class="in" type="text" name="name" required>
      </div>

      <div>
        <label class="lbl">MARKA</label>
        <div class="checkWrap">
          <?php foreach($brands as $b): ?>
            <label class="chk"><input type="checkbox" name="brand[]" value="<?= htmlspecialchars($b) ?>"> <?= htmlspecialchars($b) ?></label>
          <?php endforeach; ?>
          <?php if(!$brands): ?><div class="muted">Marka listesi boş (DB/kolon kontrol)</div><?php endif; ?>
        </div>
      </div>

      <div>
        <label class="lbl">ECU</label>
        <div class="checkWrap">
          <?php foreach($ecus as $e): ?>
            <label class="chk"><input type="checkbox" name="ecu[]" value="<?= htmlspecialchars($e) ?>"> <?= htmlspecialchars($e) ?></label>
          <?php endforeach; ?>
          <?php if(!$ecus): ?><div class="muted">ECU listesi boş (DB/kolon kontrol)</div><?php endif; ?>
        </div>
      </div>

      <div>
        <label class="lbl">Opsiyonlar</label>
        <div class="checkWrap">
          <?php foreach($opts as $o): ?>
            <label class="chk"><input type="checkbox" name="option[]" value="<?= htmlspecialchars($o) ?>"> <?= htmlspecialchars($o) ?></label>
          <?php endforeach; ?>
        </div>
      </div>

      <div>
        <label class="lbl">Original bin</label>
        <input class="in" type="file" name="ori" required>
      </div>

      <div>
        <label class="lbl">Modified bin</label>
        <input class="in" type="file" name="mod">
      </div>

      <div style="grid-column:1/-1;display:flex;gap:10px;justify-content:flex-end;">
        <button class="btn g" type="submit">Kaydet (Öğret)</button>
        <a class="btn" href="?p=reference_library">Kütüphaneye Git</a>
      </div>
    </form>
  </div>
</div>