<?php require_once __DIR__ . "/../includes/auth.php"; ?>
<div class="card">
  <div class="panelHd">
    <h2>Kütüphane / Profiller</h2>
    <div class="actions"><span class="badge b">admin</span></div>
  </div>
  <div class="pad">
    <div class="muted">Profiler listesi, silme ve meta güncelleme.</div>

    <div style="display:flex;gap:10px;flex-wrap:wrap;margin:12px 0;">
      <button class="btn" onclick="loadProfiles()">Profilleri Yükle</button>
      <span class="chip">Toplam: <b id="pCount">0</b></span>
    </div>

    <div class="grid2">
      <div class="card" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>Profil Listesi</h2>
          <div class="actions"><span class="chip">get_profiles</span></div>
        </div>
        <div class="pad">
          <div class="formRow">
            <label>Seç</label>
            <select id="pSel" class="select" size="12" onchange="pickProfile()"></select>
          </div>
          <div style="display:flex;gap:10px;flex-wrap:wrap;margin-top:10px;">
            <button class="btn ghost" onclick="deleteProfile()">Sil</button>
            <button class="btn" onclick="loadDetail()">Detay</button>
          </div>
        </div>
      </div>

      <div class="card" style="box-shadow:none;">
        <div class="panelHd" style="border-bottom:1px solid rgba(255,255,255,.08);">
          <h2>Meta Güncelle</h2>
          <div class="actions"><span class="chip">admin_profile_update_meta</span></div>
        </div>
        <div class="pad">
          <div class="grid2">
            <div class="formRow"><label>Marka</label><input id="mBrand" class="input"></div>
            <div class="formRow"><label>ECU</label><input id="mEcu" class="input"></div>
          </div>
          <div class="grid2">
            <div class="formRow"><label>Grup</label><input id="mGroup" class="input"></div>
            <div class="formRow"><label>Paket ID</label><input id="mPack" class="input"></div>
          </div>
          <button class="btn" onclick="saveMeta()">Meta Kaydet</button>

          <div class="formRow" style="margin-top:10px;">
            <label>Detay JSON</label>
            <pre id="detail" class="pre"></pre>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>

<script>
const API = "modules/dtc_admin/api.php";
let PROFILES = [];
function q(id){ return document.getElementById(id); }
function toast2(t){ if(window.toast) toast(t); else alert(t); }
function selVal(){ const o=q("pSel").selectedOptions[0]; return o?o.value:""; }

async function loadProfiles(){
  const fd = new FormData();
  fd.append("action","get_profiles");
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  if(j.status!=="ok"){ toast2(j.msg||"Hata"); return; }
  PROFILES = j.profiles || [];
  q("pCount").textContent = PROFILES.length;
  const s = q("pSel");
  s.innerHTML = "";
  PROFILES.forEach(p=>{
    const o = document.createElement("option");
    o.value = p.id;
    o.textContent = `#${p.id} • ${p.name}`;
    s.appendChild(o);
  });
  toast2("Yüklendi");
}

function pickProfile(){
  // clear
  q("detail").textContent = "";
}

async function deleteProfile(){
  const id = selVal();
  if(!id){ toast2("Profil seç"); return; }
  if(!confirm("Profil silinsin mi? (#"+id+")")) return;
  const fd = new FormData();
  fd.append("action","delete_profile");
  fd.append("id", id);
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  q("detail").textContent = JSON.stringify(j, null, 2);
  if(j.status==="ok"){ toast2("Silindi"); loadProfiles(); }
  else toast2(j.msg||"Hata");
}

async function loadDetail(){
  const id = selVal();
  if(!id){ toast2("Profil seç"); return; }
  const fd = new FormData();
  fd.append("action","admin_profile_detail");
  fd.append("id", id);
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  q("detail").textContent = JSON.stringify(j, null, 2);
  if(j.status!=="ok"){ toast2(j.msg||"Hata"); return; }
  const p = j.profile || {};
  q("mBrand").value = p.brand || "";
  q("mEcu").value = p.ecu_model || "";
  q("mGroup").value = p.brand_group || "";
  q("mPack").value = p.package_id || "";
}

async function saveMeta(){
  const id = selVal();
  if(!id){ toast2("Profil seç"); return; }
  const fd = new FormData();
  fd.append("action","admin_profile_update_meta");
  fd.append("id", id);
  fd.append("brand", q("mBrand").value.trim());
  fd.append("ecu_model", q("mEcu").value.trim());
  fd.append("brand_group", q("mGroup").value.trim());
  fd.append("package_id", q("mPack").value.trim());
  const r = await fetch(API, {method:"POST", body: fd});
  const j = await r.json();
  q("detail").textContent = JSON.stringify(j, null, 2);
  if(j.status==="ok"){ toast2("Güncellendi"); }
  else toast2(j.msg||"Hata");
}

loadProfiles();
</script>
