<?php
require_once __DIR__ . "/../../includes/db_ref.php";

function ref_find_meta_columns(mysqli $db): array {
    $cols = [];
    $res = $db->query("SHOW COLUMNS FROM panel_vehicle_meta");
    if (!$res) { error_log("[REF META] panel_vehicle_meta okunamadı: " . $db->error); return [null, null]; }

    while ($row = $res->fetch_assoc()) $cols[] = $row['Field'];

    $brandCol = null; $ecuCol = null;

    foreach ($cols as $c) {
        $lc = strtolower($c);
        if (strpos($lc,'marka') !== false || strpos($lc,'brand') !== false || $lc==='make') { $brandCol=$c; break; }
    }
    foreach ($cols as $c) {
        $lc = strtolower($c);
        if ($lc==='ecu' || strpos($lc,'ecu') !== false) { $ecuCol=$c; break; }
    }
    return [$brandCol, $ecuCol];
}

function ref_get_brand_ecu_lists(): array {
    $db = ref_db();
    [$brandCol, $ecuCol] = ref_find_meta_columns($db);

    $brands=[]; $ecus=[];

    if ($brandCol) {
        $q="SELECT DISTINCT `{$brandCol}` AS v FROM panel_vehicle_meta WHERE `{$brandCol}` IS NOT NULL AND `{$brandCol}`<>'' ORDER BY `{$brandCol}`";
        $r=$db->query($q);
        if ($r) while($row=$r->fetch_assoc()) $brands[]=$row['v'];
        else error_log("[REF META BRAND SQL] ".$db->error);
    }
    if ($ecuCol) {
        $q="SELECT DISTINCT `{$ecuCol}` AS v FROM panel_vehicle_meta WHERE `{$ecuCol}` IS NOT NULL AND `{$ecuCol}`<>'' ORDER BY `{$ecuCol}`";
        $r=$db->query($q);
        if ($r) while($row=$r->fetch_assoc()) $ecus[]=$row['v'];
        else error_log("[REF META ECU SQL] ".$db->error);
    }

    return [$brands, $ecus, $brandCol, $ecuCol];
}